/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.component.std.Box;
import aurora.presentation.component.std.config.FieldSetConfig;
import java.io.Writer;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;

public class FieldSet
extends Box {
    public static final String VERSION = "$Revision: 7765 $";
    private static final String DEFAULT_BODY_CLASS = "form_body";

    public FieldSet(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    protected void buildHead(BuildSession session, CompositeMap model, CompositeMap view, int rows, int columns) throws Exception {
        Writer out = session.getWriter();
        FieldSetConfig fsc = FieldSetConfig.getInstance(view);
        String title = fsc.getTitle();
        title = session.getLocalizedPrompt(title);
        out.write("<LEGEND class='field_head' unselectable='on'><SPAN>");
        out.write(title);
        out.write("</SPAN></LEGEND>");
    }

    @Override
    protected void afterBuildTop(BuildSession session, CompositeMap model, CompositeMap view, int columns) throws Exception {
        Writer out = session.getWriter();
        out.write("<tbody class='form_body'>");
        super.afterBuildTop(session, model, view, columns);
    }

    @Override
    protected void buildTop(BuildSession session, CompositeMap model, CompositeMap view, Map map, int rows, int columns, String id) throws Exception {
        FieldSetConfig fsc = FieldSetConfig.getInstance(view);
        Writer out = session.getWriter();
        String cls = fsc.getClassName("");
        String style = fsc.getStyle("");
        int width = this.getComponentWidth(model, view, map);
        int height = this.getComponentHeight(model, view, map);
        int cellspacing = fsc.getCellSpacing(model);
        int cellpadding = fsc.getCellPadding(model);
        String className = "layout-table";
        String title = fsc.getTitle();
        if (!"".equals(title)) {
            className = String.valueOf(className) + " layout-title";
        }
        className = String.valueOf(className) + " " + cls;
        out.write("<FIELDSET class='item-fieldset' id='" + id + "'");
        StringBuffer sb = new StringBuffer();
        if (!"".equals(style)) {
            sb.append(style);
        }
        if (width != 0) {
            sb.append("width:" + (width - 2) + "px;");
        }
        if (height != 0) {
            sb.append("height:" + height + "px;");
        }
        if (sb.length() != 0) {
            out.write(" style='" + sb.toString() + "'");
        }
        out.write(">");
        this.buildHead(session, model, view, rows, columns);
        out.write("<table width='100%' border=0");
        out.write(" cellpadding=" + cellpadding + " cellspacing=" + cellspacing + ">");
        this.afterBuildTop(session, model, view, columns);
    }

    @Override
    protected void buildBottom(BuildSession session, CompositeMap model, CompositeMap view, int columns) throws Exception {
        this.buildFoot(session, model, view, columns);
        Writer out = session.getWriter();
        String showmargin = view.getString((Object)"showmargin", "true");
        if ("true".equals(showmargin)) {
            out.write("<tr height='5'><td colspan=" + columns * 2 + "></td></tr>");
        }
        out.write("</tbody>");
        out.write("</table>");
        out.write("</FIELDSET>");
    }
}

