/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Field;
import aurora.presentation.component.std.config.ButtonConfig;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class Button
extends Field {
    public static final String VERSION = "$Revision: 7794 $";
    private String CLASSNAME_WRAP = "item-btn";
    private String PROPERTITY_TEXT_HEIGHT = "text_height";
    private int DEFAULT_HEIGHT = 16;
    private int DEFAULT_WIDTH = 60;
    private int DEFAULT_ALIGN_TOP_HEIGHT = 36;
    private int DEFAULT_ALIGN_TOP_WIDTH = 50;
    private boolean isAlignTop = false;

    public Button(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    protected int getDefaultWidth() {
        return this.isAlignTop ? this.DEFAULT_ALIGN_TOP_WIDTH : this.DEFAULT_WIDTH;
    }

    @Override
    protected int getDefaultHeight() {
        return this.isAlignTop ? this.DEFAULT_ALIGN_TOP_HEIGHT : this.DEFAULT_HEIGHT;
    }

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        CompositeMap view = context.getView();
        ButtonConfig bc = ButtonConfig.getInstance(view);
        String text = bc.getText();
        String icon = bc.getIcon();
        String align = bc.getIconAlign();
        String wrapClass = this.CLASSNAME_WRAP;
        if (!"".equals(icon)) {
            if (!"".equals(text)) {
                if ("top".equals(align)) {
                    this.isAlignTop = true;
                    wrapClass = String.valueOf(wrapClass) + " item-btn-icon-text-top";
                } else {
                    wrapClass = String.valueOf(wrapClass) + " item-btn-icon-text";
                }
            } else {
                wrapClass = String.valueOf(wrapClass) + " item-btn-icon";
            }
        }
        return wrapClass;
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        CompositeMap model = context.getModel();
        CompositeMap view = context.getView();
        ButtonConfig bc = ButtonConfig.getInstance(view);
        Map map = context.getMap();
        String clickEvent = bc.getClick();
        if (!"".equals(clickEvent)) {
            if (clickEvent.indexOf("${") != -1) {
                clickEvent = TextParser.parse((String)clickEvent, (CompositeMap)model);
            }
            this.addEvent(this.id, "click", clickEvent);
        }
        String text = "".equals(bc.getText()) ? "&#160;" : bc.getText();
        text = session.getLocalizedPrompt(text);
        boolean disabled = bc.getDisabled();
        if (disabled) {
            this.addConfig("disabled", disabled);
        }
        String icon = bc.getIcon();
        String btnstyle = bc.getButtonStyle();
        if (!"".equals(icon) && !"null".equalsIgnoreCase(icon)) {
            btnstyle = String.valueOf(btnstyle) + "background-image:url(" + TextParser.parse((String)icon, (CompositeMap)model) + ");";
        }
        Integer text_height = (Integer)map.get("height");
        if (this.isAlignTop) {
            text_height = null;
        }
        map.put(this.PROPERTITY_TEXT_HEIGHT, text_height);
        map.put("text", text);
        map.put("btnclass", bc.getButtonClass());
        map.put("title", bc.getTitle());
        map.put("tabindex", bc.getTabIndex());
        map.put("btnstyle", btnstyle);
        map.put("config", this.getConfigString());
    }
}

