/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component;

import aurora.application.ApplicationConfig;
import aurora.application.ApplicationViewConfig;
import aurora.application.IApplicationConfig;
import aurora.presentation.BuildSession;
import aurora.presentation.IViewBuilder;
import aurora.presentation.ViewContext;
import aurora.presentation.ViewCreationException;
import aurora.presentation.component.TemplateRenderer;
import aurora.presentation.component.ViewContextTagCreator;
import aurora.presentation.component.std.IDGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;
import uncertain.util.template.CompositeMapTagCreator;
import uncertain.util.template.ITagContent;
import uncertain.util.template.ITagCreator;
import uncertain.util.template.ITagCreatorRegistry;
import uncertain.util.template.TagCreatorRegistry;
import uncertain.util.template.TextTemplate;

public class HtmlPage
implements IViewBuilder {
    public static final String EVENT_PREPARE_PAGE_CONTENT = "PreparePageContent";
    public static final String KEY_MANIFEST = "manifest";
    public static final String KEY_TITLE = "title";
    private IObjectRegistry mRegistry;
    private ApplicationConfig mApplicationConfig;

    public HtmlPage(IObjectRegistry registry) {
        this.mRegistry = registry;
        this.mApplicationConfig = (ApplicationConfig)this.mRegistry.getInstanceOfType(IApplicationConfig.class);
    }

    protected ITagCreatorRegistry createTagCreatorRegistry(BuildSession session, ViewContext view_context) {
        HtmlPageTagCreator creator = new HtmlPageTagCreator(session, view_context);
        TagCreatorRegistry reg = new TagCreatorRegistry();
        reg.setDefaultCreator((ITagCreator)CompositeMapTagCreator.DEFAULT_INSTANCE);
        reg.registerTagCreator("page", (ITagCreator)creator);
        reg.setParent(session.getPresentationManager().getTagCreatorRegistry());
        return reg;
    }

    @Override
    public void buildView(BuildSession session, ViewContext view_context) throws IOException, ViewCreationException {
        try {
            String mManifest;
            String title;
            ApplicationViewConfig view_config;
            CompositeMap model = view_context.getModel();
            CompositeMap view = view_context.getView();
            String pageid = IDGenerator.getInstance().generate();
            String defaultTitle = "";
            if (this.mApplicationConfig != null && (view_config = this.mApplicationConfig.getApplicationViewConfig()) != null) {
                defaultTitle = view_config.getDefaultTitle();
            }
            if ((title = view.getString((Object)KEY_TITLE, defaultTitle)) != null) {
                title = session.getLocalizedPrompt(title);
                title = TextParser.parse((String)title, (CompositeMap)model);
                view_context.getContextMap().put((Object)KEY_TITLE, (Object)title);
            }
            if ((mManifest = view.getString((Object)KEY_MANIFEST)) != null) {
                view_context.getContextMap().put((Object)KEY_MANIFEST, (Object)("manifest=\"" + mManifest + "\""));
            }
            view_context.getContextMap().put((Object)"pageid", (Object)pageid);
            view_context.getContextMap().put((Object)"contextPath", (Object)session.getContextPath());
            session.getSessionContext().put((Object)"pageid", (Object)pageid);
            session.fireBuildEvent(EVENT_PREPARE_PAGE_CONTENT, view_context, true);
        }
        catch (Exception ex) {
            throw new ViewCreationException("Error when fire 'PreparePageContent' event", ex);
        }
        ITagCreatorRegistry reg = this.createTagCreatorRegistry(session, view_context);
        TextTemplate template = TemplateRenderer.getViewTemplate(session, view_context, reg);
        try {
            template.createOutput(session.getWriter(), view_context.getModel());
        }
        finally {
            template.clear();
        }
    }

    @Override
    public String[] getBuildSteps(ViewContext context) {
        return null;
    }

    public static class HtmlPageTagCreator
    extends ViewContextTagCreator {
        BuildSession _session;

        public HtmlPageTagCreator(BuildSession _session, ViewContext context) {
            super(context);
            this._session = _session;
        }

        @Override
        public ITagContent createInstance(String namespace, String tag) {
            if ("content".equals(tag)) {
                ViewContext context = this.getViewContext();
                CompositeMap model = context.getModel();
                List view_list = context.getView().getChilds();
                return new PageContentTag(this._session, model, view_list);
            }
            return super.createInstance(namespace, tag);
        }
    }

    public static class PageContentTag
    implements ITagContent {
        BuildSession _session;
        CompositeMap model;
        Collection view_list;

        public PageContentTag(BuildSession _session, CompositeMap model, Collection view_list) {
            this._session = _session;
            this.model = model;
            this.view_list = view_list;
        }

        public String getContent(CompositeMap context) {
            try {
                this._session.buildViews(this.model, this.view_list);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return null;
        }
    }
}

