/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.api.statistics.map;

import aurora.ide.api.statistics.IStatisticsManager;
import aurora.ide.api.statistics.IStatisticsReporter;
import aurora.ide.api.statistics.Statistician;
import aurora.ide.api.statistics.map.StatisticsMap;
import aurora.ide.api.statistics.model.Dependency;
import aurora.ide.api.statistics.model.ProjectObject;
import java.util.ArrayList;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.IterationHandle;
import uncertain.composite.QualifiedName;
import uncertain.schema.Attribute;
import uncertain.schema.Element;
import uncertain.schema.ISchemaManager;
import uncertain.schema.IType;
import uncertain.schema.SimpleType;

public class ProjectObjectIteator
implements IterationHandle {
    private ProjectObject po;
    private IStatisticsReporter reporter;
    private Statistician statistician;
    private IStatisticsManager statisticsManager;
    private List<ProjectObject> poList;

    public ProjectObjectIteator(Statistician statistician, ProjectObject po, List<ProjectObject> poList) {
        this.statistician = statistician;
        this.statisticsManager = statistician.getStatisticsManager();
        this.po = po;
        this.poList = poList;
    }

    public void process(IStatisticsReporter reporter) {
        this.reporter = reporter;
        CompositeMap rootMap = this.po.getRootMap();
        rootMap.iterate((IterationHandle)this, true);
    }

    public int process(CompositeMap map) {
        StatisticsMap sm = new StatisticsMap(map);
        this.report(sm);
        return 0;
    }

    private void report(StatisticsMap sm) {
        if (sm.isRoot()) {
            this.reporter.reportRoot(this.po, sm);
        }
        if (sm.isTag()) {
            this.reporter.reportTag(this.po, sm);
        }
        if (this.isScript(this.po, sm)) {
            this.reporter.reportScript(this.po, sm);
        }
        this.reporter.reportDependency(this.po, this.getDependency(this.po, sm));
    }

    private boolean isScript(ProjectObject po, StatisticsMap sm) {
        if ("script".equalsIgnoreCase(sm.getName())) {
            return true;
        }
        Element element = this.getElement(sm.getMap());
        if (element == null) {
            return false;
        }
        if (element.getType() != null && element.getElementType() instanceof SimpleType && IStatisticsManager.RawSql.equals((Object)element.getElementType().getQName())) {
            return true;
        }
        return this.isAttributeType(sm, IStatisticsManager.RawSql);
    }

    public Element getElement(CompositeMap map) {
        try {
            ISchemaManager schemaManager = this.statistician.getSchemaManager();
            return schemaManager.getElement(map);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private boolean isAttributeType(StatisticsMap sm, QualifiedName qName) {
        Element element = this.getElement(sm.getMap());
        if (element != null) {
            List attrib_list = element.getAllAttributes();
            for (Attribute attrib : attrib_list) {
                IType attributeType = attrib.getAttributeType();
                if (attributeType == null || !qName.equals((Object)attributeType.getQName()) || this.statisticsManager.getValueIgnoreCase(attrib, sm.getMap()) == null) continue;
                return true;
            }
        }
        return false;
    }

    private List<Dependency> getDependency(ProjectObject po, StatisticsMap sm) {
        ArrayList<Dependency> dependencys = new ArrayList<Dependency>();
        dependencys.addAll(this.statisticsManager.getDependency(po, this.poList, sm, IStatisticsManager.BmReference));
        dependencys.addAll(this.statisticsManager.getDependency(po, this.poList, sm, IStatisticsManager.ScreenReference));
        dependencys.addAll(this.statisticsManager.getDependency(po, this.poList, sm, IStatisticsManager.UrlReference));
        return dependencys;
    }
}

