/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.api.statistics;

import aurora.ide.api.statistics.DatabaseAction;
import aurora.ide.api.statistics.IRunningListener;
import aurora.ide.api.statistics.IStatisticsManager;
import aurora.ide.api.statistics.IStatisticsReporter;
import aurora.ide.api.statistics.Status;
import aurora.ide.api.statistics.map.ProjectObjectIteator;
import aurora.ide.api.statistics.map.StatisticsMap;
import aurora.ide.api.statistics.map.StatisticsResult;
import aurora.ide.api.statistics.model.Dependency;
import aurora.ide.api.statistics.model.ProjectObject;
import aurora.ide.api.statistics.model.StatisticsProject;
import aurora.ide.api.statistics.model.Tag;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uncertain.schema.ISchemaManager;

public class Statistician
implements IStatisticsReporter {
    private StatisticsProject project;
    private StatisticsResult result = new StatisticsResult();
    private List<ProjectObject> poList = new LinkedList<ProjectObject>();
    private ISchemaManager schemaManager;
    private IStatisticsManager statisticsManager;
    private boolean isDependecyContainJS;
    private List<IRunningListener> runnningListeners;
    private Map<String, List<String>> reference = new HashMap<String, List<String>>();
    private Map<String, Integer> referenced = new HashMap<String, Integer>();

    public void setDependecyContainJS(boolean isDependecyContainJS) {
        this.isDependecyContainJS = isDependecyContainJS;
    }

    public Statistician(StatisticsProject project, ISchemaManager schemaManager, IStatisticsManager statisticsManager) {
        this.project = project;
        this.result.setProject(project);
        this.schemaManager = schemaManager;
        this.setStatisticsManager(statisticsManager);
    }

    public void addProjectObject(ProjectObject po) {
        this.poList.add(po);
        this.result.addProjectObject(po);
        po.setProject(this.project);
    }

    public ISchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    public void setSchemaManager(ISchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public IStatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }

    public void setStatisticsManager(IStatisticsManager statisticsManager) {
        this.statisticsManager = statisticsManager;
    }

    public StatisticsProject getProject() {
        return this.project;
    }

    public void setProject(StatisticsProject project) {
        this.project = project;
    }

    public StatisticsResult getResult() {
        return this.result;
    }

    public void setResult(StatisticsResult result) {
        this.result = result;
    }

    public List<IRunningListener> getRunningListeners() {
        return this.runnningListeners;
    }

    public void addRuningListener(IRunningListener l) {
        if (this.runnningListeners == null) {
            this.runnningListeners = new ArrayList<IRunningListener>();
        }
        this.runnningListeners.add(l);
    }

    private boolean noticeRunning(ProjectObject po, int poIndex) {
        if (this.runnningListeners != null) {
            for (IRunningListener l : this.runnningListeners) {
                if (l.notice(po, poIndex)) continue;
                return false;
            }
        }
        return true;
    }

    public List<ProjectObject> getPoList() {
        return this.poList;
    }

    public void setPoList(List<ProjectObject> poList) {
        this.poList = poList;
    }

    public StatisticsResult doStatistic() {
        int i = 0;
        for (ProjectObject po : this.poList) {
            if (!this.noticeRunning(po, i)) {
                return this.result;
            }
            ProjectObjectIteator it = new ProjectObjectIteator(this, po, this.poList);
            it.process(this);
            ++i;
        }
        this.fillReferenced();
        for (ProjectObject po : this.result.getProjectObjects()) {
            if (this.referenced.get(po.getPath()) == null) continue;
            po.setReferenced(this.referenced.get(po.getPath()));
        }
        return this.result;
    }

    public Status save(Connection connection) {
        DatabaseAction action = new DatabaseAction(this);
        return action.saveAll(connection);
    }

    public StatisticsResult read(Connection connection) throws SQLException {
        DatabaseAction action = new DatabaseAction(this);
        return action.readAll(connection);
    }

    @Override
    public void reportRoot(ProjectObject po, StatisticsMap sm) {
        po.setFileSize(sm.getSize());
    }

    @Override
    public void reportDependency(ProjectObject po, List<Dependency> Dependencys) {
        for (Dependency d : Dependencys) {
            if (this.reference.get(po.getPath()) == null) {
                this.reference.put(po.getPath(), new ArrayList());
            }
            this.reference.get(po.getPath()).add(d.getDependencyObject().getPath());
            d.setProject(this.project);
            d.setObject(po);
            po.addDependency(d);
        }
    }

    @Override
    public void reportTag(ProjectObject po, StatisticsMap sm) {
        Tag tag = new Tag(sm);
        tag.setProject(this.project);
        tag.setObject(po);
        po.addTag(tag);
    }

    @Override
    public void reportScript(ProjectObject po, StatisticsMap sm) {
        int size = sm.getSize();
        po.appendScriptSize(size);
    }

    private void fillReferenced() {
        for (List<String> list : this.reference.values()) {
            for (String s : list) {
                this.referenced.put(s, this.referenced.get(s) == null ? 1 : this.referenced.get(s) + 1);
            }
        }
    }

    public boolean isDependecyContainJS() {
        return this.isDependecyContainJS;
    }
}

