/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.sql;

import aurora.database.sql.AbstractStatement;
import aurora.database.sql.ILogicalExpression;
import aurora.database.sql.ISqlStatement;

public class CompareExpression
extends AbstractStatement
implements ILogicalExpression {
    public static final int EQUAL = 1;
    public static final int NOT_EQUAL = 2;
    public static final int LESS_THAN = 3;
    public static final int LESS_OR_EQUAL = 4;
    public static final int GREATER_THAN = 5;
    public static final int GREATER_OR_EQUAL = 6;
    public static final int LIKE = 7;
    public static final int NOT_LIKE = 8;
    public static final int IS_NULL = 9;
    public static final int IS_NOT_NULL = 10;
    static final String[] DEFAULT_OPERATOR_TEXT_ARRAY = new String[]{"", "=", "<>", "<", "<=", ">", ">=", "LIKE", "NOT LIKE", "IS NULL", "IS NOT NULL"};
    public static final String EXPRESSION = "EXPRESSION";
    ISqlStatement leftField;
    ISqlStatement rightField;
    int operator;

    public static boolean isValidOperator(int operator) {
        return operator >= 1 && operator <= 10;
    }

    public static int getOperatorID(String op_text) {
        int i = 1;
        while (i < DEFAULT_OPERATOR_TEXT_ARRAY.length) {
            if (DEFAULT_OPERATOR_TEXT_ARRAY[i].equalsIgnoreCase(op_text)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isSingleOperator(int operator) {
        return operator == 9 || operator == 10;
    }

    public static String getOperatorText(int operator) {
        return DEFAULT_OPERATOR_TEXT_ARRAY[operator];
    }

    public CompareExpression(ISqlStatement leftField, int operator, ISqlStatement rightField) {
        super(EXPRESSION);
        this.leftField = leftField;
        this.rightField = rightField;
        this.operator = operator;
    }

    public ISqlStatement getLeftField() {
        return this.leftField;
    }

    public void setLeftField(ISqlStatement leftField) {
        this.leftField = leftField;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int operator) {
        if (!CompareExpression.isValidOperator(operator)) {
            throw new IllegalArgumentException("Illegal operator: " + operator);
        }
        this.operator = operator;
    }

    public ISqlStatement getRightField() {
        return this.rightField;
    }

    public void setRightField(ISqlStatement rightField) {
        this.rightField = rightField;
    }
}

