/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.features;

import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.bm.IModelFactory;
import aurora.bm.Operation;
import aurora.database.DBUtil;
import aurora.database.FetchDescriptor;
import aurora.database.ParsedSql;
import aurora.database.ResultSetLoader;
import aurora.database.SqlRunner;
import aurora.database.features.MultiLanguageDisplay;
import aurora.database.profile.IDatabaseFactory;
import aurora.database.rsconsumer.CompositeMapCreator;
import aurora.database.service.BusinessModelService;
import aurora.database.service.BusinessModelServiceContext;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uncertain.composite.CompositeMap;
import uncertain.logging.LoggingContext;

public class MultiLanguageStorage
extends MultiLanguageDisplay {
    public MultiLanguageStorage(IModelFactory modelFactory, IDatabaseFactory databaseFactory) throws IOException {
        super(modelFactory, databaseFactory);
    }

    public void preCreateInsertStatement(BusinessModel model, BusinessModelServiceContext context) throws Exception {
        if (!this.hasMlFields) {
            return;
        }
        if (this.mLogger == null) {
            this.mLogger = LoggingContext.getLogger((CompositeMap)context.getObjectContext(), (String)"aurora.database");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        Field[] fields = model.getFields();
        int count = 0;
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (field.getMultiLanguage()) {
                if (count != 0) {
                    sql.append(",");
                }
                sql.append(String.valueOf(this.sequence) + " as " + field.getName());
                ++count;
            }
            ++i;
        }
        sql.append(" from dual");
        ParsedSql s = new ParsedSql(sql.toString());
        SqlRunner runner = new SqlRunner(context, s);
        runner.setConnectionName(context.getBusinessModel().getDataSourceName());
        ResultSet rs = null;
        try {
            rs = runner.query(new CompositeMap());
            ResultSetLoader loader = new ResultSetLoader();
            loader.setFieldNameCase((byte)2);
            FetchDescriptor desc = FetchDescriptor.fetchAll();
            CompositeMapCreator consumer = new CompositeMapCreator();
            loader.loadByResultSet(rs, desc, consumer);
            CompositeMap result = consumer.getCompositeMap();
            CompositeMap currParamMap = context.getCurrentParameter();
            List list = result.getChilds();
            CompositeMap child = (CompositeMap)list.get(0);
            Set kSet = child.keySet();
            for (String key : kSet) {
                currParamMap.put((Object)key, child.get((Object)key));
            }
            context.setCurrentParameter((Map)currParamMap);
        }
        finally {
            DBUtil.printTraceInfo("MultiLanguageStorage Insert", this.mLogger, runner);
            DBUtil.closeResultSet(rs);
        }
    }

    public void postExecuteDmlStatement(BusinessModelServiceContext context) throws Exception {
        if (!this.hasMlFields) {
            return;
        }
        BusinessModel model = context.getBusinessModel();
        String operation = context.getOperation();
        Field[] fields = model.getFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!field.isReferenceField() && field.getMultiLanguage()) {
                if ("insert".equalsIgnoreCase(operation.toLowerCase()) && field.isForInsert() && model.getOperation("insert") == null) {
                    this.createMultiLanguageSql(context, field, "update");
                } else if ("update".equalsIgnoreCase(operation.toLowerCase()) && field.isForUpdate() && model.getOperation("update") == null) {
                    this.createMultiLanguageSql(context, field, "update");
                } else {
                    this.createMultiLanguageSql(context, field, "delete");
                }
            }
            ++i;
        }
    }

    void createMultiLanguageSql(BusinessModelServiceContext context, Field mlFiled, String operation) throws Exception {
        if (this.mLogger == null) {
            this.mLogger = LoggingContext.getLogger((CompositeMap)context.getObjectContext(), (String)"aurora.database");
        }
        CompositeMap currentParameter = context.getCurrentParameter();
        BusinessModel bm = context.getBusinessModel();
        currentParameter.putString((Object)this.refTable, bm.getBaseTable().toUpperCase());
        currentParameter.putString((Object)this.refField, mlFiled.getName().toUpperCase());
        currentParameter.putString((Object)this.mlDescription, currentParameter.getString((Object)mlFiled.getMultiLanguageDescField()));
        currentParameter.putString((Object)this.pkId, currentParameter.getString((Object)mlFiled.getName()));
        Operation op = this.mlModel.getOperation(operation);
        String sql = op.getSql();
        ParsedSql s = new ParsedSql();
        s.parse(sql);
        SqlRunner runner = BusinessModelService.createSqlRunner(context, s);
        try {
            runner.update(context.getCurrentParameter());
        }
        finally {
            DBUtil.printTraceInfo("MultiLanguageStorage " + operation, this.mLogger, runner);
        }
    }
}

