/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.actions;

import aurora.transaction.ITransactionService;
import aurora.transaction.UserTransactionImpl;
import java.util.logging.Level;
import javax.transaction.UserTransaction;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureRunner;
import uncertain.util.resource.ILocatable;

public class Transaction
extends Procedure {
    IObjectRegistry mRegistry;

    public Transaction(OCManager om, IObjectRegistry reg) {
        super(om);
        this.mRegistry = reg;
    }

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        ILogger logger = LoggingContext.getLogger((CompositeMap)context, (String)"aurora.database");
        UserTransaction trans = null;
        ITransactionService ts = (ITransactionService)this.mRegistry.getInstanceOfType(ITransactionService.class);
        if (ts == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, ITransactionService.class);
        }
        trans = ts.getUserTransaction();
        if (trans instanceof UserTransactionImpl) {
            ((UserTransactionImpl)trans).setContext(context);
        }
        try {
            try {
                trans.begin();
                logger.config("Transaction begins");
                super.run(runner);
                try {
                    trans.commit();
                    logger.config("Transaction commit");
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Can't execute commit", (Throwable)ex);
                }
            }
            catch (Throwable thr) {
                try {
                    trans.rollback();
                    logger.config("Transaction rollback due to exception");
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Can't execute rollback", (Throwable)ex);
                }
                runner.throwException(thr);
                ts.stop();
            }
        }
        finally {
            ts.stop();
        }
    }
}

