/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.actions;

import aurora.bm.CascadeOperation;
import aurora.bm.DefaultAccessChecker;
import aurora.bm.DisabledOperationException;
import aurora.bm.IBusinessModelAccessChecker;
import aurora.bm.IBusinessModelAccessCheckerFactory;
import aurora.database.SqlRunner;
import aurora.database.actions.AbstractModelAction;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.ServiceOption;
import aurora.database.service.SqlServiceContext;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;
import uncertain.proc.ProcedureRunner;

public class ModelBatchUpdate
extends AbstractModelAction {
    String mSourcePath = "/parameter";
    OCManager mOcManager;
    IObjectRegistry mObjectRegistry;
    IBusinessModelAccessCheckerFactory mModelCheckerFactory;
    IBusinessModelAccessChecker mModelChecker;
    String statusField = "_status";
    Set mEnabledOperations;

    public ModelBatchUpdate(DatabaseServiceFactory factory, OCManager ocManager, IObjectRegistry reg) {
        super(factory);
        this.mOcManager = ocManager;
        this.mObjectRegistry = reg;
        this.mModelCheckerFactory = (IBusinessModelAccessCheckerFactory)this.mObjectRegistry.getInstanceOfType(IBusinessModelAccessCheckerFactory.class);
    }

    void doUpdate(int record_no, CompositeMap item) throws Exception {
        String status = item.getString((Object)this.statusField);
        if (status == null) {
            this.mLogger.warning("No status field in record No." + record_no + ", content:" + item.toXML());
            return;
        }
        status = status.toLowerCase();
        if (this.mEnabledOperations != null && !this.mEnabledOperations.contains(status)) {
            return;
        }
        if (this.mModelChecker != null && !this.mModelChecker.canPerformOperation(status)) {
            throw new DisabledOperationException("Can't perform operation " + status + " on BusinessModel " + this.getModel());
        }
        this.mLogger.log(Level.CONFIG, "execute {0} on record No.{1} for model {2}", new Object[]{status, new Integer(record_no), this.mService.getBusinessModel().getName()});
        if ("insert".equals(status)) {
            this.mService.insert((Map)item);
        } else if ("update".equals(status)) {
            this.mService.updateByPK((Map)item);
        } else if ("delete".equals(status)) {
            this.mService.deleteByPK((Map)item);
        } else if ("execute".equals(status)) {
            this.mService.execute((Map)item);
        } else {
            throw new IllegalArgumentException("Invalid status:'" + status + "' in record " + item.toXML());
        }
    }

    void doBatchUpdateInternal(Collection records, SqlServiceContext svcContext, ModelBatchUpdate[] ba_array) throws Exception {
        this.mLogger.log(Level.CONFIG, "============ Running model batch update with data from path {0}, total {1} records", new Object[]{this.mSourcePath, new Integer(records.size())});
        int mod_count = 0;
        CompositeMap old_current_param = svcContext.getCurrentParameter();
        for (Object obj : records) {
            if (obj == null) {
                this.mLogger.config("Record No." + mod_count + " is null");
                continue;
            }
            if (!(obj instanceof CompositeMap)) {
                throw new IllegalStateException("item in batch source collection should be instance of CompositeMap: " + obj);
            }
            CompositeMap item = (CompositeMap)obj;
            svcContext.setCurrentParameter((Map)item);
            this.doUpdate(mod_count, item);
            if (ba_array != null) {
                int i = 0;
                while (i < ba_array.length) {
                    ModelBatchUpdate mbu = ba_array[i];
                    this.mLogger.config("Performing batch update on child BM, parameter path:" + mbu.getSourcePath());
                    Collection child_records = SqlRunner.getSourceParameter(item, mbu.getSourcePath());
                    if (child_records != null) {
                        mbu.doBatchUpdate(child_records, svcContext.getObjectContext());
                    } else {
                        this.mLogger.config("No data in this path");
                    }
                    ++i;
                }
            }
            ++mod_count;
        }
        this.mLogger.config("============ End of batch update for " + this.mSourcePath);
        if (mod_count > 0) {
            svcContext.setCurrentParameter((Map)old_current_param);
        }
    }

    public void doBatchUpdate(Collection records, CompositeMap context) throws Exception {
        this.prepareRun(context);
        SqlServiceContext svcContext = SqlServiceContext.createSqlServiceContext(context);
        ModelBatchUpdate[] ba_array = null;
        CascadeOperation[] cascade_ops = this.mService.getBusinessModel().getCascadeOperations();
        if (cascade_ops != null) {
            ba_array = new ModelBatchUpdate[cascade_ops.length];
            int i = 0;
            while (i < cascade_ops.length) {
                CascadeOperation op = cascade_ops[i];
                ba_array[i] = new ModelBatchUpdate(this.mServiceFactory, this.mOcManager, this.mObjectRegistry);
                ba_array[i].setSourcePath(op.getInputPath());
                ba_array[i].setModel(op.getModel());
                ba_array[i].setEnabledOperations(op.getEnabledOperations());
                ++i;
            }
            this.mLogger.config("Total " + ba_array.length + " cascade operation(s)");
        }
        if (records != null) {
            this.doBatchUpdateInternal(records, svcContext, ba_array);
        } else {
            this.mLogger.info("[model-batch-update] Data from '" + this.mSourcePath + "' is null");
        }
    }

    @Override
    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap map = runner.getContext();
        if (this.mModelCheckerFactory != null) {
            this.mModelChecker = this.mModelCheckerFactory.getChecker(this.getModel(), map);
            if (this.mModelChecker == null) {
                this.mModelChecker = DefaultAccessChecker.ALWAYS_DENY;
            }
        }
        Collection records = SqlRunner.getSourceParameter(map, this.mSourcePath);
        this.doBatchUpdate(records, map);
    }

    public String getSourcePath() {
        return this.mSourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.mSourcePath = sourcePath;
    }

    public String getStatusField() {
        return this.statusField;
    }

    public void setStatusField(String statusField) {
        this.statusField = statusField;
    }

    @Override
    protected void prepareServiceOption(ServiceOption option) {
        this.transferServiceOption(option, "updatepassedfieldonly");
    }

    public Set getEnabledOperations() {
        return this.mEnabledOperations;
    }

    public void setEnabledOperations(Set enabledOperations) {
        this.mEnabledOperations = enabledOperations;
    }
}

