/*
 * Decompiled with CFR 0.152.
 */
package aurora.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import uncertain.composite.CompositeMap;

public class FetchDescriptor {
    public static final int DEFAULT_PAGE_SIZE = 50;
    public static final String DEFAULT_PAGENUM_PARAM = "pagenum";
    public static final String DEFAULT_PAGESIZE_PARAM = "pagesize";
    public static final String DEFAULT_RECORD_PARAM = "recordnum";
    boolean fetchAll = true;
    int offSet = 0;
    int pageSize = 50;
    int pageNum = 1;
    boolean rsScrollable = false;
    static FetchDescriptor default_instance = new FetchDescriptor();

    static Number getNumber(CompositeMap param, String key) {
        Object obj = param.get((Object)key);
        if (obj instanceof Number) {
            return (Number)obj;
        }
        if (obj instanceof String) {
            try {
                return new Integer(Integer.parseInt((String)obj));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    public static FetchDescriptor createInstance(int offset, int pageSize) {
        FetchDescriptor desc = new FetchDescriptor();
        desc.offSet = offset;
        desc.pageSize = pageSize;
        desc.fetchAll = false;
        return desc;
    }

    public static FetchDescriptor createFromParameter(CompositeMap params, String page_num_param, String page_size_param, String recordnum_param) {
        Number pagenum;
        FetchDescriptor desc = new FetchDescriptor();
        Number pagesize = FetchDescriptor.getNumber(params, page_size_param);
        if (pagesize != null) {
            desc.setPageSize(pagesize.intValue());
        }
        if ((pagenum = FetchDescriptor.getNumber(params, page_num_param)) != null) {
            desc.fetchAll = false;
            desc.setPageNum(pagenum.intValue());
        } else {
            Number offset = FetchDescriptor.getNumber(params, recordnum_param);
            if (offset != null) {
                desc.fetchAll = false;
                desc.offSet = offset.intValue();
            }
        }
        if (desc.offSet < 0) {
            desc.offSet = 0;
        }
        return desc;
    }

    public static FetchDescriptor createFromParameter(CompositeMap params) {
        return FetchDescriptor.createFromParameter(params, DEFAULT_PAGENUM_PARAM, DEFAULT_PAGESIZE_PARAM, DEFAULT_RECORD_PARAM);
    }

    public static FetchDescriptor getDefaultInstance() {
        return default_instance;
    }

    public static FetchDescriptor fetchAll() {
        return default_instance;
    }

    public FetchDescriptor() {
    }

    void calOffset() {
        this.offSet = (this.pageNum - 1) * this.pageSize;
    }

    public FetchDescriptor(int offSet, int pageSize) {
        this.offSet = offSet;
        this.pageSize = pageSize;
        this.fetchAll = false;
    }

    public boolean getFetchAll() {
        return this.fetchAll;
    }

    public void setFetchAll(boolean fetchAll) {
        this.fetchAll = fetchAll;
    }

    public int getOffSet() {
        return this.offSet;
    }

    public void setOffSet(int offSet) {
        this.offSet = offSet;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (pageSize < 0) {
            pageSize = 50;
        }
        this.pageSize = pageSize;
        this.calOffset();
    }

    public boolean getResultSetScrollable() {
        return this.rsScrollable;
    }

    public void setResultSetScrollable(boolean rsScrollable) {
        this.rsScrollable = rsScrollable;
    }

    public boolean locate(ResultSet rs) throws SQLException {
        if (this.rsScrollable) {
            return rs.absolute(this.offSet);
        }
        int i = 0;
        while (i <= this.offSet) {
            if (!rs.next()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(int pageNum) {
        if (pageNum < 1) {
            pageNum = 1;
        }
        this.pageNum = pageNum;
        this.calOffset();
    }
}

