/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import java.util.HashSet;
import java.util.Set;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;

public class CascadeOperation
extends DynamicObject {
    public static final String KEY_INPUT_PATH = "inputpath";
    public static final String KEY_MODEL = "model";
    Set mEnabledOperations;

    public static CascadeOperation createCascadeOperation(CompositeMap context) {
        CascadeOperation op = new CascadeOperation();
        op.initialize(context);
        return op;
    }

    public String getModel() {
        return this.getString(KEY_MODEL);
    }

    public void setModel(String model) {
        this.putString(KEY_MODEL, model);
    }

    public String getInputPath() {
        return this.getString(KEY_INPUT_PATH);
    }

    public void setInputPath(String path) {
        this.putString(KEY_INPUT_PATH, path);
    }

    public String getOperations() {
        return this.getString("operations");
    }

    public void setOperations(String ops) {
        this.putString("operations", ops);
        this.makeReady();
    }

    public void makeReady() {
        String ops;
        if (this.mEnabledOperations != null) {
            this.mEnabledOperations.clear();
        }
        if ((ops = this.getOperations()) != null) {
            if (this.mEnabledOperations == null) {
                this.mEnabledOperations = new HashSet();
            }
            String[] op_array = ops.split(",");
            int i = 0;
            while (i < op_array.length) {
                String op = op_array[i].trim().toLowerCase();
                this.mEnabledOperations.add(op);
                ++i;
            }
        } else {
            this.mEnabledOperations = null;
        }
    }

    public DynamicObject initialize(CompositeMap context) {
        super.initialize(context);
        this.makeReady();
        return this;
    }

    public Set getEnabledOperations() {
        return this.mEnabledOperations;
    }
}

