/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import aurora.bm.BusinessModel;
import aurora.bm.DefaultAccessChecker;
import aurora.bm.IBusinessModelAccessChecker;
import aurora.bm.IBusinessModelAccessCheckerFactory;
import aurora.bm.IModelFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import uncertain.cache.CacheBuiltinExceptionFactory;
import uncertain.cache.ICache;
import uncertain.cache.INamedCacheFactory;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.IGlobalInstance;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.util.resource.ILocatable;

public class CacheBasedCheckerFactory
extends AbstractLocatableObject
implements IBusinessModelAccessCheckerFactory,
IGlobalInstance {
    INamedCacheFactory mCacheFactory;
    IModelFactory mModelFactory;
    ICache mBmDataCache;
    String mCacheName;
    String mCacheKeyPrefix;
    static final IBusinessModelAccessChecker NO_ACCESS = new IBusinessModelAccessChecker(){

        @Override
        public boolean canPerformOperation(String op) {
            return false;
        }
    };

    public static Set createOperationSet(Map map, String value_for_enable) {
        HashSet s = new HashSet();
        for (Map.Entry e : map.entrySet()) {
            if (!value_for_enable.equals(e.getValue())) continue;
            s.add(e.getKey());
        }
        return s;
    }

    public CacheBasedCheckerFactory(IModelFactory mf, INamedCacheFactory fact) {
        this.mCacheFactory = fact;
        this.mModelFactory = mf;
    }

    public void onInitialize() {
        if (this.mCacheName == null) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"cacheName");
        }
        this.mBmDataCache = this.mCacheFactory.getNamedCache(this.mCacheName);
        if (this.mBmDataCache == null) {
            throw CacheBuiltinExceptionFactory.createNamedCacheNotFound((ILocatable)this, (String)this.mCacheName);
        }
    }

    @Override
    public IBusinessModelAccessChecker getChecker(String model_name, CompositeMap session_context) throws Exception {
        Map data;
        BusinessModel bm = this.mModelFactory.getModelForRead(model_name);
        assert (bm != null);
        BusinessModel bm_for_check = bm.getModelForAccessCheck();
        if (!bm_for_check.getNeedAccessControl()) {
            return DefaultAccessChecker.ALWAYS_ALLOW;
        }
        String key_prefix = this.mCacheKeyPrefix == null ? null : TextParser.parse((String)this.mCacheKeyPrefix, (CompositeMap)session_context);
        String key = model_name;
        if (key_prefix != null) {
            key = String.valueOf(key_prefix) + model_name;
        }
        if ((data = (Map)this.mBmDataCache.getValue((Object)key)) == null) {
            return null;
        }
        return new DefaultAccessChecker(CacheBasedCheckerFactory.createOperationSet(data, "Y"));
    }

    public String getCacheName() {
        return this.mCacheName;
    }

    public void setCacheName(String cacheName) {
        this.mCacheName = cacheName;
    }

    public String getCacheKeyPrefix() {
        return this.mCacheKeyPrefix;
    }

    public void setCacheKeyPrefix(String cacheKey) {
        this.mCacheKeyPrefix = cacheKey;
    }
}

