/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import aurora.bm.BmBuiltinExceptionFactory;
import aurora.bm.CascadeOperation;
import aurora.bm.DataFilter;
import aurora.bm.Field;
import aurora.bm.ModelFactory;
import aurora.bm.Operation;
import aurora.bm.PredefinedParameterIterator;
import aurora.bm.QueryField;
import aurora.bm.QueryFieldWrapper;
import aurora.bm.Reference;
import aurora.bm.Relation;
import aurora.bm.RelationFields;
import aurora.database.profile.IDatabaseFactory;
import aurora.database.profile.IDatabaseProfile;
import aurora.service.validation.CompositeParameterIterator;
import aurora.service.validation.IParameter;
import aurora.service.validation.IParameterIterator;
import aurora.service.validation.Parameter;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.datatype.DataType;
import uncertain.datatype.DataTypeRegistry;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.GeneralException;
import uncertain.ocm.OCManager;
import uncertain.util.resource.ILocatable;

public class BusinessModel
extends DynamicObject
implements Cloneable {
    public static final String KEY_CASCADE_OPERATIONS = "cascade-operations";
    public static final String KEY_EXTEND_MODE = "extendmode";
    public static final String VALUE_OVERRIDE = "override";
    public static final String VALUE_REFERENCE = "reference";
    public static final String KEY_EXTEND = "extend";
    public static final String KEY_OPERATIONS = "operations";
    public static final String SECTION_RELATIONS = "relations";
    public static final String SECTION_FIELDS = "fields";
    public static final String SECTION_REF_FIELDS = "ref-fields";
    public static final String SECTION_QUERY_FIELDS = "query-fields";
    public static final String SECTION_PRIMARY_KEY = "primary-key";
    public static final String KEY_ALIAS = "alias";
    public static final String KEY_BASE_TABLE = "basetable";
    public static final String KEY_NAME = "name";
    public static final String KEY_MODEL_TYPE = "modeltype";
    public static final String KEY_DATABASE_TYPE = "databasetype";
    public static final String KEY_DATA_SOURCE_NAME = "datasourcename";
    public static final String KEY_ACCESS_CONTROL_MODE = "accesscontrolmode";
    public static final String KEY_DEFAULT_ORDER_BY = "defaultorderby";
    public static final String ACCESS_CONTROL_MODE_DEFAULT = "default";
    public static final String KEY_NEED_ACCESS_CONTROL = "needaccesscontrol";
    public static final String ACCESS_CONTROL_MODE_SEPARATE = "separate";
    public static final String DEFAULT_FIELD_PROMPT_FORMAT = "bm.{0}.{1}";
    public static final String KEY_ALLOW_FETCH_ALL = "allowfetchall";
    public static final String KEY_MAX_PAGE_SIZE = "maxpagesize";
    public static final String KEY_COUNT_SQL = "count-sql";
    public static final String KEY_USE_CACHE_JOIN = "usecachejoin";
    public static final String KEY_HAS_CACHE_JOIN_FIELDS = "hascachejoinfields";
    public static final String KEY_NEED_DATABASE_JOIN = "_needdatabasejoin";
    public static final String KEY_CUSTOMIZATION_ENABLED = "customizationenabled";
    public static final String KEY_CUSTOMIZATION_TAG = "tag";
    static final Field[] EMPTY_FIELDS = new Field[0];
    ModelFactory modelFactory;
    OCManager mOcManager = OCManager.getInstance();
    Map fieldMap;
    Field[] fieldsArray;
    Field[] pkFieldsArray;
    Map relationMap;
    Relation[] relationArray;
    Map operationMap;
    CascadeOperation[] mCascadeOperations;
    BusinessModel parent;
    List<RelationFields> cacheJoinList;

    public static BusinessModel getInstance(CompositeMap context) {
        BusinessModel model = new BusinessModel();
        model.initialize(context);
        return model;
    }

    public String getName() {
        return this.getString(KEY_NAME);
    }

    public void setName(String name) {
        this.putString(KEY_NAME, name);
    }

    public String getBaseTable() {
        return this.getString(KEY_BASE_TABLE);
    }

    public void setBaseTable(String table) {
        this.put(KEY_BASE_TABLE, table);
    }

    public String getAlias() {
        return this.getString(KEY_ALIAS);
    }

    public void setAlias(String alias) {
        this.putString(KEY_ALIAS, alias);
    }

    public String getDatabaseType() {
        return this.getString(KEY_DATABASE_TYPE);
    }

    public void setDatabaseType(String type) {
        this.putString(KEY_DATABASE_TYPE, type);
    }

    public String getDataSourceName() {
        return this.getString(KEY_DATA_SOURCE_NAME);
    }

    public void setDataSourceName(String dataSourceName) {
        this.putString(KEY_DATA_SOURCE_NAME, dataSourceName);
    }

    public List getQueryFieldsList() {
        return this.getChildSection(SECTION_QUERY_FIELDS);
    }

    public QueryField[] getQueryFieldsArray() {
        List flds = this.getChildSection(SECTION_QUERY_FIELDS);
        if (flds != null) {
            return (QueryField[])DynamicObject.castToArray((Collection)flds, QueryField.class);
        }
        return null;
    }

    public void addQueryField(CompositeMap queryField) {
        CompositeMap childs_map = this.object_context.getChild(SECTION_QUERY_FIELDS);
        if (childs_map == null) {
            childs_map = this.object_context.createChild("bm", "http://www.aurora-framework.org/schema/bm", SECTION_QUERY_FIELDS);
        }
        childs_map.addChild(queryField);
    }

    protected List getChildSection(String name) {
        CompositeMap childs_map = this.object_context.getChild(name);
        if (childs_map != null) {
            return childs_map.getChilds();
        }
        return null;
    }

    public Field getField(String name) {
        String key;
        Field f;
        assert (name != null);
        if (this.fieldMap == null) {
            this.makeReady();
        }
        if ((f = (Field)this.fieldMap.get(key = name.toLowerCase())) != null) {
            return f;
        }
        if (this.parent != null) {
            return this.parent.getField(name);
        }
        return null;
    }

    protected CompositeMap getChildSectionNotNull(String section_name) {
        CompositeMap fields = this.object_context.getChild(section_name);
        if (fields == null) {
            fields = this.object_context.createChild(section_name);
            fields.setNameSpaceURI("http://www.aurora-framework.org/schema/bm");
        }
        return fields;
    }

    public void addField(Field f) {
        this.getChildSectionNotNull(SECTION_FIELDS).addChild(f.getObjectContext());
    }

    public void addRefField(Field f) {
        this.getChildSectionNotNull(SECTION_REF_FIELDS).addChild(f.getObjectContext());
    }

    public DataType[] getFieldTypeArray(DataTypeRegistry registry) {
        Field[] fields = this.getFields();
        if (fields == null) {
            return null;
        }
        DataType[] fieldTypeArray = new DataType[fields.length];
        int i = 0;
        while (i < fields.length) {
            String datatype;
            Field fld = fields[i];
            if (fld.isReferenceField()) {
                fld = fld.getReferredField();
            }
            if ((datatype = fld.getDataType()) == null) {
                datatype = "java.lang.String";
            }
            fieldTypeArray[i] = registry.getDataType(datatype);
            if (fieldTypeArray[i] == null) {
                throw BuiltinExceptionFactory.createDataTypeUnknown((ILocatable)fld.getObjectContext().asLocatable(), (String)datatype);
            }
            ++i;
        }
        return fieldTypeArray;
    }

    public DataType[] getFieldTypeArray() {
        return this.getFieldTypeArray(DataTypeRegistry.getInstance());
    }

    protected void loadFields() {
        if (this.fieldMap == null) {
            this.fieldMap = new HashMap();
        } else {
            this.fieldMap.clear();
        }
        List fields = this.getChildSection(SECTION_FIELDS);
        List ref_fields = this.getChildSection(SECTION_REF_FIELDS);
        if (fields == null && ref_fields == null) {
            return;
        }
        int fieldCount = (fields == null ? 0 : fields.size()) + (ref_fields == null ? 0 : ref_fields.size());
        if (fieldCount == 0) {
            return;
        }
        Field[] array = new Field[fieldCount];
        int i = 0;
        i = this.iterateFields(array, fields, i);
        i = this.iterateFields(array, ref_fields, i);
        this.fieldsArray = array;
        CompositeMap pk_conf = this.getObjectContext().getChild(SECTION_PRIMARY_KEY);
        if (pk_conf == null) {
            this.pkFieldsArray = EMPTY_FIELDS;
        } else if (pk_conf.getChilds() == null) {
            this.pkFieldsArray = EMPTY_FIELDS;
        } else {
            this.pkFieldsArray = new Field[pk_conf.getChilds().size()];
            int n = 0;
            Iterator it = pk_conf.getChildIterator();
            if (it != null) {
                while (it.hasNext()) {
                    CompositeMap field = (CompositeMap)it.next();
                    String name = field.getString((Object)KEY_NAME);
                    if (name == null) {
                        throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)field.asLocatable(), (String)KEY_NAME);
                    }
                    Field f = this.getField(name.toLowerCase());
                    if (f == null) {
                        throw BmBuiltinExceptionFactory.createNamedFieldNotFound(name, field);
                    }
                    f.setPrimaryKey(true);
                    this.pkFieldsArray[n++] = f;
                }
            }
        }
    }

    private int iterateFields(Field[] array, List list, int i) {
        if (list == null) {
            return i;
        }
        for (CompositeMap field_map : list) {
            Field f = Field.getInstance(field_map);
            f.setOwner(this);
            String name = f.getName();
            if (name == null) {
                throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)field_map.asLocatable(), (String)KEY_NAME);
            }
            if (this.fieldMap.containsKey(name.toLowerCase())) {
                throw BuiltinExceptionFactory.createChildDuplicate((ILocatable)field_map.asLocatable(), (String)"field", (String)KEY_NAME, (String)name);
            }
            this.fieldMap.put(name.toLowerCase(), f);
            array[i++] = f;
        }
        return i;
    }

    public Field[] getFields() {
        if (this.fieldsArray == null) {
            this.loadFields();
        }
        return this.fieldsArray;
    }

    public Field[] getPrimaryKeyFields() {
        if (this.pkFieldsArray == null) {
            this.loadFields();
        }
        return this.pkFieldsArray;
    }

    protected void loadRelations() {
        List relations = this.getChildSection(SECTION_RELATIONS);
        if (relations == null) {
            return;
        }
        if (this.relationMap == null) {
            this.relationMap = new HashMap();
        } else {
            this.relationMap.clear();
        }
        if (this.cacheJoinList == null) {
            this.cacheJoinList = new LinkedList<RelationFields>();
        } else {
            this.cacheJoinList.clear();
        }
        this.relationArray = new Relation[relations.size()];
        int n = 0;
        Iterator it = relations.iterator();
        HashSet<String> extraNeedQueryRelationFields = new HashSet<String>();
        HashMap<String, RelationFields> cached_relName_map = new HashMap<String, RelationFields>();
        while (it.hasNext()) {
            CompositeMap relation_map = (CompositeMap)it.next();
            Relation relation = Relation.getInstance(relation_map);
            this.checkHashJoin(relation, extraNeedQueryRelationFields, cached_relName_map);
            String name = relation.getName().toLowerCase();
            this.relationMap.put(name, relation);
            this.relationArray[n++] = relation;
        }
        if (cached_relName_map.size() == 0) {
            return;
        }
        this.reBuildCacheJoinFields(extraNeedQueryRelationFields, cached_relName_map);
    }

    private void reBuildCacheJoinFields(HashSet<String> extraNeedQueryRelationFields, Map<String, RelationFields> cached_relName_map) {
        Field[] fieldArray = this.fieldsArray;
        int n = this.fieldsArray.length;
        int n2 = 0;
        while (n2 < n) {
            RelationFields relationFields;
            Field fld = fieldArray[n2];
            if (extraNeedQueryRelationFields.size() > 0) {
                String fldName = fld.getName().toLowerCase();
                if (fld.isForSelect()) {
                    extraNeedQueryRelationFields.remove(fldName);
                } else if (extraNeedQueryRelationFields.contains(fldName)) {
                    fld.setForSelect(true);
                    extraNeedQueryRelationFields.remove(fldName);
                }
            }
            if (fld.isReferenceField() && (relationFields = cached_relName_map.get(fld.getRelationName())) != null) {
                relationFields.addField(fld);
                this.setHasCacheJoinFields(true);
                fld.setForSelect(false);
                fld.setCacheJoinField(true);
                if (!this.cacheJoinList.contains(relationFields)) {
                    this.cacheJoinList.add(relationFields);
                }
            }
            ++n2;
        }
        boolean addField = false;
        for (String fld : extraNeedQueryRelationFields) {
            Field f = Field.createField(fld);
            f.setForInsert(false);
            f.setForUpdate(false);
            addField = true;
        }
        if (addField) {
            this.loadFields();
        }
    }

    private void checkHashJoin(Relation relation, HashSet<String> extraNeedQueryRelationFields, Map<String, RelationFields> cached_relName_map) {
        HashSet<String> relationCacheLocalFields = null;
        try {
            relationCacheLocalFields = this.getRelationCacheLocalFields(relation);
        }
        catch (Exception ex) {
            throw new GeneralException("aurora.bm.error_loading_bm", new Object[]{relation.getReferenceModel()}, relation.getObjectContext().asLocatable());
        }
        if (relationCacheLocalFields != null && relationCacheLocalFields.size() > 0) {
            relation.setNeedDatabaseJoin(false);
            extraNeedQueryRelationFields.addAll(relationCacheLocalFields);
            cached_relName_map.put(relation.getName(), new RelationFields(relation));
        }
    }

    private HashSet<String> getRelationCacheLocalFields(Relation relation) throws Exception {
        HashSet<String> localFieldList = new HashSet<String>();
        String joinType = String.valueOf(relation.getJoinType()) + " JOIN";
        if (!"INNER JOIN".equalsIgnoreCase(joinType) && !"LEFT OUTER JOIN".equalsIgnoreCase(joinType)) {
            return null;
        }
        if (!this.hasUseCacheJoin(relation.getReferenceModel())) {
            return null;
        }
        Reference[] refs = relation.getReferences();
        if (refs != null) {
            int i = 0;
            while (i < refs.length) {
                Reference ref = refs[i];
                String exp = ref.getExpression();
                if (exp != null) {
                    return null;
                }
                localFieldList.add(ref.getLocalField());
                ++i;
            }
        }
        return localFieldList;
    }

    private boolean hasUseCacheJoin(String modelName) throws Exception {
        CompositeMap model;
        CompositeLoader cl = this.modelFactory.getCompositeLoader();
        if (cl == null) {
            cl = CompositeLoader.createInstanceForOCM();
            cl.setDefaultExt("bm");
        }
        if ((model = cl.loadFromClassPath(modelName, cl.getDefaultExt())) != null) {
            return model.getBoolean((Object)KEY_USE_CACHE_JOIN, false);
        }
        return false;
    }

    public Relation getRelation(String name) {
        return (Relation)((Object)this.relationMap.get(name.toLowerCase()));
    }

    public Relation[] getRelations() {
        return this.relationArray;
    }

    public void addRelation(Relation relation) {
        CompositeMap relations = this.getChildSectionNotNull(SECTION_RELATIONS);
        relations.addChild(relation.getObjectContext());
    }

    public DataFilter[] getDataFilters() {
        List lst = this.getChildSection("data-filters");
        if (lst == null) {
            return null;
        }
        return (DataFilter[])DynamicObject.castToArray((Collection)lst, DataFilter.class);
    }

    public void setDataFilters(CompositeMap dataFilters) {
        this.object_context.replaceChild("data-filters", dataFilters);
    }

    public IParameterIterator getParameterForQuery() {
        if (this.getQueryFieldsList() != null) {
            return new QueryFieldIterator();
        }
        return new BaseQueryFieldIterator();
    }

    public IParameterIterator getParameterForOperation(String operation) {
        if ("query".equalsIgnoreCase(operation)) {
            return this.getParameterForQuery();
        }
        List params = null;
        Operation op = this.getOperation(operation);
        if (op != null) {
            params = op.getParameters();
            if (params != null) {
                return new PredefinedParameterIterator(params);
            }
            return null;
        }
        if ("delete".equalsIgnoreCase(operation)) {
            return new PrimaryKeyParameterIterator();
        }
        boolean default_value = false;
        if ("update".equalsIgnoreCase(operation) || "insert".equalsIgnoreCase(operation)) {
            default_value = true;
        }
        GeneralParameterIterator general_it = new GeneralParameterIterator(operation, default_value);
        if ("update".equalsIgnoreCase(operation)) {
            LinkedList<IParameterIterator> lst = new LinkedList<IParameterIterator>();
            lst.add(new PrimaryKeyParameterIterator());
            lst.add(general_it);
            return new CompositeParameterIterator(lst);
        }
        return general_it;
    }

    public List getParameterForOperationInList(String operation) {
        LinkedList<Parameter> result = new LinkedList<Parameter>();
        IParameterIterator it = this.getParameterForOperation(operation);
        if (it != null) {
            while (it.hasNext()) {
                IParameter obj = it.next();
                Parameter param = null;
                if (obj instanceof DynamicObject) {
                    param = new Parameter();
                    CompositeMap m = ((DynamicObject)obj).getObjectContext();
                    this.mOcManager.populateObject(m, (Object)param);
                    result.add(param);
                    continue;
                }
                param = new Parameter(obj);
                result.add(param);
            }
        }
        return result;
    }

    public void makeReady() {
        this.loadFields();
        this.loadRelations();
        this.prepareOperationMap();
        this.prepareCascadeOperations();
    }

    public ModelFactory getModelFactory() {
        return this.modelFactory;
    }

    public void setModelFactory(ModelFactory modelFactory) {
        this.modelFactory = modelFactory;
    }

    public IDatabaseProfile getDatabaseProfile(IDatabaseFactory fact) {
        String db_type = this.getDatabaseType();
        if (db_type == null) {
            return fact.getDefaultDatabaseProfile();
        }
        IDatabaseProfile profile = fact.getDatabaseProfile(db_type);
        if (profile == null) {
            throw BmBuiltinExceptionFactory.createUnknownDatabaseType(db_type, this.object_context);
        }
        return profile;
    }

    public Operation getOperation(String name) {
        if (this.operationMap == null) {
            return null;
        }
        return (Operation)((Object)this.operationMap.get(name.toLowerCase()));
    }

    protected void prepareOperationMap() {
        CompositeMap ops = this.object_context.getChild(KEY_OPERATIONS);
        if (ops == null) {
            return;
        }
        Iterator it = ops.getChildIterator();
        if (it == null) {
            return;
        }
        if (this.operationMap == null) {
            this.operationMap = new HashMap();
        } else {
            this.operationMap.clear();
        }
        while (it.hasNext()) {
            CompositeMap item = (CompositeMap)it.next();
            Operation op = Operation.createOperation(item);
            String name = op.getName();
            if (name == null) {
                throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)item.asLocatable(), (String)KEY_NAME);
            }
            if (this.operationMap.containsKey(name = name.toLowerCase())) {
                throw BuiltinExceptionFactory.createChildDuplicate((ILocatable)item.asLocatable(), (String)"operation", (String)KEY_NAME, (String)name);
            }
            this.operationMap.put(name, op);
        }
    }

    protected void prepareCascadeOperations() {
        CompositeMap child = this.getObjectContext().getChild(KEY_CASCADE_OPERATIONS);
        if (child == null) {
            this.mCascadeOperations = null;
        } else {
            int total_count = child.getChilds().size();
            if (total_count == 0) {
                this.mCascadeOperations = null;
                return;
            }
            this.mCascadeOperations = new CascadeOperation[total_count];
            Iterator it = child.getChildIterator();
            int i = 0;
            while (it.hasNext()) {
                CompositeMap item = (CompositeMap)it.next();
                CascadeOperation op = CascadeOperation.createCascadeOperation(item);
                this.mCascadeOperations[i++] = op;
            }
        }
    }

    protected void setOcManager(OCManager ocManager) {
        this.mOcManager = ocManager;
    }

    public CascadeOperation[] getCascadeOperations() {
        return this.mCascadeOperations;
    }

    public String getModelType() {
        return this.getString(KEY_MODEL_TYPE);
    }

    public void setModelType(String type) {
        this.putString(KEY_MODEL_TYPE, type);
    }

    public String getDefaultOrderby() {
        return this.getString(KEY_DEFAULT_ORDER_BY);
    }

    public void setDefaultOrderby(String defaultorderby) {
        this.putString(KEY_DEFAULT_ORDER_BY, defaultorderby);
    }

    public String getFieldPrompt(Field field, String default_prompt_pattern) {
        String prompt = field.getPrompt();
        if (prompt != null) {
            return prompt;
        }
        String name = this.getBaseTable();
        if (name == null) {
            name = this.getName();
        }
        String field_name = field.getName();
        String result = MessageFormat.format(default_prompt_pattern, name, field_name);
        return result.toUpperCase();
    }

    public String getFieldPrompt(Field field) {
        return this.getFieldPrompt(field, DEFAULT_FIELD_PROMPT_FORMAT);
    }

    public String getExtend() {
        return this.getString(KEY_EXTEND);
    }

    public void setExtend(String base) {
        this.putString(KEY_EXTEND, base);
    }

    public String getExtendMode() {
        return this.getString(KEY_EXTEND_MODE);
    }

    public void setExtendMode(String mode) {
        this.putString(KEY_EXTEND_MODE, mode);
    }

    public BusinessModel getParent() {
        return this.parent;
    }

    protected void setParent(BusinessModel parent) {
        this.parent = parent;
    }

    public static String getDefaultAlias(int index) {
        return "t" + index;
    }

    public static String getDefaultAlias() {
        return "t1";
    }

    public String getAccessControlMode() {
        String mode = this.getString(KEY_ACCESS_CONTROL_MODE);
        if (mode == null) {
            return ACCESS_CONTROL_MODE_DEFAULT;
        }
        return mode;
    }

    public void setAccessControlMode(String mode) {
        this.putString(KEY_ACCESS_CONTROL_MODE, mode);
    }

    public CompositeMap getExceptionDescriptorConfig() {
        return this.getObjectContext().getChild("exception-descriptor-config");
    }

    public boolean getNeedAccessControl() {
        return this.getBoolean(KEY_NEED_ACCESS_CONTROL, true);
    }

    public void setNeedAccessControl(boolean b) {
        this.putBoolean(KEY_NEED_ACCESS_CONTROL, b);
    }

    public void setAllowFetchAll(boolean b) {
        this.putBoolean(KEY_ALLOW_FETCH_ALL, b);
    }

    public Boolean getAllowFetchAll() {
        return this.getBoolean(KEY_ALLOW_FETCH_ALL);
    }

    public void setMaxPageSize(int num) {
        this.putInt(KEY_MAX_PAGE_SIZE, num);
    }

    public Integer getMaxPageSize() {
        return this.getInteger(KEY_MAX_PAGE_SIZE);
    }

    public BusinessModel getModelForAccessCheck() {
        BusinessModel parent = this.getParent();
        if (parent == null) {
            return this;
        }
        String mode = this.getAccessControlMode();
        if (ACCESS_CONTROL_MODE_SEPARATE.equals(mode)) {
            return this;
        }
        return parent.getModelForAccessCheck();
    }

    public CompositeMap getCountSql() {
        return this.getObjectContext().getChild(KEY_COUNT_SQL);
    }

    public boolean getUseCacheJoin() {
        return this.getBoolean(KEY_USE_CACHE_JOIN, false);
    }

    public void setUseCacheJoin(boolean b) {
        this.putBoolean(KEY_USE_CACHE_JOIN, b);
    }

    public boolean hasCacheJoinFields() {
        return this.getBoolean(KEY_HAS_CACHE_JOIN_FIELDS, false);
    }

    public void setHasCacheJoinFields(boolean b) {
        this.putBoolean(KEY_HAS_CACHE_JOIN_FIELDS, b);
    }

    public List<RelationFields> getCacheJoinList() {
        return this.cacheJoinList;
    }

    public void setCacheJoinList(List<RelationFields> cacheJoinList) {
        this.cacheJoinList = cacheJoinList;
    }

    public boolean getCustomizationenabled() {
        return this.getBoolean(KEY_CUSTOMIZATION_ENABLED, false);
    }

    public void setCustomizationenabled(boolean b) {
        this.putBoolean(KEY_CUSTOMIZATION_ENABLED, b);
    }

    public String getTag() {
        return this.getString(KEY_CUSTOMIZATION_TAG);
    }

    public void setTag(String b) {
        this.putString(KEY_CUSTOMIZATION_TAG, b);
    }

    public class BaseQueryFieldIterator
    implements IParameterIterator {
        int id = 0;

        public BaseQueryFieldIterator() {
            this.movePointer();
        }

        /*
         * Unable to fully structure code
         */
        void movePointer() {
            if (BusinessModel.this.fieldsArray == null) {
                this.id = -1;
            }
            if (this.id >= 0) ** GOTO lbl6
            return;
lbl-1000:
            // 1 sources

            {
                ++this.id;
lbl6:
                // 2 sources

                ** while (this.id < BusinessModel.this.fieldsArray.length && !BusinessModel.this.fieldsArray[this.id].isForQuery())
            }
lbl7:
            // 1 sources

            if (this.id >= BusinessModel.this.fieldsArray.length) {
                this.id = -1;
            }
        }

        @Override
        public boolean hasNext() {
            return this.id >= 0;
        }

        @Override
        public IParameter next() {
            if (!this.hasNext()) {
                return null;
            }
            Field f = BusinessModel.this.fieldsArray[this.id++];
            this.movePointer();
            if (f.isReferenceField()) {
                f = f.getReferredField();
            }
            return new QueryFieldWrapper(f);
        }
    }

    public class GeneralParameterIterator
    implements IParameterIterator {
        int id = 0;
        String operation;
        boolean default_value;

        /*
         * Unable to fully structure code
         */
        void movePointer() {
            if (BusinessModel.this.fieldsArray != null) ** GOTO lbl5
            this.id = -1;
            return;
lbl-1000:
            // 1 sources

            {
                ++this.id;
lbl5:
                // 2 sources

                ** while (this.id < BusinessModel.this.fieldsArray.length && (!BusinessModel.this.fieldsArray[this.id].isForOperation((String)this.operation, (boolean)this.default_value) || BusinessModel.this.fieldsArray[this.id].isReferenceField()))
            }
lbl6:
            // 1 sources

            if (this.id >= BusinessModel.this.fieldsArray.length) {
                this.id = -1;
            }
        }

        public GeneralParameterIterator(String operation, boolean default_value) {
            this.operation = operation;
            this.default_value = default_value;
            this.movePointer();
        }

        @Override
        public boolean hasNext() {
            return this.id >= 0;
        }

        @Override
        public IParameter next() {
            Field f;
            if (this.id < 0) {
                return null;
            }
            if ((f = BusinessModel.this.fieldsArray[this.id++]).isReferenceField()) {
                f = f.getReferredField();
            }
            this.movePointer();
            return f;
        }
    }

    public class PrimaryKeyParameterIterator
    implements IParameterIterator {
        int id = 0;

        @Override
        public boolean hasNext() {
            if (BusinessModel.this.pkFieldsArray == null) {
                return false;
            }
            return this.id >= 0 & this.id < BusinessModel.this.pkFieldsArray.length;
        }

        @Override
        public IParameter next() {
            if (!this.hasNext()) {
                return null;
            }
            Field f = BusinessModel.this.pkFieldsArray[this.id++].createCopy();
            f.setRequired(true);
            return f;
        }
    }

    public class QueryFieldIterator
    implements IParameterIterator {
        Iterator mFieldsIt;

        public QueryFieldIterator() {
            List items = BusinessModel.this.getQueryFieldsList();
            if (items != null) {
                this.mFieldsIt = items.iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.mFieldsIt == null ? false : this.mFieldsIt.hasNext();
        }

        @Override
        public IParameter next() {
            if (!this.hasNext()) {
                return null;
            }
            CompositeMap map = (CompositeMap)this.mFieldsIt.next();
            QueryField qf = (QueryField)((Object)DynamicObject.cast((CompositeMap)map, QueryField.class));
            String name = qf.getField();
            Field f = null;
            if (name != null) {
                f = BusinessModel.this.getField(name);
                if (f == null) {
                    throw BmBuiltinExceptionFactory.createNamedFieldNotFound(name, map);
                }
                if (f.isReferenceField()) {
                    f = f.getReferredField();
                }
                return new QueryFieldWrapper(f);
            }
            f = (Field)qf.castTo(Field.class);
            return f;
        }
    }
}

