/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.bm.ICachedDataProvider;
import java.util.LinkedList;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class BmCachedDataProvider
implements ICachedDataProvider {
    String cacheKey;
    String cacheName;

    @Override
    public String getCacheName(BusinessModel model) {
        if (this.cacheName != null) {
            return this.cacheName;
        }
        return model.getName();
    }

    @Override
    public String getCacheKey(BusinessModel model) {
        if (this.cacheKey != null) {
            return this.cacheKey;
        }
        Field[] flds = model.getPrimaryKeyFields();
        if (flds == null || flds.length == 0) {
            throw new IllegalArgumentException("Business model " + model.getName() + " must has primary key");
        }
        LinkedList<String> fields = new LinkedList<String>();
        int i = 0;
        while (i < flds.length) {
            fields.add(flds[i].getName());
            ++i;
        }
        return String.valueOf(model.getName()) + "." + this.generateKey(fields);
    }

    @Override
    public String getParsedCacheKey(BusinessModel model, CompositeMap record) {
        if (record == null) {
            return null;
        }
        String cacheKey = this.getCacheKey(model);
        return TextParser.parse((String)cacheKey, (CompositeMap)record);
    }

    @Override
    public String generateKey(List<String> fieldNames) {
        if (fieldNames == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (String fieldName : fieldNames) {
            sb.append("${@" + fieldName.toLowerCase() + "}.");
        }
        String cacheKey = sb.substring(0, sb.length() - 1);
        return cacheKey;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }
}

