/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.msg;

import aurora.application.features.msg.IMessageDispatcher;
import aurora.application.features.msg.IMessageStub;
import aurora.application.features.msg.Message;
import aurora.application.features.msg.Property;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.event.RuntimeContext;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;
import uncertain.util.resource.ILocatable;

public class MessageCreator
extends AbstractEntry {
    public static final String MESSAGE_ATTR = "message";
    public static final String TOPIC_ATTR = "topic";
    private String message;
    private String topic;
    private boolean trxType = false;
    private Property[] properties;
    private IObjectRegistry mRegistry;

    public MessageCreator(IObjectRegistry registry) {
        this.mRegistry = registry;
    }

    public void run(ProcedureRunner runner) throws Exception {
        IMessageStub messageStub;
        if (this.message == null) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)MESSAGE_ATTR);
        }
        if (this.topic == null) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)TOPIC_ATTR);
        }
        CompositeMap context = runner.getContext();
        CompositeMap pps = new CompositeMap("property");
        String parsedTopic = TextParser.parse((String)this.topic, (CompositeMap)context);
        String parsedMessage = TextParser.parse((String)this.message, (CompositeMap)context);
        if (this.properties != null) {
            Property[] propertyArray = this.properties;
            int n = this.properties.length;
            int n2 = 0;
            while (n2 < n) {
                Property p = propertyArray[n2];
                p.putToMap(context, (Map)pps, true);
                ++n2;
            }
        }
        if ((messageStub = (IMessageStub)this.mRegistry.getInstanceOfType(IMessageStub.class)) == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, IMessageStub.class, (String)((Object)((Object)this)).getClass().getCanonicalName());
        }
        Message msg = new Message(parsedMessage, pps);
        if (this.trxType) {
            IMessageDispatcher messageDispatcher = (IMessageDispatcher)RuntimeContext.getInstance((CompositeMap)context).getInstanceOfType(IMessageDispatcher.class);
            if (messageDispatcher == null) {
                throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, IMessageDispatcher.class, (String)((Object)((Object)this)).getClass().getCanonicalName());
            }
            messageDispatcher.send(parsedTopic, msg, context);
        } else {
            messageStub.getDispatcher().send(parsedTopic, msg, context);
        }
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public void setProperties(Property[] properties) {
        this.properties = properties;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public boolean getTrxType() {
        return this.trxType;
    }

    public void setTrxType(boolean trxType) {
        this.trxType = trxType;
    }
}

