/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.cache;

import aurora.application.features.cache.ICacheProvider;
import aurora.application.features.cache.PeriodModeCacheProvider;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import uncertain.composite.CompositeMap;

public class CacheProviderRegistry {
    public static final String KEY_CACHE_NAME = "cacheName";
    public static final String KEY_CACHE_DESC = "cacheDesc";
    public static final String KEY_RELOAD_TYPE = "reloadType";
    public static final String KEY_RELOAD_INTERVAL = "reloadInterval";
    public static final String KEY_RELOAD_TOPIC = "reloadTopic";
    public static final String KEY_RELOAD_MSG = "reloadMessage";
    public static final String KEY_LAST_RELOAD_DATE = "lastReloadDate";
    public static final String KEY_PAST_TIME = "pastTime";
    public static Map<String, ICacheProvider> providerMap = new HashMap<String, ICacheProvider>();

    public static CompositeMap getAllProvider() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CompositeMap result = new CompositeMap("result");
        Set<Map.Entry<String, ICacheProvider>> entrySet = providerMap.entrySet();
        for (Map.Entry<String, ICacheProvider> entry : entrySet) {
            ICacheProvider provider = entry.getValue();
            boolean periodMode = false;
            if (provider == null) continue;
            CompositeMap record = new CompositeMap("record");
            record.put((Object)KEY_CACHE_NAME, (Object)entry.getKey());
            record.put((Object)KEY_CACHE_DESC, (Object)provider.getCacheDesc());
            record.put((Object)KEY_RELOAD_TOPIC, (Object)provider.getReloadTopic());
            record.put((Object)KEY_RELOAD_MSG, (Object)provider.getReloadMessage());
            Date date = provider.getLastReloadDate();
            if (date != null) {
                String dateStr = dateFormat.format(date);
                record.put((Object)KEY_LAST_RELOAD_DATE, (Object)dateStr);
                long pastTime = (new Date().getTime() - date.getTime()) / 1000L;
                record.put((Object)KEY_PAST_TIME, (Object)pastTime);
            } else {
                record.put((Object)KEY_LAST_RELOAD_DATE, (Object)"");
                record.put((Object)KEY_PAST_TIME, (Object)"");
            }
            if (provider instanceof PeriodModeCacheProvider) {
                periodMode = true;
                record.put((Object)KEY_RELOAD_TYPE, (Object)"periodMode");
                record.put((Object)KEY_RELOAD_INTERVAL, (Object)((PeriodModeCacheProvider)provider).getRefreshInterval());
            } else {
                record.put((Object)KEY_RELOAD_TYPE, (Object)"");
                record.put((Object)KEY_RELOAD_INTERVAL, (Object)"");
            }
            if (!periodMode) {
                result.addChild(0, record);
                continue;
            }
            result.addChild(record);
        }
        return result;
    }

    public static CompositeMap getProviderFromName(String cacheName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CompositeMap result = new CompositeMap("result");
        ICacheProvider provider = providerMap.get(cacheName);
        if (provider != null) {
            CompositeMap record = new CompositeMap("record");
            record.put((Object)KEY_CACHE_NAME, (Object)provider.getKey());
            record.put((Object)KEY_CACHE_DESC, (Object)provider.getCacheDesc());
            record.put((Object)KEY_RELOAD_TOPIC, (Object)provider.getReloadTopic());
            record.put((Object)KEY_RELOAD_MSG, (Object)provider.getReloadMessage());
            Date date = provider.getLastReloadDate();
            if (date != null) {
                String dateStr = dateFormat.format(date);
                record.put((Object)KEY_LAST_RELOAD_DATE, (Object)dateStr);
                long pastTime = (new Date().getTime() - date.getTime()) / 1000L;
                record.put((Object)KEY_PAST_TIME, (Object)pastTime);
            } else {
                record.put((Object)KEY_LAST_RELOAD_DATE, (Object)"");
                record.put((Object)KEY_PAST_TIME, (Object)"");
            }
            if (provider instanceof PeriodModeCacheProvider) {
                record.put((Object)KEY_RELOAD_TYPE, (Object)"periodMode");
                record.put((Object)KEY_RELOAD_INTERVAL, (Object)((PeriodModeCacheProvider)provider).getRefreshInterval());
            } else {
                record.put((Object)KEY_RELOAD_TYPE, (Object)"");
                record.put((Object)KEY_RELOAD_INTERVAL, (Object)"");
            }
            result.addChild(record);
        }
        return result;
    }

    public static void put(String cacheName, ICacheProvider provider) {
        providerMap.put(cacheName, provider);
    }

    public static ICacheProvider getProvider(String cacheName) {
        return providerMap.get(cacheName);
    }

    public static boolean reloadCache(String cacheName) throws Exception {
        ICacheProvider provider = CacheProviderRegistry.getProvider(cacheName);
        if (provider == null) {
            throw new IllegalArgumentException("cache:" + cacheName + " may not registry its CacheProvider!");
        }
        provider.reload();
        return true;
    }

    public static void remove(String cacheName) {
        providerMap.remove(cacheName);
    }
}

