/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features;

import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.util.Enumeration;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import uncertain.composite.CompositeMap;
import uncertain.ocm.ISingleton;

public class HttpRequestTransfer
implements ISingleton {
    private static final String KEY_REQUEST = "request";
    private static final String KEY_ADDRESS = "address";

    public static void copyParameter(HttpServletRequest request, ServiceInstance svc) {
        Enumeration ep = request.getParameterNames();
        CompositeMap params = svc.getServiceContext().getParameter();
        while (ep.hasMoreElements()) {
            String name = (String)ep.nextElement();
            String[] values = request.getParameterValues(name);
            if (values == null) {
                params.put((Object)name, null);
                continue;
            }
            if (values.length == 1) {
                params.put((Object)name, (Object)values[0]);
                continue;
            }
            if (values.length <= 1) continue;
            params.put((Object)name, (Object)values);
        }
    }

    public static void copyHeader(HttpServletRequest request, ServiceInstance svc) {
        CompositeMap req_map = svc.getContextMap().getChild(KEY_REQUEST);
        if (req_map == null) {
            req_map = svc.getContextMap().createChild(KEY_REQUEST);
        }
        Enumeration head_enum = request.getHeaderNames();
        while (head_enum.hasMoreElements()) {
            String head = (String)head_enum.nextElement();
            String head_value = request.getHeader(head);
            req_map.put((Object)head, (Object)head_value);
        }
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        req_map.put((Object)KEY_ADDRESS, (Object)ip);
    }

    public static void copyRequest(HttpServiceInstance svc) {
        HttpServletRequest request = svc.getRequest();
        CompositeMap r = svc.getContextMap().createChild(KEY_REQUEST);
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        r.put((Object)KEY_ADDRESS, (Object)ip);
        r.put((Object)"url", (Object)request.getRequestURI());
        r.put((Object)"server_name", (Object)request.getServerName());
        r.put((Object)"context_path", (Object)request.getContextPath());
        r.put((Object)"server_port", (Object)new Integer(request.getServerPort()));
        r.put((Object)"request_id", (Object)UUID.randomUUID());
        CompositeMap cookie = svc.getContextMap().createChild("cookie");
        HttpRequestTransfer.populateCookieMap(request, cookie);
        HttpRequestTransfer.copyParameter(svc.getRequest(), svc);
        HttpRequestTransfer.copyHeader(svc.getRequest(), svc);
    }

    public static void populateCookieMap(HttpServletRequest request, CompositeMap target) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                CompositeMap m = HttpRequestTransfer.createCookieMap(cookies[i]);
                target.put((Object)cookies[i].getName(), (Object)m);
                ++i;
            }
        }
    }

    public static CompositeMap createCookieMap(Cookie cookie) {
        CompositeMap m = new CompositeMap("cookie");
        m.put((Object)"name", (Object)cookie.getName());
        m.put((Object)"value", (Object)cookie.getValue());
        m.put((Object)"domain", (Object)cookie.getDomain());
        m.put((Object)"path", (Object)cookie.getPath());
        m.putInt((Object)"maxage", cookie.getMaxAge());
        m.putBoolean((Object)"secure", cookie.getSecure());
        return m;
    }
}

