/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.action;

import aurora.application.ISessionInfoProvider;
import aurora.application.util.LanguageUtil;
import aurora.bm.IBusinessModelAccessChecker;
import aurora.bm.IBusinessModelAccessCheckerFactory;
import aurora.service.ServiceContext;
import aurora.service.http.AutoCrudServiceContext;
import aurora.service.validation.ErrorMessage;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class BmAccessCheck
extends AbstractEntry {
    public static final String DEFAULT_ACCESS_CHECK_ERROR_MESSAGE = "aurora.bm.access_check_fail";
    IObjectRegistry mRegistry;
    IBusinessModelAccessCheckerFactory mBmAccessChecker;
    ISessionInfoProvider mSessionProvider;
    String mResultPath = "@success";
    String mErrorMessage = "aurora.bm.access_check_fail";

    public BmAccessCheck(IObjectRegistry reg, IBusinessModelAccessCheckerFactory accessChecker, ISessionInfoProvider provider) {
        this.mBmAccessChecker = accessChecker;
        this.mSessionProvider = provider;
        this.mRegistry = reg;
    }

    public void run(ProcedureRunner runner) throws Exception {
        boolean result = true;
        CompositeMap context_map = runner.getContext();
        ILogger logger = LoggingContext.getLogger((CompositeMap)context_map, (String)"aurora.application.session_check");
        ServiceContext sc = ServiceContext.createServiceContext(context_map);
        AutoCrudServiceContext acsc = AutoCrudServiceContext.createAutoCrudServiceContext(context_map);
        String operation = acsc.getRequestedOperation();
        String bm = acsc.getRequestedBM();
        logger.log(Level.CONFIG, "Checking BM access {0} for operation {1}", new Object[]{bm, operation});
        if (!"batch_update".equals(operation)) {
            IBusinessModelAccessChecker checker = this.mBmAccessChecker.getChecker(bm, context_map);
            if (checker == null) {
                logger.config("No access checker found. Maybe there is no such combination defined in system. Access check failed");
                result = false;
            } else {
                result = checker.canPerformOperation(operation);
                logger.log(Level.CONFIG, "Result from {0} is {1}", new Object[]{checker, new Boolean(result)});
            }
        } else {
            logger.config("for batch_update, access check will be performed on each record from parameter");
        }
        if (this.mResultPath != null) {
            context_map.putObject(this.mResultPath, (Object)new Boolean(result), true);
        } else {
            sc.setSuccess(result);
        }
        if (!result) {
            String code = "unauthorized";
            if (!this.mSessionProvider.isLoggedin(context_map)) {
                code = "login_required";
            }
            String msg = this.mErrorMessage == null ? code : this.mErrorMessage;
            msg = LanguageUtil.getTranslatedMessage(this.mRegistry, msg, context_map);
            ErrorMessage m = new ErrorMessage(code, msg, null);
            sc.setError(m.getObjectContext());
            return;
        }
    }

    public String getResultPath() {
        return this.mResultPath;
    }

    public void setResultPath(String resultPath) {
        this.mResultPath = resultPath;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.mErrorMessage = errorMessage;
    }
}

