/*
 * Decompiled with CFR 0.152.
 */
package org.pptx4j.samples;

import java.io.File;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.dml.STShapeType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.MainPresentationPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideLayoutPart;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.pptx4j.jaxb.Context;
import org.pptx4j.pml.Shape;
import org.pptx4j.pml.Sld;

public class AutoShapes {
    protected static Logger log = Logger.getLogger(AutoShapes.class);

    public static void main(String[] args) throws Exception {
        String outputfilepath = System.getProperty("user.dir") + "/sample-docs/pptx/AutoShapes.pptx";
        PresentationMLPackage presentationMLPackage = PresentationMLPackage.createPackage();
        MainPresentationPart pp = (MainPresentationPart)presentationMLPackage.getParts().getParts().get(new PartName("/ppt/presentation.xml"));
        SlideLayoutPart layoutPart = (SlideLayoutPart)presentationMLPackage.getParts().getParts().get(new PartName("/ppt/slideLayouts/slideLayout1.xml"));
        boolean noLine = false;
        int i = 1;
        for (STShapeType st : STShapeType.values()) {
            System.out.println("Adding slide for shape: " + st.value());
            SlidePart slidePart = AutoShapes.createSlidePart(pp, layoutPart, i);
            Shape title = (Shape)XmlUtils.unmarshalString(AutoShapes.getSlideTitle(st.value()), Context.jcPML);
            ((Sld)slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(title);
            Shape sample = (Shape)XmlUtils.unmarshalString(AutoShapes.getPresetShape(st.value(), noLine), Context.jcPML);
            ((Sld)slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sample);
            ++i;
        }
        presentationMLPackage.save(new File(outputfilepath));
        System.out.println("\n\n done .. saved " + outputfilepath);
    }

    private static SlidePart createSlidePart(MainPresentationPart pp, SlideLayoutPart layoutPart, int i) throws InvalidFormatException, JAXBException {
        SlidePart slidePart = new SlidePart(new PartName("/ppt/slides/slide" + i + ".xml"));
        pp.addSlideIdListEntry(slidePart);
        slidePart.setJaxbElement(SlidePart.createSld());
        slidePart.addTargetPart(layoutPart);
        return slidePart;
    }

    private static String getPresetShape(String preset, boolean noLine) {
        String txBody = "";
        String ln = "";
        if (!noLine) {
            ln = "<a:ln><a:solidFill><a:srgbClr val=\"FF0000\"/></a:solidFill></a:ln>";
        }
        return "<p:sp   xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\"><p:nvSpPr><p:cNvPr id=\"4\" name=\"My Preset Shape\" /><p:cNvSpPr/><p:nvPr/></p:nvSpPr><p:spPr><a:xfrm><a:off x=\"1981200\" y=\"533400\"/><a:ext cx=\"1143000\" cy=\"1066800\"/></a:xfrm><a:prstGeom prst=\"" + preset + "\">" + "<a:avLst/>" + "</a:prstGeom>" + ln + "</p:spPr>" + txBody + "</p:sp>";
    }

    private static String getSlideTitle(String preset) {
        return "<p:sp   xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\"><p:nvSpPr><p:cNvPr id=\"4\" name=\"Title 3\" /><p:cNvSpPr><a:spLocks noGrp=\"1\" /></p:cNvSpPr><p:nvPr><p:ph type=\"title\" /></p:nvPr></p:nvSpPr><p:spPr /><p:txBody><a:bodyPr /><a:lstStyle /><a:p><a:r><a:rPr lang=\"en-US\" smtClean=\"0\" /><a:t>" + preset + "</a:t>" + "</a:r>" + "<a:endParaRPr lang=\"en-US\" />" + "</a:p>" + "</p:txBody>" + "</p:sp>";
    }
}

