/*
 * Decompiled with CFR 0.152.
 */
package org.pptx4j.convert.out.svginhtml;

import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTBlip;
import org.docx4j.dml.CTPoint2D;
import org.docx4j.dml.CTPositiveSize2D;
import org.docx4j.model.images.AbstractWordXmlPicture;
import org.docx4j.model.images.ConversionImageHandler;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.pptx4j.jaxb.Context;
import org.pptx4j.model.ResolvedLayout;
import org.pptx4j.pml.Pic;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class PictureExporter
extends AbstractWordXmlPicture {
    protected static Logger log = Logger.getLogger(PictureExporter.class);
    Pic pic = null;
    private final int extentToPixelConversionFactor = 9525;

    public static DocumentFragment createHtmlImg(PresentationMLPackage pmlPackage, ResolvedLayout rl, ConversionImageHandler imageHandler, NodeIterator wpInline) {
        PictureExporter converter = PictureExporter.createPicture(pmlPackage, imageHandler, wpInline, rl);
        DocumentFragment df = PictureExporter.getHtmlDocumentFragment(converter);
        CTPoint2D offset = converter.pic.getSpPr().getXfrm().getOff();
        AbstractWordXmlPicture.Dimensions xy = converter.readDimensions(offset.getX(), offset.getY());
        Element div = df.getOwnerDocument().createElement("div");
        div.setAttribute("style", "position:absolute; left:" + xy.width + "px; top:" + xy.height + "px;");
        Node img = df.getFirstChild();
        df.removeChild(img);
        df.appendChild(div);
        div.appendChild(img);
        return df;
    }

    public static PictureExporter createPicture(PresentationMLPackage pmlPackage, ConversionImageHandler imageHandler, NodeIterator anchorOrInline, ResolvedLayout rl) {
        PictureExporter converter = new PictureExporter();
        try {
            Node n = anchorOrInline.nextNode();
            converter.pic = (Pic)XmlUtils.unmarshal(n, Context.jcPML, Pic.class);
        }
        catch (JAXBException e1) {
            e1.printStackTrace();
        }
        log.info((Object)("** image: " + converter.pic.getClass().getName()));
        if (converter.pic.getBlipFill() == null || converter.pic.getBlipFill().getBlip() == null) {
            log.error((Object)"blip missing!!");
            return null;
        }
        CTBlip blip = converter.pic.getBlipFill().getBlip();
        String imgRelId = blip.getEmbed();
        if (imgRelId != null) {
            converter.handleImageRel(imageHandler, imgRelId, (Part)rl.relationships.getSourceP());
        } else if (blip.getLink() != null) {
            converter.handleImageRel(imageHandler, blip.getLink(), (Part)rl.relationships.getSourceP());
        } else {
            log.error((Object)"not linked or embedded?!");
        }
        converter.dimensions = converter.readDimensions(converter.pic.getSpPr().getXfrm().getExt());
        return converter;
    }

    private AbstractWordXmlPicture.Dimensions readDimensions(long x, long y) {
        AbstractWordXmlPicture.Dimensions dimensions = new AbstractWordXmlPicture.Dimensions();
        dimensions.width = (int)x / 9525;
        dimensions.widthUnit = "px";
        dimensions.height = (int)y / 9525;
        dimensions.heightUnit = "px";
        return dimensions;
    }

    private AbstractWordXmlPicture.Dimensions readDimensions(CTPositiveSize2D size2d) {
        if (size2d == null) {
            log.warn((Object)"wp:inline/wp:extent missing!");
            return null;
        }
        return this.readDimensions(size2d.getCx(), size2d.getCy());
    }
}

