/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.utils;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class JarCheck {
    private static final int chunkLength = 8;
    public static final String EMBEDDED_COPYRIGHT = "Copyright: (c) 2006-2011 Roedy Green, Canadian Mind Products, http://mindprod.com";
    private static final String RELEASE_DATE = "2008-04-21";
    public static final String VERSION_STRING = "1.3";
    private static final HashMap<Integer, String> convertMachineToHuman = new HashMap(23);
    private static final HashMap<String, Integer> convertHumanToMachine = new HashMap(23);
    private static final byte[] expectedMagicNumber = new byte[]{-54, -2, -70, -66};

    private static boolean checkJar(String jarFilename, int low, int high) {
        System.out.println("Checking jar " + jarFilename);
        boolean success = true;
        ZipInputStream zip = null;
        int lowest = 1000;
        int highest = 0;
        try {
            try {
                ZipEntry entry;
                FileInputStream fis = new FileInputStream(jarFilename);
                zip = new ZipInputStream(fis);
                block4: while ((entry = zip.getNextEntry()) != null) {
                    String elementName = entry.getName();
                    if (!elementName.endsWith(".class")) continue;
                    byte[] chunk = new byte[8];
                    int bytesRead = zip.read(chunk, 0, 8);
                    zip.closeEntry();
                    if (bytesRead != 8) {
                        System.err.println(">> Corrupt class file: " + elementName);
                        success = false;
                        continue;
                    }
                    for (int i = 0; i < expectedMagicNumber.length; ++i) {
                        if (chunk[i] == expectedMagicNumber[i]) continue;
                        System.err.println(">> Bad magic number in " + elementName);
                        success = false;
                        continue block4;
                    }
                    int major = ((chunk[6] & 0xFF) << 8) + (chunk[7] & 0xFF);
                    if (major > highest) {
                        highest = major;
                    }
                    if (major < lowest) {
                        lowest = major;
                    }
                    if (low <= major && major > high) continue;
                }
            }
            catch (EOFException e) {
                // empty catch block
            }
            zip.close();
            if (lowest == highest) {
                System.out.println(convertMachineToHuman.get(highest));
            } else {
                System.out.println(convertMachineToHuman.get(lowest) + "-" + convertMachineToHuman.get(highest));
            }
            return success;
        }
        catch (IOException e) {
            System.err.println(">> Problem reading jar file.");
            return false;
        }
    }

    public static void main(String[] args) {
        int low = convertHumanToMachine.get(VERSION_STRING);
        int high = convertHumanToMachine.get("1.5");
        String dirPath = System.getProperty("user.dir") + "/dist/";
        File dir = new File(dirPath);
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile() || !files[i].getName().endsWith("jar")) continue;
                System.out.println(files[i].getName());
                boolean success = JarCheck.checkJar(files[i].getAbsolutePath(), low, high);
                System.out.println(success);
            }
        }
    }

    static {
        convertHumanToMachine.put("1.0", 44);
        convertHumanToMachine.put("1.1", 45);
        convertHumanToMachine.put("1.2", 46);
        convertHumanToMachine.put(VERSION_STRING, 47);
        convertHumanToMachine.put("1.4", 48);
        convertHumanToMachine.put("1.5", 49);
        convertHumanToMachine.put("1.6", 50);
        convertHumanToMachine.put("1.7", 51);
        convertMachineToHuman.put(44, "1.0");
        convertMachineToHuman.put(45, "1.1");
        convertMachineToHuman.put(46, "1.2");
        convertMachineToHuman.put(47, VERSION_STRING);
        convertMachineToHuman.put(48, "1.4");
        convertMachineToHuman.put(49, "1.5");
        convertMachineToHuman.put(50, "1.6");
        convertMachineToHuman.put(51, "1.7");
    }
}

