/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class BufferUtil {
    private static Logger log = Logger.getLogger(BufferUtil.class);
    private static final int BUFFER_SIZE = 1024;

    public static ByteBuffer readInputStream(InputStream in) throws IOException {
        ReadableByteChannel ch = Channels.newChannel(in);
        LinkedList<ByteBuffer> list = new LinkedList<ByteBuffer>();
        int sum = 0;
        int read = 0;
        do {
            ByteBuffer b;
            if ((read = ch.read(b = BufferUtil.createByteBuffer(1024))) <= 0) continue;
            b.flip();
            list.add(b);
            sum += read;
        } while (read != -1);
        if (list.size() == 1) {
            return (ByteBuffer)list.get(0);
        }
        ByteBuffer bb = BufferUtil.createByteBuffer(sum);
        Iterator ite = list.iterator();
        while (ite.hasNext()) {
            bb.put((ByteBuffer)ite.next());
        }
        list.clear();
        return bb;
    }

    public static ByteBuffer createByteBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
    }

    public static InputStream newInputStream(final ByteBuffer buf) {
        return new InputStream(){

            public synchronized int read() throws IOException {
                if (!buf.hasRemaining()) {
                    log.debug((Object)"done");
                    return -1;
                }
                log.debug((Object)"#");
                return buf.get();
            }

            public synchronized int read(byte[] bytes) throws IOException {
                if (!buf.hasRemaining()) {
                    log.debug((Object)"done");
                    return -1;
                }
                log.debug((Object)"#");
                int len = Math.min(bytes.length, buf.remaining());
                buf.get(bytes, 0, len);
                return len;
            }

            public synchronized int read(byte[] bytes, int off, int len) throws IOException {
                len = Math.min(len, buf.remaining());
                buf.get(bytes, off, len);
                return len;
            }
        };
    }

    public static byte[] getBytesFromInputStream(InputStream is) throws IOException {
        BufferedInputStream bufIn = new BufferedInputStream(is);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        int c = bufIn.read();
        while (c != -1) {
            bos.write(c);
            c = bufIn.read();
        }
        bos.flush();
        baos.flush();
        bufIn.close();
        bos.close();
        return baos.toByteArray();
    }
}

