/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.utils.SingleTraversalUtilVisitorCallback;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.wml.Body;
import org.docx4j.wml.Document;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Text;

public class VariablePrepare {
    public static void main(String[] args) throws Exception {
        boolean save = true;
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/unmarshallFromTemplateDirtyExample.docx";
        WordprocessingMLPackage wmlPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        System.out.println(XmlUtils.marshaltoString(wmlPackage.getMainDocumentPart().getJaxbElement(), true, true));
        WordprocessingMLPackage.FilterSettings filterSettings = new WordprocessingMLPackage.FilterSettings();
        filterSettings.setRemoveProofErrors(true);
        filterSettings.setRemoveContentControls(true);
        filterSettings.setRemoveRsids(true);
        wmlPackage.filter(filterSettings);
        System.out.println(XmlUtils.marshaltoString(wmlPackage.getMainDocumentPart().getJaxbElement(), true, true));
        Document wmlDocumentEl = (Document)wmlPackage.getMainDocumentPart().getJaxbElement();
        Body body = wmlDocumentEl.getBody();
        SingleTraversalUtilVisitorCallback paragraphVisitor = new SingleTraversalUtilVisitorCallback(new TraversalUtilParagraphVisitor());
        paragraphVisitor.walkJAXBElements(body);
        System.out.println(XmlUtils.marshaltoString(wmlPackage.getMainDocumentPart().getJaxbElement(), true, true));
        if (save) {
            SaveToZipFile saver = new SaveToZipFile(wmlPackage);
            saver.save(System.getProperty("user.dir") + "/OUT_VariablePrepare.docx");
            System.out.println("Saved");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TraversalUtilParagraphVisitor
    extends TraversalUtilVisitor<P> {
        @Override
        public void apply(P p, Object parent, List<Object> siblings) {
            List<Object> existingContents = p.getContent();
            ArrayList<Object> newContents = new ArrayList<Object>();
            R currentR = null;
            String currentRPrString = null;
            for (Object o : existingContents) {
                if (o instanceof R) {
                    if (currentR == null) {
                        currentR = (R)o;
                        if (currentR.getRPr() != null) {
                            currentRPrString = XmlUtils.marshaltoString(currentR.getRPr(), true);
                        }
                        newContents.add(currentR);
                        continue;
                    }
                    RPr other = ((R)o).getRPr();
                    boolean makeNewRun = true;
                    if (currentRPrString == null && other == null) {
                        makeNewRun = false;
                    }
                    if (currentRPrString != null && other != null && XmlUtils.marshaltoString(other, true).equals(currentRPrString)) {
                        makeNewRun = false;
                    }
                    if (makeNewRun) {
                        currentR = (R)o;
                        currentRPrString = currentR.getRPr() == null ? null : XmlUtils.marshaltoString(currentR.getRPr(), true);
                        newContents.add(currentR);
                        continue;
                    }
                    currentR.getContent().addAll(((R)o).getContent());
                    continue;
                }
                newContents.add(o);
                currentR = null;
                currentRPrString = null;
            }
            for (Object o : newContents) {
                if (!(o instanceof R)) continue;
                ArrayList<Object> newRunContents = new ArrayList<Object>();
                Text currentT = null;
                for (Object rc : ((R)o).getContent()) {
                    if ((rc = XmlUtils.unwrap(rc)) instanceof Text) {
                        if (currentT == null) {
                            currentT = (Text)rc;
                            newRunContents.add(currentT);
                        } else {
                            String val = currentT.getValue();
                            currentT.setValue(val + ((Text)rc).getValue());
                        }
                        if (((Text)rc).getSpace() == null || !((Text)rc).getSpace().equals("preserve")) continue;
                        currentT.setSpace("preserve");
                        continue;
                    }
                    System.out.println(rc.getClass().getName());
                    newRunContents.add(rc);
                    currentT = null;
                }
                ((R)o).getContent().clear();
                ((R)o).getContent().addAll(newRunContents);
            }
            p.getContent().clear();
            p.getContent().addAll(newContents);
        }
    }
}

