/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.util.List;
import javax.xml.bind.JAXBContext;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.samples.AbstractSample;
import org.docx4j.wml.Body;
import org.docx4j.wml.Document;
import org.docx4j.wml.Text;

public class OpenMainDocumentAndTraverse
extends AbstractSample {
    public static JAXBContext context = Context.jc;

    public static void main(String[] args) throws Exception {
        try {
            OpenMainDocumentAndTraverse.getInputFilePath(args);
        }
        catch (IllegalArgumentException e) {
            inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/sample-docx.xml";
        }
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        MainDocumentPart documentPart = wordMLPackage.getMainDocumentPart();
        Document wmlDocumentEl = (Document)documentPart.getJaxbElement();
        Body body = wmlDocumentEl.getBody();
        new TraversalUtil(body, new TraversalUtil.Callback(){
            String indent = "";

            @Override
            public List<Object> apply(Object o) {
                String text = "";
                if (o instanceof Text) {
                    text = ((Text)o).getValue();
                }
                System.out.println(this.indent + o.getClass().getName() + "  \"" + text + "\"");
                return null;
            }

            @Override
            public boolean shouldTraverse(Object o) {
                return true;
            }

            @Override
            public void walkJAXBElements(Object parent) {
                this.indent = this.indent + "    ";
                List<Object> children = this.getChildren(parent);
                if (children != null) {
                    for (Object o : children) {
                        o = XmlUtils.unwrap(o);
                        this.apply(o);
                        if (!this.shouldTraverse(o)) continue;
                        this.walkJAXBElements(o);
                    }
                }
                this.indent = this.indent.substring(0, this.indent.length() - 4);
            }

            @Override
            public List<Object> getChildren(Object o) {
                return TraversalUtil.getChildrenImpl(o);
            }
        });
    }
}

