/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import org.docx4j.convert.out.flatOpcXml.FlatOpcXmlCreator;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.BufferUtil;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.Hdr;
import org.docx4j.wml.HdrFtrRef;
import org.docx4j.wml.HeaderReference;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.SectPr;

public class HeaderFooterCreate {
    private static ObjectFactory objectFactory = new ObjectFactory();

    public static void main(String[] args) throws Exception {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        MainDocumentPart mdp = wordMLPackage.getMainDocumentPart();
        Relationship styleRel = mdp.getStyleDefinitionsPart().getSourceRelationships().get(0);
        mdp.getRelationshipsPart().removeRelationship(styleRel);
        Relationship relationship = HeaderFooterCreate.createHeaderPart(wordMLPackage);
        HeaderFooterCreate.createHeaderReference(wordMLPackage, relationship);
        FlatOpcXmlCreator worker = new FlatOpcXmlCreator(wordMLPackage);
        worker.marshal(System.out);
    }

    public static Relationship createHeaderPart(WordprocessingMLPackage wordprocessingMLPackage) throws Exception {
        HeaderPart headerPart = new HeaderPart();
        Relationship rel = wordprocessingMLPackage.getMainDocumentPart().addTargetPart(headerPart);
        headerPart.setJaxbElement(HeaderFooterCreate.getHdr(wordprocessingMLPackage, headerPart));
        return rel;
    }

    public static void createHeaderReference(WordprocessingMLPackage wordprocessingMLPackage, Relationship relationship) throws InvalidFormatException {
        List<SectionWrapper> sections = wordprocessingMLPackage.getDocumentModel().getSections();
        SectPr sectPr = sections.get(sections.size() - 1).getSectPr();
        if (sectPr == null) {
            sectPr = objectFactory.createSectPr();
            wordprocessingMLPackage.getMainDocumentPart().addObject(sectPr);
            sections.get(sections.size() - 1).setSectPr(sectPr);
        }
        HeaderReference headerReference = objectFactory.createHeaderReference();
        headerReference.setId(relationship.getId());
        headerReference.setType(HdrFtrRef.DEFAULT);
        sectPr.getEGHdrFtrReferences().add(headerReference);
    }

    public static Hdr getHdr(WordprocessingMLPackage wordprocessingMLPackage, Part sourcePart) throws Exception {
        Hdr hdr = objectFactory.createHdr();
        File file = new File(System.getProperty("user.dir") + "/src/test/resources/images/greentick.png");
        FileInputStream is = new FileInputStream(file);
        hdr.getContent().add(HeaderFooterCreate.newImage(wordprocessingMLPackage, sourcePart, BufferUtil.getBytesFromInputStream(is), "filename", "alttext", 1, 2));
        return hdr;
    }

    public static P newImage(WordprocessingMLPackage wordMLPackage, Part sourcePart, byte[] bytes, String filenameHint, String altText, int id1, int id2) throws Exception {
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((OpcPackage)wordMLPackage, sourcePart, bytes);
        Inline inline = imagePart.createImageInline(filenameHint, altText, id1, id2, false);
        ObjectFactory factory = Context.getWmlObjectFactory();
        P p = factory.createP();
        R run = factory.createR();
        p.getContent().add(run);
        Drawing drawing = factory.createDrawing();
        run.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        return p;
    }
}

