/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.BindingHandler;
import org.docx4j.model.datastorage.OpenDoPEHandler;
import org.docx4j.model.datastorage.OpenDoPEIntegrity;
import org.docx4j.model.datastorage.RemovalHandler;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.utils.SingleTraversalUtilVisitorCallback;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.wml.Document;
import org.docx4j.wml.SdtElement;
import org.opendope.xpaths.Xpaths;

public class ContentControlsMergeXML {
    public static JAXBContext context = Context.jc;
    private static final boolean DEBUG = true;
    private static final boolean SAVE = true;

    public static void main(String[] args) throws Exception {
        String input_DOCX = System.getProperty("user.dir") + "/sample-docs/word/databinding/binding-simple.docx";
        String input_XML = System.getProperty("user.dir") + "/sample-docs/word/databinding/binding-simple-data.xml";
        String OUTPUT_DOCX = System.getProperty("user.dir") + "/OUT_ContentControlsMergeXML.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(input_DOCX));
        String itemId = ContentControlsMergeXML.getCustomXmlItemId(wordMLPackage).toLowerCase();
        System.out.println("Looking for item id: " + itemId);
        CustomXmlDataStoragePart customXmlDataStoragePart = wordMLPackage.getCustomXmlDataStorageParts().get(itemId);
        if (customXmlDataStoragePart == null) {
            System.out.println("Couldn't find CustomXmlDataStoragePart! exiting..");
            return;
        }
        System.out.println("Getting " + input_XML);
        FileInputStream fis = new FileInputStream(new File(input_XML));
        customXmlDataStoragePart.getData().setDocument(fis);
        SaveToZipFile saver = new SaveToZipFile(wordMLPackage);
        try {
            OpenDoPEHandler odh = new OpenDoPEHandler(wordMLPackage);
            odh.preprocess();
            OpenDoPEIntegrity odi = new OpenDoPEIntegrity();
            odi.process(wordMLPackage);
            String save_preprocessed = OUTPUT_DOCX.lastIndexOf(".") == -1 ? OUTPUT_DOCX + "_INT.docx" : OUTPUT_DOCX.substring(0, OUTPUT_DOCX.lastIndexOf(".")) + "_INT.docx";
            saver.save(save_preprocessed);
            System.out.println("Saved: " + save_preprocessed);
        }
        catch (Docx4JException d) {
            System.out.println(d.getMessage());
        }
        BindingHandler.applyBindings(wordMLPackage);
        RemovalHandler rh = new RemovalHandler();
        rh.removeSDTs(wordMLPackage, RemovalHandler.Quantifier.ALL, new String[0]);
        saver.save(OUTPUT_DOCX);
        System.out.println("Saved: " + OUTPUT_DOCX);
    }

    private static String getCustomXmlItemId(WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        MainDocumentPart documentPart = wordMLPackage.getMainDocumentPart();
        if (wordMLPackage.getMainDocumentPart().getXPathsPart() == null) {
            TraversalUtilCCVisitor visitor = new TraversalUtilCCVisitor();
            SingleTraversalUtilVisitorCallback ccFinder = new SingleTraversalUtilVisitorCallback(visitor);
            ccFinder.walkJAXBElements(((Document)wordMLPackage.getMainDocumentPart().getJaxbElement()).getBody());
            return visitor.storeItemID;
        }
        Xpaths xPaths = (Xpaths)wordMLPackage.getMainDocumentPart().getXPathsPart().getJaxbElement();
        return xPaths.getXpath().get(0).getDataBinding().getStoreItemID();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TraversalUtilCCVisitor
    extends TraversalUtilVisitor<SdtElement> {
        String storeItemID = null;

        @Override
        public void apply(SdtElement element, Object parent, List<Object> siblings) {
            if (element.getSdtPr() != null && element.getSdtPr().getDataBinding() != null) {
                this.storeItemID = element.getSdtPr().getDataBinding().getStoreItemID();
            }
        }
    }
}

