/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.Body;
import org.docx4j.wml.Br;
import org.docx4j.wml.CTEndnotes;
import org.docx4j.wml.CTFootnotes;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Document;
import org.docx4j.wml.Ftr;
import org.docx4j.wml.Hdr;
import org.docx4j.wml.Lvl;
import org.docx4j.wml.Numbering;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainDocumentPart
extends DocumentPart<Document>
implements ContentAccessor {
    private static Logger log = Logger.getLogger(MainDocumentPart.class);
    private PropertyResolver propertyResolver;
    private StyleTree styleTree;

    public MainDocumentPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public MainDocumentPart() throws InvalidFormatException {
        super(new PartName("/word/document.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
    }

    @Override
    public List<Object> getContent() {
        if (this.getJaxbElement() == null) {
            this.setJaxbElement(Context.getWmlObjectFactory().createDocument());
        }
        if (((Document)this.getJaxbElement()).getBody() == null) {
            ((Document)this.getJaxbElement()).setBody(Context.getWmlObjectFactory().createBody());
        }
        return ((Document)this.getJaxbElement()).getContent();
    }

    public PropertyResolver getPropertyResolver() {
        if (this.propertyResolver == null) {
            try {
                this.propertyResolver = new PropertyResolver((WordprocessingMLPackage)this.pack);
            }
            catch (Docx4JException e) {
                e.printStackTrace();
            }
        }
        return this.propertyResolver;
    }

    public StyleTree getStyleTree() {
        return this.getStyleTree(false);
    }

    public StyleTree getStyleTree(boolean refresh) {
        if (refresh || this.styleTree == null) {
            log.info((Object)"Preparing StyleTree");
            ArrayList<String> stylesInUse = new ArrayList<String>();
            for (Map.Entry<String, String> pairs : this.getStylesInUse().entrySet()) {
                String styleId = pairs.getKey();
                stylesInUse.add(styleId);
            }
            try {
                this.getStyleDefinitionsPart().createVirtualStylesForDocDefaults();
            }
            catch (Docx4JException e) {
                log.error((Object)e);
            }
            Style defaultParagraphStyle = this.getStyleDefinitionsPart().getDefaultParagraphStyle();
            Style defaultCharacterStyle = this.getStyleDefinitionsPart().getDefaultCharacterStyle();
            HashMap<String, Style> allStyles = new HashMap<String, Style>();
            Styles styles = (Styles)this.getStyleDefinitionsPart().getJaxbElement();
            for (Style s : styles.getStyle()) {
                allStyles.put(s.getStyleId(), s);
            }
            this.styleTree = new StyleTree(stylesInUse, allStyles, defaultParagraphStyle.getStyleId(), defaultCharacterStyle.getStyleId());
        }
        return this.styleTree;
    }

    public Map fontsInUse() {
        HashMap<String, String> fontsDiscovered = new HashMap<String, String>();
        HashMap<String, String> stylesInUse = new HashMap<String, String>();
        Styles styles = null;
        if (this.getStyleDefinitionsPart() != null) {
            styles = (Styles)this.getStyleDefinitionsPart().getJaxbElement();
        }
        HashMap<String, Style> stylesDefined = new HashMap<String, Style>();
        if (styles != null) {
            for (Style s : styles.getStyle()) {
                stylesDefined.put(s.getStyleId(), s);
            }
        }
        Document wmlDocumentEl = (Document)this.getJaxbElement();
        Body body = wmlDocumentEl.getBody();
        List<Object> bodyChildren = body.getEGBlockLevelElts();
        Finder finder = new Finder(fontsDiscovered, stylesInUse);
        new TraversalUtil(bodyChildren, finder);
        fontsDiscovered.put(((WordprocessingMLPackage)this.pack).getDefaultFont(), ((WordprocessingMLPackage)this.pack).getDefaultFont());
        fontsDiscovered.put(((WordprocessingMLPackage)this.pack).getMainDocumentPart().getPropertyResolver().getDefaultFontEastAsia(), ((WordprocessingMLPackage)this.pack).getMainDocumentPart().getPropertyResolver().getDefaultFontEastAsia());
        for (Map.Entry pairs : stylesInUse.entrySet()) {
            String styleName = (String)pairs.getKey();
            log.debug((Object)("Inspecting style: " + styleName));
            Style existingStyle = (Style)stylesDefined.get(styleName);
            if (existingStyle != null) {
                this.getPropertyResolver();
                String fontName = PropertyResolver.getFontnameFromStyle(stylesDefined, this.getThemePart(), existingStyle);
                if (fontName == null) continue;
                log.debug((Object)(styleName + " uses font " + fontName));
                fontsDiscovered.put(fontName, fontName);
                continue;
            }
            log.error((Object)("Couldn't find used style " + styleName + "in styles part!"));
        }
        if (this.getNumberingDefinitionsPart() != null) {
            Numbering numbering = (Numbering)this.getNumberingDefinitionsPart().getJaxbElement();
            for (Numbering.AbstractNum abstractNumNode : numbering.getAbstractNum()) {
                for (Lvl lvl : abstractNumNode.getLvl()) {
                    String fontName;
                    if (lvl.getRPr() == null || lvl.getRPr().getRFonts() == null || (fontName = lvl.getRPr().getRFonts().getAscii()) == null) continue;
                    fontsDiscovered.put(fontName, fontName);
                    log.debug((Object)("Registered " + fontName + " for abstract list " + abstractNumNode.getAbstractNumId() + " lvl " + lvl.getIlvl()));
                }
            }
        }
        return fontsDiscovered;
    }

    public Map<String, String> getStylesInUse() {
        Document wmlDocumentEl = (Document)this.getJaxbElement();
        Body body = wmlDocumentEl.getBody();
        List<Object> bodyChildren = body.getEGBlockLevelElts();
        HashMap<String, String> stylesInUse = new HashMap<String, String>();
        Finder finder = new Finder(null, stylesInUse);
        new TraversalUtil(bodyChildren, finder);
        RelationshipsPart rp = this.getRelationshipsPart();
        if (rp != null) {
            for (Relationship r : rp.getRelationships().getRelationship()) {
                Part part = rp.getPart(r);
                if (part instanceof FooterPart) {
                    Ftr ftr = (Ftr)((FooterPart)part).getJaxbElement();
                    finder.walkJAXBElements(ftr);
                    continue;
                }
                if (!(part instanceof HeaderPart)) continue;
                Hdr hdr = (Hdr)((HeaderPart)part).getJaxbElement();
                finder.walkJAXBElements(hdr);
            }
        }
        if (this.getEndNotesPart() != null) {
            log.debug((Object)"Looking at endnotes");
            CTEndnotes endnotes = (CTEndnotes)this.getEndNotesPart().getJaxbElement();
            finder.walkJAXBElements(endnotes);
        }
        if (this.getFootnotesPart() != null) {
            log.debug((Object)"Looking at footnotes");
            CTFootnotes footnotes = (CTFootnotes)this.getFootnotesPart().getJaxbElement();
            finder.walkJAXBElements(footnotes);
        }
        if (this.getCommentsPart() != null) {
            log.debug((Object)"Looking at comments");
            Comments comments = (Comments)this.getCommentsPart().getJaxbElement();
            finder.walkJAXBElements(comments);
        }
        return stylesInUse;
    }

    public P addStyledParagraphOfText(String styleId, String text) {
        P p = this.createStyledParagraphOfText(styleId, text);
        this.addObject(p);
        return p;
    }

    public P createStyledParagraphOfText(String styleId, String text) {
        P p = this.createParagraphOfText(text);
        StyleDefinitionsPart styleDefinitionsPart = this.getStyleDefinitionsPart();
        if (this.getPropertyResolver().activateStyle(styleId)) {
            ObjectFactory factory = Context.getWmlObjectFactory();
            PPr pPr = factory.createPPr();
            p.setPPr(pPr);
            PPrBase.PStyle pStyle = factory.createPPrBasePStyle();
            pPr.setPStyle(pStyle);
            pStyle.setVal(styleId);
        }
        return p;
    }

    public P addParagraphOfText(String simpleText) {
        P para = this.createParagraphOfText(simpleText);
        this.addObject(para);
        return para;
    }

    public P createParagraphOfText(String simpleText) {
        ObjectFactory factory = Context.getWmlObjectFactory();
        P para = factory.createP();
        if (simpleText != null) {
            Text t = factory.createText();
            t.setValue(simpleText);
            R run = factory.createR();
            run.getContent().add(t);
            para.getContent().add(run);
        }
        return para;
    }

    public void addObject(Object o) {
        this.getContent().add(o);
        HashMap<String, String> stylesInUse = new HashMap<String, String>();
        HashMap fontsDiscovered = new HashMap();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(o);
        Finder finder = new Finder(fontsDiscovered, stylesInUse);
        finder.walkJAXBElements(list);
        for (Map.Entry pairs : stylesInUse.entrySet()) {
            String styleName = (String)pairs.getKey();
            log.debug((Object)("Inspecting style: " + styleName));
            if (this.styleDefinitionsPart == null) {
                log.warn((Object)"Style definitions part was null!");
                continue;
            }
            if (this.getPropertyResolver().activateStyle(styleName)) continue;
            log.warn((Object)(styleName + " couldn't be activated!"));
        }
    }

    public P addParagraph(String pXml) throws JAXBException {
        P para = (P)XmlUtils.unmarshalString(pXml);
        this.getContent().add(para);
        return para;
    }

    public static P.Hyperlink hyperlinkToBookmark(String bookmarkName, String linkText) {
        try {
            String hpl = "<w:hyperlink w:anchor=\"" + bookmarkName + "\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" " + "w:history=\"1\" >" + "<w:r>" + "<w:rPr>" + "<w:rStyle w:val=\"Hyperlink\" />" + "</w:rPr>" + "<w:t>" + linkText + "</w:t>" + "</w:r>" + "</w:hyperlink>";
            return (P.Hyperlink)XmlUtils.unmarshalString(hpl);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Finder
    extends TraversalUtil.CallbackImpl {
        Map fontsDiscovered;
        Map<String, String> stylesInUse;

        Finder(Map fontsDiscovered, Map<String, String> stylesInUse) {
            this.fontsDiscovered = fontsDiscovered;
            this.stylesInUse = stylesInUse;
        }

        @Override
        public List<Object> apply(Object o) {
            if (o instanceof P && ((P)o).getPPr() != null) {
                PPr pPr = ((P)o).getPPr();
                if (this.stylesInUse != null && pPr.getPStyle() != null) {
                    log.debug((Object)("put style " + pPr.getPStyle().getVal()));
                    this.stylesInUse.put(pPr.getPStyle().getVal(), pPr.getPStyle().getVal());
                }
                if (pPr.getRPr() != null) {
                    ParaRPr rPr = pPr.getRPr();
                    if (this.fontsDiscovered != null && rPr.getRFonts() != null) {
                        this.fontsDiscovered.put(rPr.getRFonts().getAscii(), rPr.getRFonts().getAscii());
                    }
                    if (this.stylesInUse != null && rPr.getRStyle() != null) {
                        this.stylesInUse.put(rPr.getRStyle().getVal(), rPr.getRStyle().getVal());
                    }
                }
            } else if (o instanceof R && ((R)o).getRPr() != null) {
                RPr rPr = ((R)o).getRPr();
                if (this.fontsDiscovered != null && rPr.getRFonts() != null) {
                    this.fontsDiscovered.put(rPr.getRFonts().getAscii(), rPr.getRFonts().getAscii());
                }
                if (this.stylesInUse != null && rPr.getRStyle() != null) {
                    this.stylesInUse.put(rPr.getRStyle().getVal(), rPr.getRStyle().getVal());
                }
            } else if (o instanceof R.Sym) {
                if (this.fontsDiscovered != null) {
                    R.Sym sym = (R.Sym)o;
                    this.fontsDiscovered.put(sym.getFont(), sym.getFont());
                }
            } else if (o instanceof Tbl) {
                Tbl tbl = (Tbl)o;
                if (this.stylesInUse != null && tbl.getTblPr() != null && tbl.getTblPr().getTblStyle() != null) {
                    log.debug((Object)("Adding table style: " + tbl.getTblPr().getTblStyle().getVal()));
                    this.stylesInUse.put(tbl.getTblPr().getTblStyle().getVal(), tbl.getTblPr().getTblStyle().getVal());
                }
            }
            return null;
        }

        @Override
        public boolean shouldTraverse(Object o) {
            return !(o instanceof Br) && !(o instanceof R.Tab) && !(o instanceof R.LastRenderedPageBreak);
        }
    }
}

