/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageBmpPart;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.junit.Assert;
import org.junit.Test;

public class ImageTypeBmpTest {
    @Test
    public void testExtensions() throws Exception {
        int offset;
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        File file = new File(System.getProperty("user.dir") + "/src/test/resources/images/VENUS.BMP");
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            System.out.println("File too large!!");
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            System.out.println("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        String filenameHint = null;
        String altText = null;
        int id1 = 0;
        int id2 = 1;
        P p = ImageTypeBmpTest.newImage(wordMLPackage, bytes, filenameHint, altText, id1, id2);
        wordMLPackage.getMainDocumentPart().addObject(p);
    }

    public static P newImage(WordprocessingMLPackage wordMLPackage, byte[] bytes, String filenameHint, String altText, int id1, int id2) throws Exception {
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart(wordMLPackage, bytes);
        Assert.assertTrue((boolean)(imagePart instanceof ImageBmpPart));
        Inline inline = imagePart.createImageInline(filenameHint, altText, id1, id2);
        ObjectFactory factory = new ObjectFactory();
        P p = factory.createP();
        R run = factory.createR();
        p.getParagraphContent().add(run);
        Drawing drawing = factory.createDrawing();
        run.getRunContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        return p;
    }
}

