/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.SpreadsheetML;

import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.SpreadsheetML.CalcChain;
import org.docx4j.openpackaging.parts.SpreadsheetML.CommentsPart;
import org.docx4j.openpackaging.parts.SpreadsheetML.ConnectionsPart;
import org.docx4j.openpackaging.parts.SpreadsheetML.PivotCacheDefinition;
import org.docx4j.openpackaging.parts.SpreadsheetML.PivotCacheRecords;
import org.docx4j.openpackaging.parts.SpreadsheetML.PivotTable;
import org.docx4j.openpackaging.parts.SpreadsheetML.PrinterSettings;
import org.docx4j.openpackaging.parts.SpreadsheetML.QueryTablePart;
import org.docx4j.openpackaging.parts.SpreadsheetML.SharedStrings;
import org.docx4j.openpackaging.parts.SpreadsheetML.Styles;
import org.docx4j.openpackaging.parts.SpreadsheetML.TablePart;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorksheetPart;
import org.xlsx4j.jaxb.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaxbSmlPart<E>
extends JaxbXmlPart<E> {
    public JaxbSmlPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.setJAXBContext(Context.jcSML);
    }

    public JaxbSmlPart() throws InvalidFormatException {
        super(new PartName("/xl/blagh.xml"));
        this.setJAXBContext(Context.jcSML);
    }

    public static Part newPartForContentType(String contentType, String partName) throws InvalidFormatException, PartUnrecognisedException {
        if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.printerSettings")) {
            return new PrinterSettings(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml")) {
            return new Styles(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml")) {
            return new WorksheetPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml")) {
            return new CalcChain(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml")) {
            return new SharedStrings(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml")) {
            return new PivotTable(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml")) {
            return new PivotCacheDefinition(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml")) {
            return new PivotCacheRecords(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml")) {
            return new CommentsPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml")) {
            return new ConnectionsPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml")) {
            return new TablePart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml")) {
            return new QueryTablePart(new PartName(partName));
        }
        throw new PartUnrecognisedException("No subclass found for " + partName + " (content type '" + contentType + "')");
    }
}

