/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.packages;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.docx4j.convert.in.FlatOpcXmlImporter;
import org.docx4j.convert.out.flatOpcXml.FlatOpcXmlCreator;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.jaxb.NamespacePrefixMapperUtils;
import org.docx4j.openpackaging.Base;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io.LoadFromZipNG;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.Filetype;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsCustomPart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.ExternalTarget;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.Parts;
import org.docx4j.xmlPackage.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpcPackage
extends Base {
    private static Logger log = Logger.getLogger(OpcPackage.class);
    public HashMap<String, String> handled = new HashMap();
    protected Parts parts = new Parts();
    protected HashMap<ExternalTarget, Part> externalResources = new HashMap();
    protected HashMap<String, CustomXmlDataStoragePart> customXmlDataStorageParts = new HashMap();
    protected ContentTypeManager contentTypeManager;
    protected DocPropsCorePart docPropsCorePart;
    protected DocPropsExtendedPart docPropsExtendedPart;
    protected DocPropsCustomPart docPropsCustomPart;

    public Parts getParts() {
        return this.parts;
    }

    public HashMap<ExternalTarget, Part> getExternalResources() {
        return this.externalResources;
    }

    public HashMap<String, CustomXmlDataStoragePart> getCustomXmlDataStorageParts() {
        return this.customXmlDataStorageParts;
    }

    public ContentTypeManager getContentTypeManager() {
        return this.contentTypeManager;
    }

    public void setContentTypeManager(ContentTypeManager contentTypeManager) {
        this.contentTypeManager = contentTypeManager;
    }

    public OpcPackage() {
        try {
            this.partName = new PartName("/", false);
            this.contentTypeManager = new ContentTypeManager();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
    }

    public OpcPackage(ContentTypeManager contentTypeManager) {
        try {
            this.partName = new PartName("/", false);
            this.contentTypeManager = contentTypeManager;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
    }

    @Override
    public OpcPackage getPackage() {
        return this;
    }

    public static OpcPackage load(File docxFile) throws Docx4JException {
        return OpcPackage.load(docxFile, null);
    }

    public static OpcPackage load(File docxFile, String password) throws Docx4JException {
        try {
            return OpcPackage.load((InputStream)new FileInputStream(docxFile), password);
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
            throw new Docx4JException("Couldn't load file from " + docxFile.getAbsolutePath(), e);
        }
    }

    public static OpcPackage load(InputStream inputStream) throws Docx4JException {
        return OpcPackage.load(inputStream, "");
    }

    public static OpcPackage load(InputStream inputStream, String password) throws Docx4JException {
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        bis.mark(0);
        byte[] firstTwobytes = new byte[2];
        int read = 0;
        try {
            read = bis.read(firstTwobytes);
            bis.reset();
        }
        catch (IOException e) {
            throw new Docx4JException("Error reading from the stream", e);
        }
        if (read != 2) {
            throw new Docx4JException("Error reading from the stream (no bytes available)");
        }
        if (firstTwobytes[0] == 80 && firstTwobytes[1] == 75) {
            return OpcPackage.load(bis, Filetype.ZippedPackage, null);
        }
        if (firstTwobytes[0] == -48 && firstTwobytes[1] == -49) {
            log.info((Object)"Detected compound file");
            return OpcPackage.load(bis, Filetype.Compound, password);
        }
        log.info((Object)"Assuming Flat OPC XML");
        return OpcPackage.load(bis, Filetype.FlatOPC, null);
    }

    @Deprecated
    public static OpcPackage load(InputStream is, boolean docxFormat) throws Docx4JException {
        return OpcPackage.load(is);
    }

    public static OpcPackage load(InputStream is, Filetype type) throws Docx4JException {
        return OpcPackage.load(is, type, null);
    }

    public static OpcPackage load(InputStream is, Filetype type, String password) throws Docx4JException {
        FlatOpcXmlImporter xmlPackage;
        if (type.equals((Object)Filetype.ZippedPackage)) {
            LoadFromZipNG loader = new LoadFromZipNG();
            return loader.get(is);
        }
        if (type.equals((Object)Filetype.Compound)) {
            try {
                POIFSFileSystem fs = new POIFSFileSystem(is);
                EncryptionInfo info = new EncryptionInfo(fs);
                Decryptor d = Decryptor.getInstance((EncryptionInfo)info);
                d.verifyPassword(password);
                InputStream is2 = d.getDataStream(fs);
                LoadFromZipNG loader = new LoadFromZipNG();
                return loader.get(is2);
            }
            catch (InvalidKeyException e) {
                throw new Docx4JException("Problem reading compound file: wrong password?", e);
            }
            catch (Exception e) {
                throw new Docx4JException("Problem reading compound file", e);
            }
        }
        try {
            Unmarshaller u = Context.jcXmlPackage.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            Package wmlPackageEl = (Package)((JAXBElement)u.unmarshal((Source)new StreamSource(is))).getValue();
            xmlPackage = new FlatOpcXmlImporter(wmlPackageEl);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new Docx4JException("Couldn't load xml from stream ", e);
        }
        return xmlPackage.get();
    }

    public void save(File docxFile) throws Docx4JException {
        this.save(docxFile, null);
    }

    private void save(File docxFile, String password) throws Docx4JException {
        block3: {
            if (docxFile.getName().endsWith(".xml")) {
                FlatOpcXmlCreator worker = new FlatOpcXmlCreator(this);
                Package pkg = worker.get();
                JAXBContext jc = Context.jcXmlPackage;
                try {
                    Marshaller marshaller = jc.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                    NamespacePrefixMapperUtils.setProperty(marshaller, NamespacePrefixMapperUtils.getPrefixMapper());
                    marshaller.marshal((Object)pkg, (OutputStream)new FileOutputStream(docxFile));
                }
                catch (Exception e) {
                    throw new Docx4JException("Error saving Flat OPC XML", e);
                }
                return;
            }
            if (password != null) break block3;
            SaveToZipFile saver = new SaveToZipFile(this);
            saver.save(docxFile);
        }
    }

    @Override
    public boolean setPartShortcut(Part part, String relationshipType) {
        if (relationshipType.equals("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties")) {
            this.docPropsCorePart = (DocPropsCorePart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties")) {
            this.docPropsCustomPart = (DocPropsCustomPart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties")) {
            this.docPropsExtendedPart = (DocPropsExtendedPart)part;
            return true;
        }
        return false;
    }

    public DocPropsCorePart getDocPropsCorePart() {
        return this.docPropsCorePart;
    }

    public DocPropsExtendedPart getDocPropsExtendedPart() {
        return this.docPropsExtendedPart;
    }

    public DocPropsCustomPart getDocPropsCustomPart() {
        return this.docPropsCustomPart;
    }

    public OpcPackage clone() {
        OpcPackage result = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SaveToZipFile saver = new SaveToZipFile(this);
        try {
            saver.save(baos);
            result = OpcPackage.load(new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (Docx4JException e) {
            e.printStackTrace();
        }
        return result;
    }
}

