/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.bibliography.CTSources;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.CustomXmlDataStorage;
import org.docx4j.openpackaging.Base;
import org.docx4j.openpackaging.URIHelper;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.openpackaging.io.ExternalResourceUtils;
import org.docx4j.openpackaging.io.Load;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePropertiesPart;
import org.docx4j.openpackaging.parts.DefaultXmlPart;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsCustomPart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.openpackaging.parts.WordprocessingML.BibliographyPart;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.XmlPart;
import org.docx4j.openpackaging.parts.digitalsignature.XmlSignaturePart;
import org.docx4j.openpackaging.parts.opendope.ComponentsPart;
import org.docx4j.openpackaging.parts.opendope.ConditionsPart;
import org.docx4j.openpackaging.parts.opendope.QuestionsPart;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.opendope.components.Components;
import org.opendope.conditions.Conditions;
import org.opendope.questions.Questionnaire;
import org.opendope.xpaths.Xpaths;

public class LoadFromZipFile
extends Load {
    private static Logger log = Logger.getLogger(LoadFromZipFile.class);
    private static boolean conserveMemory = false;

    public static void setConserveMemory(boolean conserveMemoryVal) {
        conserveMemory = conserveMemoryVal;
    }

    public static void main(String[] args) throws Exception {
        String filepath = System.getProperty("user.dir") + "/sample-docs/FontEmbedded.docx";
        log.info((Object)("Path: " + filepath));
        LoadFromZipFile loader = new LoadFromZipFile();
        loader.get(filepath);
    }

    public OpcPackage get(String filepath) throws Docx4JException {
        return this.get(new File(filepath));
    }

    public OpcPackage get(File f) throws Docx4JException {
        log.info((Object)("Filepath = " + f.getPath()));
        ZipFile zf = null;
        try {
            if (!f.exists()) {
                log.info((Object)("Couldn't find " + f.getPath()));
            }
            zf = new ZipFile(f);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new Docx4JException("Couldn't get ZipFile", ioe);
        }
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
        }
        ContentTypeManager ctm = new ContentTypeManager();
        try {
            InputStream is = LoadFromZipFile.getInputStreamFromZippedPart(zf, "[Content_Types].xml");
            ctm.parseContentTypesFile(is);
        }
        catch (IOException e) {
            throw new Docx4JException("Couldn't get [Content_Types].xml from ZipFile", e);
        }
        OpcPackage p = ctm.createPackage();
        String partName = "_rels/.rels";
        RelationshipsPart rp = this.getRelationshipsPartFromZip(p, zf, partName);
        p.setRelationships(rp);
        log.info((Object)("Object created for: " + partName));
        this.addPartsFromRelationships(zf, p, rp, ctm);
        try {
            zf.close();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        LoadFromZipFile.registerCustomXmlDataStorageParts(p);
        return p;
    }

    private RelationshipsPart getRelationshipsPartFromZip(Base p, ZipFile zf, String partName) throws Docx4JException {
        RelationshipsPart rp = null;
        InputStream is = null;
        try {
            is = LoadFromZipFile.getInputStreamFromZippedPart(zf, partName);
            rp = new RelationshipsPart(new PartName("/" + partName));
            rp.setSourceP(p);
            rp.unmarshal(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Docx4JException("Error getting document from Zipped Part:" + partName, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                }
            }
        }
        return rp;
    }

    private static InputStream getInputStreamFromZippedPart(ZipFile zf, String partName) throws IOException {
        InputStream in = null;
        in = zf.getInputStream(zf.getEntry(partName));
        return in;
    }

    private void addPartsFromRelationships(ZipFile zf, Base source, RelationshipsPart rp, ContentTypeManager ctm) throws Docx4JException {
        OpcPackage pkg = source.getPackage();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            log.info((Object)("\n For Relationship Id=" + r.getId() + " Source is " + rp.getSourceP().getPartName() + ", Target is " + r.getTarget()));
            try {
                this.getPart(zf, pkg, rp, r, ctm);
            }
            catch (Exception e) {
                throw new Docx4JException("Failed to add parts from relationships", e);
            }
        }
    }

    private void getPart(ZipFile zf, OpcPackage pkg, RelationshipsPart rp, Relationship r, ContentTypeManager ctm) throws Docx4JException, InvalidFormatException, URISyntaxException {
        RelationshipsPart rrp;
        Base source = null;
        String resolvedPartUri = null;
        if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink")) {
            log.info((Object)("Encountered (but not loading) hyperlink " + r.getTarget()));
            return;
        }
        if (r.getTargetMode() != null && r.getTargetMode().equals("External")) {
            if (this.loadExternalTargets && r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/image")) {
                log.warn((Object)("Loading external resource " + r.getTarget() + " of type " + r.getType()));
                BinaryPart bp = ExternalResourceUtils.getExternalResource(r.getTarget());
                pkg.getExternalResources().put(bp.getExternalTarget(), bp);
            } else {
                log.warn((Object)("Encountered (but not loading) external resource " + r.getTarget() + " of type " + r.getType()));
            }
            return;
        }
        source = rp.getSourceP();
        resolvedPartUri = URIHelper.resolvePartUri(rp.getSourceURI(), new URI(r.getTarget())).toString();
        resolvedPartUri = resolvedPartUri.substring(1);
        if (pkg.handled.get(resolvedPartUri) != null) {
            return;
        }
        String relationshipType = r.getType();
        Part part = LoadFromZipFile.getRawPart(zf, ctm, resolvedPartUri, r);
        if (part instanceof BinaryPart || part instanceof DefaultXmlPart) {
            part.setRelationshipType(relationshipType);
        }
        rp.loadPart(part, r);
        pkg.handled.put(resolvedPartUri, resolvedPartUri);
        if (source.setPartShortcut(part, relationshipType)) {
            log.info((Object)("Convenience method established from " + source.getPartName() + " to " + part.getPartName()));
        }
        if ((rrp = this.getRelationshipsPart(zf, part)) != null) {
            this.addPartsFromRelationships(zf, part, rrp, ctm);
            String relPart = PartName.getRelationshipsPartName(part.getPartName().getName().substring(1));
        }
    }

    public RelationshipsPart getRelationshipsPart(ZipFile zf, Part part) throws Docx4JException, InvalidFormatException {
        RelationshipsPart rrp = null;
        String relPart = PartName.getRelationshipsPartName(part.getPartName().getName().substring(1));
        if (zf.getEntry(relPart) == null) {
            log.info((Object)("No relationships " + relPart));
            return null;
        }
        log.info((Object)("Found relationships " + relPart));
        log.info((Object)"Recursing ... ");
        rrp = this.getRelationshipsPartFromZip(part, zf, relPart);
        part.setRelationships(rrp);
        return rrp;
    }

    public static Part getRawPart(ZipFile zf, ContentTypeManager ctm, String resolvedPartUri, Relationship rel) throws Docx4JException {
        Part part;
        block35: {
            part = null;
            InputStream is = null;
            try {
                try {
                    log.debug((Object)("resolved uri: " + resolvedPartUri));
                    is = LoadFromZipFile.getInputStreamFromZippedPart(zf, resolvedPartUri);
                    part = ctm.getPart("/" + resolvedPartUri, rel);
                    if (part instanceof ThemePart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jcThemePart);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block35;
                    }
                    if (part instanceof DocPropsCorePart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jcDocPropsCore);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block35;
                    }
                    if (part instanceof DocPropsCustomPart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jcDocPropsCustom);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block35;
                    }
                    if (part instanceof DocPropsExtendedPart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jcDocPropsExtended);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block35;
                    }
                    if (part instanceof CustomXmlDataStoragePropertiesPart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jcCustomXmlProperties);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block35;
                    }
                    if (part instanceof XmlSignaturePart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jcXmlDSig);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block35;
                    }
                    if (part instanceof JaxbXmlPart) {
                        ((JaxbXmlPart)part).setJAXBContext(Context.jc);
                        ((JaxbXmlPart)part).unmarshal(is);
                        break block35;
                    }
                    if (part instanceof BinaryPart) {
                        log.debug((Object)("Detected BinaryPart " + part.getClass().getName()));
                        if (conserveMemory) {
                            ((BinaryPart)part).setBinaryDataRef(zf.getName(), resolvedPartUri);
                        } else {
                            ((BinaryPart)part).setBinaryData(is);
                        }
                        break block35;
                    }
                    if (part instanceof CustomXmlDataStoragePart) {
                        try {
                            Unmarshaller u = Context.jc.createUnmarshaller();
                            Object o = u.unmarshal(is);
                            log.debug((Object)o.getClass().getName());
                            PartName name = part.getPartName();
                            if (o instanceof Conditions) {
                                part = new ConditionsPart(name);
                                ((ConditionsPart)part).setJaxbElement((Conditions)o);
                                break block35;
                            }
                            if (o instanceof Xpaths) {
                                part = new XPathsPart(name);
                                ((XPathsPart)part).setJaxbElement((Xpaths)o);
                                break block35;
                            }
                            if (o instanceof Questionnaire) {
                                part = new QuestionsPart(name);
                                ((QuestionsPart)part).setJaxbElement((Questionnaire)o);
                                break block35;
                            }
                            if (o instanceof Components) {
                                part = new ComponentsPart(name);
                                ((ComponentsPart)part).setJaxbElement((Components)o);
                                break block35;
                            }
                            if (o instanceof JAXBElement && XmlUtils.unwrap(o) instanceof CTSources) {
                                part = new BibliographyPart(name);
                                ((BibliographyPart)part).setJaxbElement((JAXBElement)o);
                                break block35;
                            }
                            log.warn((Object)("No known part after all for CustomXmlPart " + o.getClass().getName()));
                            CustomXmlDataStorage data = LoadFromZipFile.getCustomXmlDataStorageClass().factory();
                            is.reset();
                            data.setDocument(is);
                            ((CustomXmlDataStoragePart)part).setData(data);
                        }
                        catch (UnmarshalException ue) {
                            CustomXmlDataStorage data = LoadFromZipFile.getCustomXmlDataStorageClass().factory();
                            is.reset();
                            data.setDocument(is);
                            ((CustomXmlDataStoragePart)part).setData(data);
                        }
                        break block35;
                    }
                    if (part instanceof XmlPart) {
                        try {
                            ((XmlPart)part).setDocument(is);
                        }
                        catch (Docx4JException d) {
                            part = LoadFromZipFile.getBinaryPart(zf, ctm, resolvedPartUri);
                            if (conserveMemory) {
                                ((BinaryPart)part).setBinaryDataRef(zf.getName(), resolvedPartUri);
                                break block35;
                            }
                            ((BinaryPart)part).setBinaryData(is);
                        }
                        break block35;
                    }
                    log.error((Object)("No suitable part found for: " + resolvedPartUri));
                    part = null;
                }
                catch (PartUnrecognisedException e) {
                    log.warn((Object)"PartUnrecognisedException shouldn't happen anymore!");
                    part = LoadFromZipFile.getBinaryPart(zf, ctm, resolvedPartUri);
                    if (conserveMemory) {
                        ((BinaryPart)part).setBinaryDataRef(zf.getName(), resolvedPartUri);
                        break block35;
                    }
                    ((BinaryPart)part).setBinaryData(is);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new Docx4JException("Failed to getPart", ex);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException exc) {
                        exc.printStackTrace();
                    }
                }
            }
        }
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Part getBinaryPart(ZipFile zf, ContentTypeManager ctm, String resolvedPartUri) throws Docx4JException {
        BinaryPart part = null;
        InputStream in = null;
        try {
            in = zf.getInputStream(zf.getEntry(resolvedPartUri));
            part = new BinaryPart(new PartName("/" + resolvedPartUri));
            if (conserveMemory) {
                part.setBinaryDataRef(zf.getName(), resolvedPartUri);
            } else {
                part.setBinaryData(in);
            }
            log.info((Object)"Stored as BinaryData");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                }
            }
        }
        return part;
    }
}

