/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.styles;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.docx4j.model.styles.Node;
import org.docx4j.model.styles.Tree;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleTree {
    private static Logger log = Logger.getLogger(StyleTree.class);
    private Tree<AugmentedStyle> tableTree = new Tree();
    private Tree<AugmentedStyle> pTree = new Tree();
    private Tree<AugmentedStyle> cTree = new Tree();

    public Tree<AugmentedStyle> getTableStylesTree() {
        return this.tableTree;
    }

    public Tree<AugmentedStyle> getParagraphStylesTree() {
        return this.pTree;
    }

    public Tree<AugmentedStyle> getCharacterStylesTree() {
        return this.cTree;
    }

    public StyleTree(List<String> stylesInUse, Map<String, Style> allStyles, String defaultParagraphStyleId, String defaultCharacterStyleId) {
        Style style;
        for (String styleId : stylesInUse) {
            if (this.tableTree.get(styleId) != null) continue;
            style = allStyles.get(styleId);
            if (style == null) {
                log.warn((Object)("Couldn't find style: " + styleId));
                continue;
            }
            if (!style.getType().equals("table")) continue;
            this.addNode(styleId, allStyles, this.tableTree);
        }
        stylesInUse.add(defaultParagraphStyleId);
        for (String styleId : stylesInUse) {
            if (this.pTree.get(styleId) != null) continue;
            style = allStyles.get(styleId);
            if (style == null) {
                log.warn((Object)("Couldn't find style: " + styleId));
                continue;
            }
            if (!style.getType().equals("paragraph")) continue;
            log.debug((Object)("Adding '" + styleId + "' to paragraph tree"));
            this.addNode(styleId, allStyles, this.pTree);
        }
        stylesInUse.add(defaultCharacterStyleId);
        for (String styleId : stylesInUse) {
            if (this.cTree.get(styleId) != null) continue;
            style = allStyles.get(styleId);
            if (style == null) {
                log.warn((Object)("Couldn't find style: " + styleId));
                continue;
            }
            if (!style.getType().equals("character")) continue;
            this.addNode(styleId, allStyles, this.cTree);
        }
    }

    private Node<AugmentedStyle> addNode(String styleId, Map<String, Style> allStyles, Tree<AugmentedStyle> tree) {
        log.debug((Object)styleId);
        Style style = allStyles.get(styleId);
        if (style == null) {
            log.error((Object)("Couldn't find style: " + styleId));
            return null;
        }
        AugmentedStyle as = new AugmentedStyle(style);
        Node<AugmentedStyle> n = new Node<AugmentedStyle>(tree, styleId, as);
        if (style.getBasedOn() == null) {
            log.debug((Object)("Style " + styleId + " is a root style."));
            if (tree.getRootElement() == null) {
                tree.setRootElement(n);
            } else {
                String root = tree.getRootElement().getData().getStyle().getStyleId();
                log.debug((Object)("Existing root:" + root));
                if (!styleId.equals(root)) {
                    log.warn((Object)("overwriting root node: " + styleId));
                    tree.setRootElement(n);
                }
            }
        } else if (style.getBasedOn().getVal() != null) {
            String basedOnStyleName = style.getBasedOn().getVal();
            log.debug((Object)("..based on " + basedOnStyleName));
            if (tree.get(basedOnStyleName) == null) {
                Node<AugmentedStyle> parent = this.addNode(basedOnStyleName, allStyles, tree);
                parent.addChild(n);
            } else {
                tree.get(basedOnStyleName).addChild(n);
            }
        } else {
            log.error((Object)("No basedOn set for: " + style.getStyleId()));
        }
        return n;
    }

    public static void main(String[] args) throws Exception {
        List<Node<AugmentedStyle>> classVals;
        Node n;
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/StyleResolution.xml";
        WordprocessingMLPackage wmlPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        ArrayList<String> stylesInUse = new ArrayList<String>();
        Map<String, String> stylesInUseMap = wmlPackage.getMainDocumentPart().getStylesInUse();
        for (Map.Entry<String, String> pairs : stylesInUseMap.entrySet()) {
            String styleId = pairs.getKey();
            stylesInUse.add(styleId);
        }
        HashMap<String, Style> allStyles = new HashMap<String, Style>();
        Styles styles = (Styles)wmlPackage.getMainDocumentPart().getStyleDefinitionsPart().getJaxbElement();
        for (Style s : styles.getStyle()) {
            allStyles.put(s.getStyleId(), s);
            log.debug((Object)("live style: " + s.getStyleId()));
        }
        StyleTree st = new StyleTree(stylesInUse, allStyles, wmlPackage.getMainDocumentPart().getStyleDefinitionsPart().getDefaultParagraphStyle().getStyleId(), wmlPackage.getMainDocumentPart().getStyleDefinitionsPart().getDefaultCharacterStyle().getStyleId());
        log.debug((Object)"\nParagraph styles\n");
        log.debug((Object)st.pTree.toString());
        log.debug((Object)"\nCharacter styles\n");
        log.debug((Object)st.cTree.toString());
        log.debug((Object)"\nParagraph classes\n");
        for (Map.Entry<String, Object> pairs : st.pTree.nodes.entrySet()) {
            n = (Node)pairs.getValue();
            classVals = st.pTree.climb(n);
            log.debug((Object)(n.name + ":'" + StyleTree.getHtmlClassAttributeValue(st.pTree, n) + "'"));
        }
        log.debug((Object)"\nRun classes\n");
        for (Map.Entry<String, Object> pairs : st.cTree.nodes.entrySet()) {
            n = (Node)pairs.getValue();
            classVals = st.cTree.climb(n);
            log.debug((Object)(n.name + ":'" + StyleTree.getHtmlClassAttributeValue(st.cTree, n) + "'"));
        }
    }

    public static String getHtmlClassAttributeValue(Tree<AugmentedStyle> tree, Node<AugmentedStyle> n) {
        if (n == null) {
            log.error((Object)"Null node passed");
            return null;
        }
        List<Node<AugmentedStyle>> classVals = tree.climb(n);
        StringBuffer sb = new StringBuffer();
        for (Node<AugmentedStyle> valNode : classVals) {
            sb.append(valNode.name + " ");
        }
        return sb.toString();
    }

    public class AugmentedStyle {
        private Style s;

        public AugmentedStyle(Style s) {
            this.s = s;
        }

        public Style getStyle() {
            return this.s;
        }
    }
}

