/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.listnumbering;

import org.apache.log4j.Logger;
import org.docx4j.model.PropertyResolver;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.Style;

public class Emulator {
    protected static Logger log = Logger.getLogger(Emulator.class);

    public static ResultTriple getNumber(WordprocessingMLPackage wmlPackage, String pStyleVal, String numId, String levelId) {
        NumberingDefinitionsPart numberingPart = wmlPackage.getMainDocumentPart().getNumberingDefinitionsPart();
        if (numberingPart == null) {
            return null;
        }
        Emulator em = numberingPart.getEmulator();
        ResultTriple triple = em.new ResultTriple();
        StyleDefinitionsPart stylesPart = wmlPackage.getMainDocumentPart().getStyleDefinitionsPart();
        PropertyResolver propertyResolver = wmlPackage.getMainDocumentPart().getPropertyResolver();
        if (numId == null || numId.equals("")) {
            Style style = null;
            if (pStyleVal == null || pStyleVal.equals("")) {
                log.debug((Object)"no explicit numId; no style either");
                return null;
            }
            log.debug((Object)"no explicit numId; looking in styles");
            style = propertyResolver.getStyle(pStyleVal);
            if (style == null) {
                log.debug((Object)("Couldn't find style '" + pStyleVal + "'"));
                return null;
            }
            if (style.getPPr() == null) {
                log.debug((Object)("Style '" + pStyleVal + "' has no pPr"));
                return null;
            }
            PPrBase.NumPr numPr = style.getPPr().getNumPr();
            if (numPr == null) {
                log.debug((Object)("Couldn't get NumPr from " + pStyleVal));
                return null;
            }
            if (numPr.getNumId() == null) {
                log.debug((Object)"NumPr element has no numId");
                if (pStyleVal != null) {
                    log.debug((Object)(pStyleVal + ".. use propertyResolver to follow basedOn"));
                    propertyResolver.getEffectivePPr(pStyleVal);
                }
                if (numPr.getNumId() == null) {
                    log.debug((Object)(pStyleVal + "NumPr element still has no numId (basedOn didn't help)"));
                    return null;
                }
                log.info((Object)("Got numId: " + numPr.getNumId()));
            }
            if ((numId = numPr.getNumId().getVal().toString()) == null || numId.equals("")) {
                log.error((Object)"numId was null or empty!");
                return null;
            }
            if (levelId == null || levelId.equals("")) {
                if (numPr.getIlvl() != null) {
                    levelId = numPr.getIlvl().getVal().toString();
                    log.info((Object)("levelId=" + numId + " (from style)"));
                } else {
                    levelId = "0";
                }
            }
        }
        log.debug((Object)("Using numId: " + numId));
        if (levelId == null || levelId.equals("")) {
            log.warn((Object)"No level id?! Default to 0.");
            levelId = "0";
        }
        if (numberingPart.getInstanceListDefinitions().containsKey(numId) && numberingPart.getInstanceListDefinitions().get(numId).LevelExists(levelId)) {
            PPr ppr;
            numberingPart.getInstanceListDefinitions().get(numId).IncrementCounter(levelId);
            triple.numString = numberingPart.getInstanceListDefinitions().get(numId).GetCurrentNumberString(levelId);
            log.debug((Object)("Got number: " + triple.numString));
            String font = numberingPart.getInstanceListDefinitions().get(numId).GetFont(levelId);
            if (font != null && !font.equals("")) {
                triple.numFont = font;
            }
            if (numberingPart.getInstanceListDefinitions().get(numId).IsBullet(levelId)) {
                triple.bullet = numberingPart.getInstanceListDefinitions().get(numId).getLevel(levelId).getLevelText();
            }
            if ((ppr = numberingPart.getInstanceListDefinitions().get(numId).getLevel(levelId).getJaxbAbstractLvl().getPPr()) != null) {
                triple.ind = ppr.getInd();
            }
        } else if (!numberingPart.getInstanceListDefinitions().containsKey(numId)) {
            log.error((Object)("Couldn't find list " + numId));
        } else if (!numberingPart.getInstanceListDefinitions().get(numId).LevelExists(levelId)) {
            log.error((Object)("Couldn't find level " + levelId + " in list " + numId));
        }
        return triple;
    }

    public class ResultTriple {
        String numString;
        String numFont;
        String bullet = null;
        PPrBase.Ind ind = null;

        public String getNumString() {
            return this.numString;
        }

        public String getNumFont() {
            return this.numFont;
        }

        public String getBullet() {
            return this.bullet;
        }

        public PPrBase.Ind getIndent() {
            return this.ind;
        }
    }
}

