/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.images;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.docx4j.model.images.AbstractConversionImageHandler;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;

public class FileConversionImageHandler
extends AbstractConversionImageHandler {
    public FileConversionImageHandler(String imageDirPath, boolean includeUUID) {
        super(imageDirPath, includeUUID);
    }

    protected String createStoredImage(BinaryPart binaryPart, byte[] bytes) throws Docx4JException {
        String uri = null;
        File folder = this.setupRootFolder(binaryPart);
        String filename = this.setupImageName(binaryPart);
        log.debug((Object)("image file name: " + filename));
        uri = this.storeImage(binaryPart, bytes, folder, filename);
        return uri;
    }

    protected String storeImage(BinaryPart binaryPart, byte[] bytes, File folder, String filename) throws Docx4JException {
        String uri = null;
        File imageFile = new File(folder, filename);
        FileOutputStream out = null;
        if (imageFile.exists()) {
            log.warn((Object)"Overwriting (!) existing file!");
        }
        try {
            out = new FileOutputStream(imageFile);
            out.write(bytes);
            uri = this.setupImageUri(imageFile);
            log.info((Object)("Wrote @src='" + uri));
        }
        catch (IOException ioe) {
            throw new Docx4JException("Exception storing '" + filename + "', " + ioe.toString(), ioe);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return uri;
    }

    protected File setupRootFolder(BinaryPart binaryPart) throws Docx4JException {
        File folder = new File(this.imageDirPath);
        if (folder.exists() && !folder.isDirectory()) {
            throw new Docx4JException("Invalid imageDirPath '" + this.imageDirPath + ", it isn't a directory");
        }
        if (!folder.exists() && !folder.mkdirs()) {
            throw new Docx4JException("Invalid imageDirPath '" + this.imageDirPath + ", could not create the directory");
        }
        return folder;
    }

    protected String setupImageUri(File imageFile) {
        return imageFile.getName();
    }
}

