/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.fields.merge;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.docx4j.Docx4jProperties;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.fields.FieldLocator;
import org.docx4j.model.fields.FieldRef;
import org.docx4j.model.fields.FieldsPreprocessor;
import org.docx4j.model.fields.merge.DataFieldName;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.model.structure.PageSizePaper;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.JaxbXmlPartXPathAware;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.relationships.Relationships;
import org.docx4j.wml.Body;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTPageNumber;
import org.docx4j.wml.CTRel;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Document;
import org.docx4j.wml.P;
import org.docx4j.wml.SectPr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailMerger {
    private static Logger log = Logger.getLogger(MailMerger.class);

    public static WordprocessingMLPackage getConsolidatedResultCrude(WordprocessingMLPackage input, List<Map<DataFieldName, String>> data) throws Docx4JException {
        return MailMerger.getConsolidatedResultCrude(input, data, false);
    }

    public static WordprocessingMLPackage getConsolidatedResultCrude(WordprocessingMLPackage input, List<Map<DataFieldName, String>> data, boolean processHeadersAndFooters) throws Docx4JException {
        FieldsPreprocessor.complexifyFields(input.getMainDocumentPart());
        System.out.println("complexified: " + XmlUtils.marshaltoString(input.getMainDocumentPart().getJaxbElement(), true));
        List<List<Object>> results = MailMerger.performOverList(input.getMainDocumentPart().getContent(), data);
        HashMap<CTRel, JaxbXmlPart> hfTemplates = null;
        BooleanDefaultTrue titlePage = null;
        if (processHeadersAndFooters) {
            hfTemplates = new HashMap<CTRel, JaxbXmlPart>();
            SectionWrapper sw = input.getDocumentModel().getSections().get(0);
            SectPr sectPr = sw.getSectPr();
            List<CTRel> hdrFtrRefs = sectPr.getEGHdrFtrReferences();
            titlePage = sectPr.getTitlePg();
            for (CTRel rel : hdrFtrRefs) {
                String relId = rel.getId();
                log.debug((Object)("for h|f relId: " + relId));
                JaxbXmlPart part = (JaxbXmlPart)input.getMainDocumentPart().getRelationshipsPart().getPart(relId);
                FieldsPreprocessor.complexifyFields(part);
                System.out.println("complexified: " + XmlUtils.marshaltoString(part.getJaxbElement(), true));
                hfTemplates.put(rel, part);
            }
        }
        Object result = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SaveToZipFile saver = new SaveToZipFile(input);
        saver.save(baos);
        byte[] template = baos.toByteArray();
        WordprocessingMLPackage target = WordprocessingMLPackage.load(new ByteArrayInputStream(template));
        SectPr documentSeparator = MailMerger.getDocumentSeparator(target);
        if (processHeadersAndFooters) {
            if (titlePage != null && titlePage.isVal()) {
                documentSeparator.setTitlePg(titlePage);
            }
            documentSeparator.getEGHdrFtrReferences().clear();
        }
        target.getMainDocumentPart().getContent().clear();
        int i = 0;
        for (List<Object> content : results) {
            target.getMainDocumentPart().getContent().addAll(content);
            Object last = content.get(content.size() - 1);
            P lastP = null;
            if (last instanceof P) {
                lastP = (P)last;
            } else {
                lastP = Context.getWmlObjectFactory().createP();
                target.getMainDocumentPart().getContent().add(lastP);
            }
            if (lastP.getPPr() == null) {
                lastP.setPPr(Context.getWmlObjectFactory().createPPr());
            }
            SectPr thisSection = XmlUtils.deepCopy(documentSeparator);
            lastP.getPPr().setSectPr(thisSection);
            if (processHeadersAndFooters) {
                for (CTRel ctRel : hfTemplates.keySet()) {
                    JaxbXmlPart part = (JaxbXmlPart)hfTemplates.get(ctRel);
                    JaxbXmlPartXPathAware clonedPart = null;
                    if (part instanceof HeaderPart) {
                        clonedPart = new HeaderPart();
                        clonedPart.setJaxbElement(Context.getWmlObjectFactory().createHdr());
                    } else if (part instanceof FooterPart) {
                        clonedPart = new FooterPart();
                        clonedPart.setJaxbElement(Context.getWmlObjectFactory().createFtr());
                    }
                    List<Object> newContent = MailMerger.performOnInstance(((ContentAccessor)((Object)part)).getContent(), data.get(i));
                    ((ContentAccessor)((Object)clonedPart)).getContent().addAll(newContent);
                    Relationship rel = target.getMainDocumentPart().addTargetPart((Part)clonedPart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
                    CTRel newHfRef = XmlUtils.deepCopy(ctRel);
                    newHfRef.setId(rel.getId());
                    thisSection.getEGHdrFtrReferences().add(newHfRef);
                }
            }
            ++i;
        }
        return target;
    }

    private static SectPr getDocumentSeparator(WordprocessingMLPackage template) {
        CTPageNumber pageNumber;
        List<Object> all;
        Object last;
        SectPr sectPr = ((Document)template.getMainDocumentPart().getJaxbElement()).getBody().getSectPr();
        if (sectPr == null && (last = (all = template.getMainDocumentPart().getContent()).get(all.size() - 1)) instanceof P && ((P)last).getPPr() != null && ((P)last).getPPr().getSectPr() != null) {
            sectPr = ((P)last).getPPr().getSectPr();
        }
        if (sectPr == null) {
            String papersize = Docx4jProperties.getProperties().getProperty("docx4j.PageSize", "A4");
            log.info((Object)("Using paper size: " + papersize));
            String landscapeString = Docx4jProperties.getProperties().getProperty("docx4j.PageOrientationLandscape", "false");
            boolean landscape = Boolean.parseBoolean(landscapeString);
            log.info((Object)("Landscape orientation: " + landscape));
            PageDimensions page = new PageDimensions();
            page.setPgSize(PageSizePaper.valueOf(papersize), landscape);
            sectPr = Context.getWmlObjectFactory().createSectPr();
            sectPr.setPgSz(page.getPgSz());
            sectPr.setPgMar(page.getPgMar());
        }
        if ((pageNumber = sectPr.getPgNumType()) == null) {
            pageNumber = Context.getWmlObjectFactory().createCTPageNumber();
            sectPr.setPgNumType(pageNumber);
        }
        pageNumber.setStart(BigInteger.ONE);
        return sectPr;
    }

    public static void performMerge(WordprocessingMLPackage input, Map<DataFieldName, String> data, boolean processHeadersAndFooters) throws Docx4JException {
        FieldsPreprocessor.complexifyFields(input.getMainDocumentPart());
        List<Object> mdpResults = MailMerger.performOnInstance(input.getMainDocumentPart().getContent(), data);
        input.getMainDocumentPart().getContent().clear();
        input.getMainDocumentPart().getContent().addAll(mdpResults);
        if (processHeadersAndFooters) {
            RelationshipsPart rp = input.getMainDocumentPart().getRelationshipsPart();
            for (Relationship r : ((Relationships)rp.getJaxbElement()).getRelationship()) {
                if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header") && !r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
                JaxbXmlPart part = (JaxbXmlPart)rp.getPart(r);
                FieldsPreprocessor.complexifyFields(part);
                List<Object> results = MailMerger.performOnInstance(((ContentAccessor)((Object)part)).getContent(), data);
                ((ContentAccessor)((Object)part)).getContent().clear();
                ((ContentAccessor)((Object)part)).getContent().addAll(results);
                System.out.println(XmlUtils.marshaltoString(part.getJaxbElement(), true));
            }
        }
    }

    private static List<List<Object>> performOverList(List<Object> contentList, List<Map<DataFieldName, String>> data) throws Docx4JException {
        ArrayList<List<Object>> results = new ArrayList<List<Object>>();
        for (Map<DataFieldName, String> datamap : data) {
            results.add(MailMerger.performOnInstance(contentList, datamap));
        }
        return results;
    }

    private static List<Object> performOnInstance(List<Object> contentList, Map<DataFieldName, String> datamap) throws Docx4JException {
        Body shell = Context.getWmlObjectFactory().createBody();
        shell.getContent().addAll(contentList);
        Body shellClone = XmlUtils.deepCopy(shell);
        FieldLocator fl = new FieldLocator();
        new TraversalUtil(shellClone, fl);
        log.info((Object)("Found " + fl.getStarts().size() + " fields "));
        ArrayList<FieldRef> fieldRefs = new ArrayList<FieldRef>();
        for (P p : fl.getStarts()) {
            int index = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
            P newP = FieldsPreprocessor.canonicalise(p, fieldRefs);
            System.out.println("NewP length: " + newP.getContent().size());
            ((ContentAccessor)p.getParent()).getContent().set(index, newP);
        }
        for (FieldRef fr : fieldRefs) {
            String instr = fr.getInstr();
            if (!MailMerger.isMergeField(instr)) continue;
            String tmp = instr.substring(instr.indexOf("MERGEFIELD") + 10);
            String key = (tmp = tmp.trim()).indexOf(" ") > -1 ? tmp.substring(0, tmp.indexOf(" ")) : tmp;
            log.info((Object)("Key: '" + key + "'"));
            String val = datamap.get(new DataFieldName(key));
            if (val == null) {
                log.warn((Object)("Couldn't find value for key: '" + key + "'"));
            } else {
                fr.setResult(val);
            }
            fr.getParent().getContent().remove(fr.getBeginRun());
            fr.getParent().getContent().remove(fr.getEndRun());
        }
        return shellClone.getContent();
    }

    public static boolean isMergeField(String type) {
        return type.contains("MERGEFIELD");
    }
}

