/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.fields;

import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.JAXBResult;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.model.fields.FieldRef;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STFldCharType;
import org.docx4j.wml.Text;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldsPreprocessor {
    private static Logger log = Logger.getLogger(FieldsPreprocessor.class);
    private static final QName _RInstrText_QNAME = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "instrText");
    static Templates xslt;
    private static XPathFactory xPathFactory;
    private static XPath xPath;

    public static void complexifyFields(JaxbXmlPart part) throws Docx4JException {
        Document doc = XmlUtils.marshaltoW3CDomDocument(part.getJaxbElement());
        Object xPathsPart = null;
        JAXBContext jc = Context.jc;
        try {
            Unmarshaller u = jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            JAXBResult result = new JAXBResult(u);
            XmlUtils.transform(doc, xslt, null, (Result)result);
            part.setJaxbElement(result);
        }
        catch (Exception e) {
            throw new Docx4JException("Problems transforming fields", e);
        }
    }

    public static P canonicalise(P p, List<FieldRef> fieldRefs) {
        P newP = Context.getWmlObjectFactory().createP();
        int depth = 0;
        R newR = Context.getWmlObjectFactory().createR();
        RPr fieldRPr = null;
        FieldRef currentField = null;
        boolean seenSeparate = false;
        for (Object o : p.getContent()) {
            if (o instanceof R) {
                R existingRun = (R)o;
                for (Object o2 : existingRun.getContent()) {
                    if (FieldsPreprocessor.isCharType(o2, STFldCharType.BEGIN)) {
                        seenSeparate = false;
                        if (++depth != 1) continue;
                        if (newR.getContent().size() > 0) {
                            newP.getContent().add(newR);
                            newR.setRPr(existingRun.getRPr());
                        }
                        newR = Context.getWmlObjectFactory().createR();
                        newR.getContent().add(o2);
                        currentField = new FieldRef();
                        fieldRefs.add(currentField);
                        currentField.setParent(newP);
                        currentField.setBeginRun(newR);
                        continue;
                    }
                    if (FieldsPreprocessor.isCharType(o2, STFldCharType.END)) {
                        if (!seenSeparate) {
                            R separateR = Context.getWmlObjectFactory().createR();
                            FldChar fldChar = Context.getWmlObjectFactory().createFldChar();
                            fldChar.setFldCharType(STFldCharType.SEPARATE);
                            newR.getContent().add(fldChar);
                            newP.getContent().add(separateR);
                            newR = Context.getWmlObjectFactory().createR();
                            currentField.setResultsSlot(newR);
                        }
                        if (--depth == 0) {
                            newP.getContent().add(newR);
                            newR = Context.getWmlObjectFactory().createR();
                            newR.getContent().add(o2);
                            newP.getContent().add(newR);
                            currentField.setEndRun(newR);
                            newR = Context.getWmlObjectFactory().createR();
                            continue;
                        }
                        newR.getContent().add(o2);
                        continue;
                    }
                    if (FieldsPreprocessor.isCharType(o2, STFldCharType.SEPARATE)) {
                        seenSeparate = true;
                        newR.getContent().add(o2);
                        if (depth != 1) continue;
                        newP.getContent().add(newR);
                        newR = Context.getWmlObjectFactory().createR();
                        newR.setRPr(fieldRPr);
                        currentField.setResultsSlot(newR);
                        continue;
                    }
                    if (o2 instanceof JAXBElement && ((JAXBElement)o2).getName().equals(_RInstrText_QNAME)) {
                        currentField.setInstrText((JAXBElement<Text>)((JAXBElement)o2));
                        newR.getContent().add(o2);
                        fieldRPr = existingRun.getRPr();
                        newR.setRPr(fieldRPr);
                        continue;
                    }
                    newR.getContent().add(o2);
                }
                continue;
            }
            if (newR.getContent().size() > 0) {
                newP.getContent().add(newR);
                newR = Context.getWmlObjectFactory().createR();
            }
            newP.getContent().add(o);
        }
        if (newR.getContent().size() > 0 && !newP.getContent().contains(newR)) {
            newP.getContent().add(newR);
        }
        return newP;
    }

    public static boolean isCharType(Object o2, STFldCharType charType) {
        FldChar fldChar;
        return (o2 = XmlUtils.unwrap(o2)) instanceof FldChar && (fldChar = (FldChar)o2).getFldCharType().equals((Object)charType);
    }

    static {
        try {
            StreamSource xsltSource = new StreamSource(ResourceUtils.getResource("org/docx4j/model/fields/FieldsSimpleToComplex.xslt"));
            xslt = XmlUtils.getTransformerTemplate(xsltSource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        xPathFactory = XPathFactory.newInstance();
        xPath = xPathFactory.newXPath();
    }
}

