/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import java.io.File;
import java.util.List;
import javax.xml.bind.Binder;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.BindingHandler;
import org.docx4j.model.datastorage.OpenDoPEHandler;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Document;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Node;

public class EndToEndTest {
    @Test
    public void testInvoice() throws Exception {
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/databinding/invoice.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        OpenDoPEHandler odh = new OpenDoPEHandler(wordMLPackage);
        odh.preprocess();
        org.w3c.dom.Document xmlNode = XmlUtils.marshaltoW3CDomDocument(wordMLPackage.getMainDocumentPart().getJaxbElement());
        Binder binder = Context.jc.createBinder();
        Document jaxbElement = (Document)binder.unmarshal((Object)xmlNode);
        List<Object> list = XmlUtils.getJAXBNodesViaXPath((Binder<Node>)binder, jaxbElement, "//w:tr", false);
        int count = list.size();
        Assert.assertTrue((String)("expected 4 rows but got " + count), (count == 4 ? 1 : 0) != 0);
        list = XmlUtils.getJAXBNodesViaXPath((Binder<Node>)binder, jaxbElement, "//w:r[w:t[contains(text(),'Bank')]]", false);
        count = list.size();
        Assert.assertTrue((String)("expected 1 run but got " + count), (count == 1 ? 1 : 0) != 0);
        list = XmlUtils.getJAXBNodesViaXPath((Binder<Node>)binder, jaxbElement, "//w:r[w:t[contains(text(),'left out')]]", false);
        count = list.size();
        Assert.assertTrue((String)("expected 0 runs but got " + count), (count == 0 ? 1 : 0) != 0);
        BindingHandler.applyBindings(wordMLPackage.getMainDocumentPart());
        xmlNode = XmlUtils.marshaltoW3CDomDocument(wordMLPackage.getMainDocumentPart().getJaxbElement());
        binder = Context.jc.createBinder();
        jaxbElement = (Document)binder.unmarshal((Object)xmlNode);
        list = XmlUtils.getJAXBNodesViaXPath((Binder<Node>)binder, jaxbElement, "//w:r[w:t[contains(text(),'cherries')]]", false);
        count = list.size();
        Assert.assertTrue((String)("expected 1 runs but got " + count), (count == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testNestedRepeats() throws Exception {
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/databinding/CountryRegions.xml";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        OpenDoPEHandler odh = new OpenDoPEHandler(wordMLPackage);
        odh.preprocess();
        org.w3c.dom.Document xmlNode = XmlUtils.marshaltoW3CDomDocument(wordMLPackage.getMainDocumentPart().getJaxbElement());
        Binder binder = Context.jc.createBinder();
        Document jaxbElement = (Document)binder.unmarshal((Object)xmlNode);
        List<Object> list = XmlUtils.getJAXBNodesViaXPath((Binder<Node>)binder, jaxbElement, "//w:tbl", false);
        int count = list.size();
        Assert.assertTrue((String)("expected 3 tables but got " + count), (count == 3 ? 1 : 0) != 0);
        list = XmlUtils.getJAXBNodesViaXPath((Binder<Node>)binder, jaxbElement, "/descendant::w:tbl[1]/*[local-name()='sdt' or local-name()='tr']", false);
        count = list.size();
        Assert.assertTrue((String)("expected 2 rows but got " + count), (count == 2 ? 1 : 0) != 0);
        list = XmlUtils.getJAXBNodesViaXPath((Binder<Node>)binder, jaxbElement, "/descendant::w:tbl[2]/*[local-name()='sdt' or local-name()='tr']", false);
        count = list.size();
        Assert.assertTrue((String)("expected 3 rows but got " + count), (count == 3 ? 1 : 0) != 0);
        list = XmlUtils.getJAXBNodesViaXPath((Binder<Node>)binder, jaxbElement, "/descendant::w:tbl[3]/*[local-name()='sdt' or local-name()='tr']", false);
        count = list.size();
        Assert.assertTrue((String)("expected 4 rows but got " + count), (count == 4 ? 1 : 0) != 0);
        BindingHandler.applyBindings(wordMLPackage.getMainDocumentPart());
        xmlNode = XmlUtils.marshaltoW3CDomDocument(wordMLPackage.getMainDocumentPart().getJaxbElement());
        binder = Context.jc.createBinder();
        jaxbElement = (Document)binder.unmarshal((Object)xmlNode);
        list = XmlUtils.getJAXBNodesViaXPath((Binder<Node>)binder, jaxbElement, "/descendant::w:tbl[3]/w:sdt[last()]/w:sdtContent/w:tr/w:tc[last()]", false);
        String content = XmlUtils.marshaltoString(list.get(0), true);
        Assert.assertTrue((String)("expected content to contain 'P c3 r3' but got " + content), (boolean)content.contains("P c3 r3"));
    }
}

