/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.docx4j.XmlUtils;
import org.docx4j.convert.in.xhtml.XHTMLImporter;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.BindingHandler;
import org.docx4j.model.datastorage.BindingTraverserInterface;
import org.docx4j.model.sdt.QueryString;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.CTSdtDate;
import org.docx4j.wml.Color;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Text;
import org.opendope.xpaths.Xpaths;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingTraverserXSLT
implements BindingTraverserInterface {
    private static Logger log = Logger.getLogger(BindingTraverserXSLT.class);
    static Templates xslt;

    @Override
    public Object traverseToBind(JaxbXmlPart part, OpcPackage pkg, XPathsPart xPathsPart) throws Docx4JException {
        Document doc = XmlUtils.marshaltoW3CDomDocument(part.getJaxbElement());
        try {
            DOMResult result = new DOMResult();
            HashMap<String, Object> transformParameters = new HashMap<String, Object>();
            transformParameters.put("customXmlDataStorageParts", part.getPackage().getCustomXmlDataStorageParts());
            transformParameters.put("wmlPackage", (WordprocessingMLPackage)pkg);
            transformParameters.put("sourcePart", part);
            transformParameters.put("xPathsPart", xPathsPart);
            XmlUtils.transform(doc, xslt, transformParameters, (Result)result);
            return XmlUtils.unmarshal((Document)result.getNode());
        }
        catch (Exception e) {
            throw new Docx4JException("Problems applying bindings", e);
        }
    }

    public static void log(String message) {
        log.info((Object)message);
    }

    public static void log(NodeIterator nodeIterator) {
        Node n = nodeIterator.nextNode();
        log.info((Object)XmlUtils.w3CDomNodeToString(n));
    }

    public static DocumentFragment convertXHTML(WordprocessingMLPackage pkg, JaxbXmlPart sourcePart, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, XPathsPart xPathsPart, String sdtParent, String contentChild, NodeIterator rPrNodeIt, String tag) {
        String prefixMappings;
        String xpathExp;
        log.debug((Object)("convertXHTML extension function for: " + sdtParent + "/w:sdt/w:sdtContent/" + contentChild));
        QueryString qs = new QueryString();
        HashMap<String, String> map = QueryString.parseQueryString(tag, true);
        String xpathId = map.get("od:xpath");
        log.info((Object)("Looking for xpath by id: " + xpathId));
        Xpaths.Xpath xpath = XPathsPart.getXPathById((Xpaths)xPathsPart.getJaxbElement(), xpathId);
        if (xpath == null) {
            log.warn((Object)("Couldn't find xpath with id: " + xpathId));
            return null;
        }
        String storeItemId = xpath.getDataBinding().getStoreItemID();
        String r = BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, storeItemId, xpathExp = xpath.getDataBinding().getXpath(), prefixMappings = xpath.getDataBinding().getPrefixMappings());
        if (r == null) {
            return null;
        }
        try {
            Document docContainer = XmlUtils.neww3cDomDocument();
            DocumentFragment docfrag = docContainer.createDocumentFragment();
            XHTMLImporter.setHyperlinkStyle(BindingHandler.getHyperlinkStyleId());
            String baseUrl = null;
            List<Object> results = null;
            try {
                results = XHTMLImporter.convert(r, baseUrl, pkg);
            }
            catch (Exception e) {
                if (e instanceof NullPointerException) {
                    ((NullPointerException)e).printStackTrace();
                }
                log.error((Object)e);
                log.error((Object)("with XHTML: " + r));
                String errMsg = e.getMessage() + " with XHTML from " + xpathExp + " : " + r;
                Element wr = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "r");
                Element wt = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "t");
                wt.setTextContent(errMsg);
                wr.appendChild(wt);
                if (sdtParent.equals("p")) {
                    docfrag.appendChild(wr);
                    return docfrag;
                }
                if (sdtParent.equals("tbl")) {
                    Element wtr = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tr");
                    docfrag.appendChild(wtr);
                    Element wtc = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tc");
                    wtr.appendChild(wtc);
                    Element wp = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "p");
                    wtc.appendChild(wp);
                    wp.appendChild(wr);
                    return docfrag;
                }
                if (sdtParent.equals("tr")) {
                    Element wtc = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tc");
                    docfrag.appendChild(wtc);
                    Element wp = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "p");
                    wtc.appendChild(wp);
                    wp.appendChild(wr);
                    return docfrag;
                }
                if (sdtParent.equals("tc")) {
                    Element wp = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "p");
                    docfrag.appendChild(wp);
                    wp.appendChild(wr);
                    return docfrag;
                }
                Element wp = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "p");
                docfrag.appendChild(wp);
                wp.appendChild(wr);
                return docfrag;
            }
            if (results == null) {
                log.error((Object)("Couldn't convert " + r));
                return docfrag;
            }
            log.info((Object)("Got results: " + results.size()));
            if (results.size() > 0 && results.get(0) instanceof P && sdtParent.equals("p")) {
                for (Object o : ((P)results.get(0)).getContent()) {
                    Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(o);
                    XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (Node)docfrag);
                }
            } else {
                for (Object o : results) {
                    String debug = XmlUtils.marshaltoString(o, true);
                    log.debug((Object)("Conversion result: " + debug));
                    Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(o);
                    XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (Node)docfrag);
                }
            }
            System.out.println("returning...");
            return docfrag;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public static DocumentFragment xpathGenerateRuns(WordprocessingMLPackage pkg, JaxbXmlPart sourcePart, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings, String sdtParent, String contentChild, NodeIterator rPrNodeIt, boolean multiLine, String tag) {
        String r = BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, storeItemId, xpath, prefixMappings);
        if (r == null) {
            return null;
        }
        Document docContainer = XmlUtils.neww3cDomDocument();
        DocumentFragment docfrag = docContainer.createDocumentFragment();
        try {
            log.info((Object)(xpath + " yielded result " + r));
            RPr rPr = null;
            Node rPrNode = rPrNodeIt.nextNode();
            if (rPrNode != null) {
                rPr = (RPr)XmlUtils.unmarshal(rPrNode);
            }
            ObjectFactory factory = new ObjectFactory();
            StringTokenizer st = new StringTokenizer(r, "\n\r\f");
            if (multiLine) {
                boolean firsttoken = true;
                while (st.hasMoreTokens()) {
                    String line = st.nextToken();
                    if (firsttoken) {
                        firsttoken = false;
                    } else {
                        BindingTraverserXSLT.addBrRunToDocFrag(docfrag, rPr);
                    }
                    BindingTraverserXSLT.processString(sourcePart, docfrag, line, rPr);
                }
            } else {
                StringBuilder sb = new StringBuilder();
                while (st.hasMoreTokens()) {
                    sb.append(st.nextToken());
                }
                BindingTraverserXSLT.processString(sourcePart, docfrag, sb.toString(), rPr);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
        return docfrag;
    }

    private static void addBrRunToDocFrag(DocumentFragment docfrag, RPr rPr) throws JAXBException {
        R run = Context.getWmlObjectFactory().createR();
        if (rPr != null) {
            run.setRPr(rPr);
        }
        run.getRunContent().add(Context.getWmlObjectFactory().createBr());
        Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(run);
        XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (Node)docfrag);
    }

    private static void processString(JaxbXmlPart sourcePart, DocumentFragment docfrag, String text, RPr rPr) throws JAXBException {
        int pos3;
        int pos2;
        int NOT_FOUND = 99999;
        int pos1 = text.indexOf("http://") == -1 ? NOT_FOUND : text.indexOf("http://");
        int pos = Math.min(pos1, Math.min(pos2 = text.indexOf("https://") == -1 ? NOT_FOUND : text.indexOf("https://"), pos3 = text.indexOf("mailto:") == -1 ? NOT_FOUND : text.indexOf("mailto:")));
        if (pos == NOT_FOUND || BindingHandler.getHyperlinkStyleId() == null) {
            BindingTraverserXSLT.addRunToDocFrag(sourcePart, docfrag, text, rPr);
            return;
        }
        if (pos == 0) {
            int spacePos = text.indexOf(" ");
            if (spacePos == -1) {
                BindingTraverserXSLT.addHyperlinkToDocFrag(sourcePart, docfrag, text);
                return;
            }
            String first = text.substring(0, spacePos);
            String rest = text.substring(spacePos);
            BindingTraverserXSLT.addHyperlinkToDocFrag(sourcePart, docfrag, first);
            BindingTraverserXSLT.processString(sourcePart, docfrag, rest, rPr);
            return;
        }
        String first = text.substring(0, pos);
        String rest = text.substring(pos);
        BindingTraverserXSLT.addRunToDocFrag(sourcePart, docfrag, first, rPr);
        BindingTraverserXSLT.processString(sourcePart, docfrag, rest, rPr);
    }

    private static void addRunToDocFrag(JaxbXmlPart sourcePart, DocumentFragment docfrag, String string, RPr rPr) {
        R run = Context.getWmlObjectFactory().createR();
        if (rPr != null) {
            run.setRPr(rPr);
        }
        Text text = Context.getWmlObjectFactory().createText();
        run.getRunContent().add(text);
        if (string.startsWith(" ") || string.endsWith(" ")) {
            text.setSpace("preserve");
        }
        text.setValue(string);
        Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(run);
        XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (Node)docfrag);
    }

    private static void addHyperlinkToDocFrag(JaxbXmlPart sourcePart, DocumentFragment docfrag, String url) throws JAXBException {
        org.docx4j.relationships.ObjectFactory factory = new org.docx4j.relationships.ObjectFactory();
        Relationship rel = factory.createRelationship();
        rel.setType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
        rel.setTarget(url);
        rel.setTargetMode("External");
        sourcePart.getRelationshipsPart().addRelationship(rel);
        String hpl = "<w:hyperlink r:id=\"" + rel.getId() + "\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" " + "xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" >" + "<w:r>" + "<w:rPr>" + "<w:rStyle w:val=\"" + BindingHandler.getHyperlinkStyleId() + "\" />" + "</w:rPr>" + "<w:t>" + url + "</w:t>" + "</w:r>" + "</w:hyperlink>";
        Document tmpDoc = XmlUtils.marshaltoW3CDomDocument((P.Hyperlink)XmlUtils.unmarshalString(hpl));
        XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (Node)docfrag);
    }

    public static DocumentFragment xpathInjectImage(WordprocessingMLPackage wmlPackage, JaxbXmlPart sourcePart, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings, String sdtParent, String contentChild, String cx, String cy) {
        log.debug((Object)("sdt's parent: " + sdtParent));
        CustomXmlDataStoragePart part = customXmlDataStorageParts.get(storeItemId.toLowerCase());
        if (part == null) {
            log.error((Object)("Couldn't locate part by storeItemId " + storeItemId));
            return null;
        }
        try {
            String xpResult = part.getData().xpathGetString(xpath, prefixMappings);
            log.debug((Object)(xpath + " yielded result " + xpResult));
            byte[] bytes = Base64.decodeBase64((byte[])xpResult.getBytes("UTF8"));
            BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((OpcPackage)wmlPackage, (Part)sourcePart, bytes);
            String filenameHint = null;
            String altText = null;
            int id1 = 0;
            int id2 = 1;
            Inline inline = null;
            long cxl = 0L;
            long cyl = 0L;
            try {
                cxl = Long.parseLong(cx);
                cyl = Long.parseLong(cy);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (cxl == 0L || cyl == 0L) {
                log.debug((Object)"image size - from image");
                inline = imagePart.createImageInline(filenameHint, altText, id1, id2, false);
            } else {
                log.debug((Object)"image size - from content control size");
                ImageSize size = imagePart.getImageInfo().getSize();
                double ratio = (double)size.getHeightPx() / (double)size.getWidthPx();
                log.debug((Object)("fit ratio: " + ratio));
                if (ratio > 1.0) {
                    cxl = (long)((double)cyl / ratio);
                } else {
                    cyl = (long)((double)cxl * ratio);
                }
                inline = imagePart.createImageInline(filenameHint, altText, id1, id2, cxl, cyl, false);
            }
            ObjectFactory factory = new ObjectFactory();
            Tc tc = factory.createTc();
            P p = factory.createP();
            if (sdtParent.equals("tr")) {
                tc.getContent().add(p);
            }
            R run = factory.createR();
            if (sdtParent.equals("body") || sdtParent.equals("tr") || sdtParent.equals("tc")) {
                p.getContent().add(run);
            }
            Drawing drawing = factory.createDrawing();
            run.getContent().add(drawing);
            drawing.getAnchorOrInline().add(inline);
            Document document = null;
            if (sdtParent.equals("body") || sdtParent.equals("tc")) {
                document = XmlUtils.marshaltoW3CDomDocument(p);
            } else if (sdtParent.equals("tr")) {
                document = XmlUtils.marshaltoW3CDomDocument(tc);
            } else if (sdtParent.equals("p")) {
                document = XmlUtils.marshaltoW3CDomDocument(run);
            } else if (sdtParent.equals("sdtContent")) {
                log.info((Object)("contentChild: " + contentChild));
                if (contentChild.equals("p")) {
                    p.getContent().add(run);
                    document = XmlUtils.marshaltoW3CDomDocument(p);
                } else if (contentChild.equals("r")) {
                    document = XmlUtils.marshaltoW3CDomDocument(run);
                } else {
                    log.error((Object)("how to inject image for unexpected sdt's content: " + contentChild));
                }
            } else {
                log.error((Object)("how to inject image for unexpected sdt's parent: " + sdtParent));
            }
            DocumentFragment docfrag = document.createDocumentFragment();
            docfrag.appendChild(document.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DocumentFragment xpathGenerateRuns(WordprocessingMLPackage pkg, JaxbXmlPart sourcePart, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, XPathsPart xPathsPart, String odTag, String sdtParent, String contentChild, NodeIterator rPrNodeIt, boolean multiLine) {
        QueryString qs = new QueryString();
        HashMap<String, String> map = QueryString.parseQueryString(odTag, true);
        String xpathId = map.get("od:xpath");
        log.info((Object)("Looking for xpath by id: " + xpathId));
        Xpaths.Xpath xpath = XPathsPart.getXPathById((Xpaths)xPathsPart.getJaxbElement(), xpathId);
        if (xpath == null) {
            log.warn((Object)("Couldn't find xpath with id: " + xpathId));
            return null;
        }
        String storeItemId = xpath.getDataBinding().getStoreItemID();
        String xpathExp = xpath.getDataBinding().getXpath();
        String prefixMappings = xpath.getDataBinding().getPrefixMappings();
        return BindingTraverserXSLT.xpathGenerateRuns(pkg, sourcePart, customXmlDataStorageParts, storeItemId, xpathExp, prefixMappings, sdtParent, contentChild, rPrNodeIt, multiLine, odTag);
    }

    public static String getRepeatPositionCondition(XPathsPart xPathsPart, String odTag) {
        QueryString qs = new QueryString();
        HashMap<String, String> map = QueryString.parseQueryString(odTag, true);
        String xpathId = map.get("od:RptPosCon");
        log.info((Object)("Looking for xpath by id: " + xpathId));
        Xpaths.Xpath xpath = XPathsPart.getXPathById((Xpaths)xPathsPart.getJaxbElement(), xpathId);
        String expression = xpath.getDataBinding().getXpath();
        log.info((Object)expression);
        return expression;
    }

    public static DocumentFragment nullResultParagraph(String sdtParent, String message) {
        try {
            ObjectFactory factory = new ObjectFactory();
            R run = factory.createR();
            Text text = factory.createText();
            text.setValue(message);
            run.getContent().add(text);
            Document docContainer = XmlUtils.neww3cDomDocument();
            if (sdtParent.equals("p")) {
                docContainer = XmlUtils.marshaltoW3CDomDocument(run);
            } else {
                P p = factory.createP();
                p.getContent().add(run);
                docContainer = XmlUtils.marshaltoW3CDomDocument(p);
            }
            DocumentFragment docfrag = docContainer.createDocumentFragment();
            docfrag.appendChild(docContainer.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public static DocumentFragment xpathDate(WordprocessingMLPackage wmlPackage, JaxbXmlPart sourcePart, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings, String sdtParent, String contentChild, NodeIterator dateNodeIt) {
        CustomXmlDataStoragePart part = customXmlDataStorageParts.get(storeItemId.toLowerCase());
        if (part == null) {
            log.error((Object)("Couldn't locate part by storeItemId " + storeItemId));
            return null;
        }
        try {
            Date date;
            String r = part.getData().xpathGetString(xpath, prefixMappings);
            log.debug((Object)(xpath + " yielded result " + r));
            if (r == null) {
                return BindingTraverserXSLT.nullResultParagraph(sdtParent, "[missing!]");
            }
            CTSdtDate sdtDate = null;
            Node dateNode = dateNodeIt.nextNode();
            if (dateNode != null) {
                sdtDate = (CTSdtDate)XmlUtils.unmarshal(dateNode, Context.jc, CTSdtDate.class);
            }
            if (r.indexOf("Z") > 0) {
                r = r.substring(0, r.indexOf("Z") - 1);
                log.warn((Object)("date now " + r));
            }
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            String format = sdtDate.getDateFormat().getVal();
            System.out.println("Using format: " + format);
            if (format.contains("dddd")) {
                format = format.replace("dddd", "EEEE");
            }
            SimpleDateFormat formatter = new SimpleDateFormat(format);
            ObjectFactory factory = new ObjectFactory();
            RPr rPr = null;
            try {
                date = dateTimeFormat.parse(r);
            }
            catch (ParseException e) {
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    date = dateFormat.parse(r);
                }
                catch (ParseException e2) {
                    log.warn((Object)e.getMessage());
                    date = new Date();
                    rPr = factory.createRPr();
                    Color colorRed = factory.createColor();
                    colorRed.setVal("FF0000");
                    rPr.setColor(colorRed);
                }
            }
            String result = formatter.format((Object)date);
            R run = factory.createR();
            if (rPr != null) {
                run.setRPr(rPr);
            }
            Text text = factory.createText();
            text.setValue(result);
            run.getContent().add(text);
            Document docContainer = XmlUtils.neww3cDomDocument();
            if (sdtParent.equals("p")) {
                docContainer = XmlUtils.marshaltoW3CDomDocument(run);
            } else {
                P p = factory.createP();
                p.getContent().add(run);
                docContainer = XmlUtils.marshaltoW3CDomDocument(p);
            }
            DocumentFragment docfrag = docContainer.createDocumentFragment();
            docfrag.appendChild(docContainer.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    static {
        try {
            StreamSource xsltSource = new StreamSource(ResourceUtils.getResource("org/docx4j/model/datastorage/bind.xslt"));
            xslt = XmlUtils.getTransformerTemplate(xsltSource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
    }
}

