/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.docx4j.model.datastorage.BindingTraverserXSLT;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.CTDataBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingHandler {
    private static Logger log = Logger.getLogger(BindingHandler.class);
    private static XPathFactory xPathFactory = XPathFactory.newInstance();
    private static XPath xPath = xPathFactory.newXPath();
    private static String hyperlinkStyleId = null;
    public static final String CORE_PROPERTIES_STOREITEMID = "{6C3C8BC8-F283-45AE-878A-BAB7291924A1}";
    public static final String EXTENDED_PROPERTIES_STOREITEMID = "{6668398D-A668-4E3E-A5EB-62B293D839F1}";
    public static final String COVERPAGE_PROPERTIES_STOREITEMID = "{55AF091B-3C7A-41E3-B477-F2FDAA23CFDA}";

    public static void setHyperlinkStyle(String hyperlinkStyleID) {
        hyperlinkStyleId = hyperlinkStyleID;
    }

    public static String getHyperlinkStyleId() {
        return hyperlinkStyleId;
    }

    public static void applyBindings(WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        if (hyperlinkStyleId != null) {
            wordMLPackage.getMainDocumentPart().getPropertyResolver().activateStyle(hyperlinkStyleId);
        }
        BindingHandler.applyBindings(wordMLPackage.getMainDocumentPart());
        RelationshipsPart rp = wordMLPackage.getMainDocumentPart().getRelationshipsPart();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header")) {
                BindingHandler.applyBindings((HeaderPart)rp.getPart(r));
                continue;
            }
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
            BindingHandler.applyBindings((FooterPart)rp.getPart(r));
        }
    }

    public static void applyBindings(JaxbXmlPart part) throws Docx4JException {
        OpcPackage pkg = part.getPackage();
        if (hyperlinkStyleId != null && pkg instanceof WordprocessingMLPackage) {
            ((WordprocessingMLPackage)pkg).getMainDocumentPart().getPropertyResolver().activateStyle(hyperlinkStyleId);
        }
        XPathsPart xPathsPart = null;
        if (((WordprocessingMLPackage)pkg).getMainDocumentPart().getXPathsPart() == null) {
            log.error((Object)"OpenDoPE XPaths part missing");
        } else {
            xPathsPart = ((WordprocessingMLPackage)pkg).getMainDocumentPart().getXPathsPart();
        }
        BindingTraverserXSLT traverser = new BindingTraverserXSLT();
        part.setJaxbElement(traverser.traverseToBind(part, pkg, xPathsPart));
    }

    public static String xpathGetString(WordprocessingMLPackage pkg, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, CTDataBinding db) {
        return BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, db.getStoreItemID(), db.getXpath(), db.getPrefixMappings());
    }

    public static String xpathGetString(WordprocessingMLPackage pkg, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings) {
        try {
            if (storeItemId.toUpperCase().equals(CORE_PROPERTIES_STOREITEMID)) {
                return pkg.getDocPropsCorePart().xpathGetString(xpath, prefixMappings);
            }
            if (storeItemId.toUpperCase().equals(EXTENDED_PROPERTIES_STOREITEMID)) {
                return pkg.getDocPropsExtendedPart().xpathGetString(xpath, prefixMappings);
            }
            CustomXmlDataStoragePart part = customXmlDataStorageParts.get(storeItemId.toLowerCase());
            if (part == null) {
                log.error((Object)("Couldn't locate part by storeItemId " + storeItemId));
                return null;
            }
            if (log.isDebugEnabled()) {
                String r = part.getData().xpathGetString(xpath, prefixMappings);
                log.debug((Object)(xpath + " yielded result " + r));
                return r;
            }
            return part.getData().xpathGetString(xpath, prefixMappings);
        }
        catch (Docx4JException e) {
            e.printStackTrace();
            return null;
        }
    }
}

