/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.listnumbering.ind;

import java.io.FileInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.docx4j.convert.in.FlatOpcXmlImporter;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.wml.PPrBase;
import org.docx4j.xmlPackage.Package;
import org.junit.Assert;
import org.junit.Test;

public class ListNumberIndTest {
    static final String BASE_DIR = "src/test/java/org/docx4j/listnumbering/ind/";
    static final String[] testdocs = new String[]{"abstract_style_with.xml", "abstract_style_without.xml", "abstract_nostyle_ppr.xml", "abstract_nostyle_noppr.xml", "override_nostyle_ppr.xml"};
    static final String[] expected = new String[]{"11", "12", "13", null, "23"};

    public static void main(String[] args) throws Exception {
    }

    @Test
    public void testGetInd() throws Exception {
        for (int i = 0; i < testdocs.length; ++i) {
            String filename = testdocs[i];
            System.out.println("Reading " + filename);
            try {
                JAXBContext jc = Context.jcXmlPackage;
                Unmarshaller u = jc.createUnmarshaller();
                u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
                Package wmlPackageEl = (Package)((JAXBElement)u.unmarshal((Source)new StreamSource(new FileInputStream(BASE_DIR + filename)))).getValue();
                FlatOpcXmlImporter xmlPackage = new FlatOpcXmlImporter(wmlPackageEl);
                WordprocessingMLPackage wmlPackage = (WordprocessingMLPackage)xmlPackage.get();
                NumberingDefinitionsPart ndp = wmlPackage.getMainDocumentPart().getNumberingDefinitionsPart();
                ndp.getEmulator();
                PPrBase.Ind ind = ndp.getInd("1", "0");
                if (ind != null) {
                    Assert.assertEquals((Object)ind.getLeft().toString(), (Object)expected[i]);
                    System.out.println("<w:ind w:left='" + ind.getLeft().toString() + "\n\n");
                    continue;
                }
                Assert.assertEquals((Object)ind, (Object)expected[i]);
                System.out.println("w:ind was null\n\n");
                continue;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                throw new RuntimeException(exc);
            }
        }
    }
}

