/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.docx4j.fonts.fop.fonts.CodePointMapping;
import org.docx4j.fonts.fop.fonts.CustomFont;
import org.docx4j.fonts.fop.fonts.NamedCharacter;
import org.docx4j.fonts.fop.fonts.SimpleSingleByteEncoding;
import org.docx4j.fonts.fop.fonts.SingleByteEncoding;

public class SingleByteFont
extends CustomFont {
    private static Log log = LogFactory.getLog(SingleByteFont.class);
    private SingleByteEncoding mapping;
    private boolean useNativeEncoding = false;
    private int[] width = null;
    private Map unencodedCharacters;
    private List additionalEncodings;

    public SingleByteFont() {
        this.setEncoding("WinAnsiEncoding");
    }

    public boolean isEmbeddable() {
        return this.getEmbedFileName() != null || this.getEmbedResourceName() != null;
    }

    public String getEncodingName() {
        return this.mapping.getName();
    }

    public SingleByteEncoding getEncoding() {
        return this.mapping;
    }

    public int getWidth(int i, int size) {
        if (i < 256) {
            int idx = i - this.getFirstChar();
            if (idx >= 0 && idx < this.width.length) {
                return size * this.width[i - this.getFirstChar()];
            }
        } else if (this.additionalEncodings != null) {
            int encodingIndex = i / 256 - 1;
            SimpleSingleByteEncoding encoding = this.getAdditionalEncoding(encodingIndex);
            int codePoint = i % 256;
            NamedCharacter nc = encoding.getCharacterForIndex(codePoint);
            UnencodedCharacter uc = (UnencodedCharacter)this.unencodedCharacters.get(new Character(nc.getSingleUnicodeValue()));
            return size * uc.getWidth();
        }
        return 0;
    }

    public int[] getWidths() {
        int[] arr = new int[this.width.length];
        System.arraycopy(this.width, 0, arr, 0, this.width.length - 1);
        return arr;
    }

    public char mapChar(char c) {
        this.notifyMapOperation();
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        d = this.mapUnencodedChar(c);
        if (d != '\u0000') {
            return d;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    private char mapUnencodedChar(char ch) {
        UnencodedCharacter unencoded;
        if (this.unencodedCharacters != null && (unencoded = (UnencodedCharacter)this.unencodedCharacters.get(new Character(ch))) != null) {
            if (this.additionalEncodings == null) {
                this.additionalEncodings = new ArrayList();
            }
            SimpleSingleByteEncoding encoding = null;
            int mappedStart = 0;
            int additionalsCount = this.additionalEncodings.size();
            for (int i = 0; i < additionalsCount; ++i) {
                mappedStart = (char)(mappedStart + 256);
                encoding = this.getAdditionalEncoding(i);
                char alt = encoding.mapChar(ch);
                if (alt == '\u0000') continue;
                return (char)(mappedStart + alt);
            }
            if (encoding != null && encoding.isFull()) {
                encoding = null;
            }
            if (encoding == null) {
                encoding = new SimpleSingleByteEncoding(this.getFontName() + "EncodingSupp" + (additionalsCount + 1));
                this.additionalEncodings.add(encoding);
                mappedStart = (char)(mappedStart + 256);
            }
            return (char)(mappedStart + encoding.addCharacter(unencoded.getCharacter()));
        }
        return '\u0000';
    }

    public boolean hasChar(char c) {
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return true;
        }
        d = this.mapUnencodedChar(c);
        return d != '\u0000';
    }

    protected void updateMapping(String encoding) {
        try {
            this.mapping = CodePointMapping.getMapping(encoding);
        }
        catch (UnsupportedOperationException e) {
            log.error((Object)("Font '" + super.getFontName() + "': " + e.getMessage()));
        }
    }

    public void setEncoding(String encoding) {
        this.updateMapping(encoding);
    }

    public void setEncoding(CodePointMapping encoding) {
        this.mapping = encoding;
    }

    public void setUseNativeEncoding(boolean value) {
        this.useNativeEncoding = value;
    }

    public boolean isUsingNativeEncoding() {
        return this.useNativeEncoding;
    }

    public void setWidth(int index, int w) {
        if (this.width == null) {
            this.width = new int[this.getLastChar() - this.getFirstChar() + 1];
        }
        this.width[index - this.getFirstChar()] = w;
    }

    public void addUnencodedCharacter(NamedCharacter ch, int width) {
        if (this.unencodedCharacters == null) {
            this.unencodedCharacters = new HashMap();
        }
        if (ch.hasSingleUnicodeValue()) {
            UnencodedCharacter uc = new UnencodedCharacter(ch, width);
            this.unencodedCharacters.put(new Character(ch.getSingleUnicodeValue()), uc);
        }
    }

    public void encodeAllUnencodedCharacters() {
        if (this.unencodedCharacters != null) {
            TreeSet sortedKeys = new TreeSet(this.unencodedCharacters.keySet());
            for (Character ch : sortedKeys) {
                char mapped = this.mapChar(ch.charValue());
                assert (mapped != '#');
            }
        }
    }

    public boolean hasAdditionalEncodings() {
        return this.additionalEncodings != null && this.additionalEncodings.size() > 0;
    }

    public int getAdditionalEncodingCount() {
        if (this.hasAdditionalEncodings()) {
            return this.additionalEncodings.size();
        }
        return 0;
    }

    public SimpleSingleByteEncoding getAdditionalEncoding(int index) throws IndexOutOfBoundsException {
        if (this.hasAdditionalEncodings()) {
            return (SimpleSingleByteEncoding)this.additionalEncodings.get(index);
        }
        throw new IndexOutOfBoundsException("No additional encodings available");
    }

    public int[] getAdditionalWidths(int index) {
        SimpleSingleByteEncoding enc = this.getAdditionalEncoding(index);
        int[] arr = new int[enc.getLastChar() - enc.getFirstChar() + 1];
        int c = arr.length;
        for (int i = 0; i < c; ++i) {
            NamedCharacter nc = enc.getCharacterForIndex(enc.getFirstChar() + i);
            UnencodedCharacter uc = (UnencodedCharacter)this.unencodedCharacters.get(new Character(nc.getSingleUnicodeValue()));
            arr[i] = uc.getWidth();
        }
        return arr;
    }

    private static final class UnencodedCharacter {
        private NamedCharacter character;
        private int width;

        public UnencodedCharacter(NamedCharacter character, int width) {
            this.character = character;
            this.width = width;
        }

        public NamedCharacter getCharacter() {
            return this.character;
        }

        public int getWidth() {
            return this.width;
        }

        public String toString() {
            return this.getCharacter().toString();
        }
    }
}

