/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.docx4j.fonts.fop.apps.FOPException;
import org.docx4j.fonts.fop.fonts.EmbedFontInfo;
import org.docx4j.fonts.fop.util.LogUtil;

public final class FontCache
implements Serializable {
    private static final long serialVersionUID = 605232520271754719L;
    private static Log log = LogFactory.getLog(FontCache.class);
    private static final String FOP_USER_DIR = ".docx4j";
    private static final String DEFAULT_CACHE_FILENAME = "fop-fonts.cache";
    private transient boolean changed = false;
    private final boolean[] changeLock = new boolean[1];
    private Map fontfileMap = null;
    private Map failedFontMap = null;

    private static File getUserHome() {
        return FontCache.toDirectory(System.getProperty("user.home"));
    }

    private static File getTempDirectory() {
        return FontCache.toDirectory(System.getProperty("java.io.tmpdir"));
    }

    private static File toDirectory(String path) {
        File dir;
        if (path != null && (dir = new File(path)).exists()) {
            return dir;
        }
        return null;
    }

    public static File getDefaultCacheFile(boolean forWriting) {
        File userHome = FontCache.getUserHome();
        if (userHome != null) {
            File fopUserDir = new File(userHome, FOP_USER_DIR);
            if (forWriting) {
                boolean writable = fopUserDir.canWrite();
                if (!fopUserDir.exists()) {
                    writable = fopUserDir.mkdir();
                }
                if (!writable) {
                    userHome = FontCache.getTempDirectory();
                    fopUserDir = new File(userHome, FOP_USER_DIR);
                    fopUserDir.mkdir();
                }
            }
            return new File(fopUserDir, DEFAULT_CACHE_FILENAME);
        }
        return new File(FOP_USER_DIR);
    }

    public static FontCache load() {
        return FontCache.loadFrom(FontCache.getDefaultCacheFile(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FontCache loadFrom(File cacheFile) {
        block10: {
            if (cacheFile.exists()) {
                FontCache fontCache;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Loading font cache from " + cacheFile.getCanonicalPath()));
                }
                InputStream in = new FileInputStream(cacheFile);
                in = new BufferedInputStream(in);
                ObjectInputStream oin = new ObjectInputStream(in);
                try {
                    fontCache = (FontCache)oin.readObject();
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.closeQuietly((InputStream)oin);
                        throw throwable;
                    }
                    catch (ClassNotFoundException e) {
                        log.warn((Object)("Could not read font cache. Discarding font cache file. Reason: " + e.getMessage()));
                        break block10;
                    }
                    catch (IOException ioe) {
                        log.warn((Object)("I/O exception while reading font cache (" + ioe.getMessage() + "). Discarding font cache file."));
                        try {
                            cacheFile.delete();
                        }
                        catch (SecurityException ex) {
                            log.warn((Object)("Failed to delete font cache file: " + cacheFile.getAbsolutePath()));
                        }
                    }
                }
                IOUtils.closeQuietly((InputStream)oin);
                return fontCache;
            }
        }
        return null;
    }

    public void save() throws FOPException {
        this.saveTo(FontCache.getDefaultCacheFile(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(File cacheFile) throws FOPException {
        boolean[] blArray = this.changeLock;
        synchronized (this.changeLock) {
            if (this.changed) {
                try {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Writing font cache to " + cacheFile.getCanonicalPath()));
                    }
                    OutputStream out = new FileOutputStream(cacheFile);
                    out = new BufferedOutputStream(out);
                    ObjectOutputStream oout = new ObjectOutputStream(out);
                    try {
                        oout.writeObject(this);
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)oout);
                    }
                }
                catch (IOException ioe) {
                    LogUtil.handleException(log, ioe, true);
                }
                this.changed = false;
                log.trace((Object)"Cache file written.");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected static String getCacheKey(EmbedFontInfo fontInfo) {
        if (fontInfo != null) {
            String embedFile = fontInfo.getEmbedFile();
            String metricsFile = fontInfo.getMetricsFile();
            return embedFile != null ? embedFile : metricsFile;
        }
        return null;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public boolean containsFont(String embedUrl) {
        return embedUrl != null && this.getFontFileMap().containsKey(embedUrl);
    }

    public boolean containsFont(EmbedFontInfo fontInfo) {
        return fontInfo != null && this.getFontFileMap().containsKey(FontCache.getCacheKey(fontInfo));
    }

    public static File getFileFromUrls(String[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            String urlStr = urls[i];
            if (urlStr == null) continue;
            File fontFile = null;
            if (urlStr.startsWith("file:")) {
                try {
                    URL url = new URL(urlStr);
                    fontFile = FileUtils.toFile((URL)url);
                }
                catch (MalformedURLException mfue) {
                    // empty catch block
                }
            }
            if (fontFile == null) {
                fontFile = new File(urlStr);
            }
            if (!fontFile.exists() || !fontFile.canRead()) continue;
            return fontFile;
        }
        return null;
    }

    private Map getFontFileMap() {
        if (this.fontfileMap == null) {
            this.fontfileMap = new HashMap();
        }
        return this.fontfileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFont(EmbedFontInfo fontInfo) {
        String cacheKey = FontCache.getCacheKey(fontInfo);
        boolean[] blArray = this.changeLock;
        synchronized (this.changeLock) {
            if (this.containsFont(cacheKey)) {
                CachedFontFile cachedFontFile = (CachedFontFile)this.getFontFileMap().get(cacheKey);
                if (!cachedFontFile.containsFont(fontInfo)) {
                    cachedFontFile.put(fontInfo);
                }
            } else {
                File fontFile = FontCache.getFileFromUrls(new String[]{fontInfo.getEmbedFile(), fontInfo.getMetricsFile()});
                long lastModified = fontFile != null ? fontFile.lastModified() : -1L;
                CachedFontFile cachedFontFile = new CachedFontFile(lastModified);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Font added to cache: " + cacheKey));
                }
                cachedFontFile.put(fontInfo);
                this.getFontFileMap().put(cacheKey, cachedFontFile);
                this.changed = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public CachedFontFile getFontFile(String embedUrl) {
        return this.containsFont(embedUrl) ? (CachedFontFile)this.getFontFileMap().get(embedUrl) : null;
    }

    public EmbedFontInfo[] getFontInfos(String embedUrl, long lastModified) {
        CachedFontFile cff = this.getFontFile(embedUrl);
        if (cff.lastModified() == lastModified) {
            return cff.getEmbedFontInfos();
        }
        this.removeFont(embedUrl);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFont(String embedUrl) {
        boolean[] blArray = this.changeLock;
        synchronized (this.changeLock) {
            if (this.containsFont(embedUrl)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Font removed from cache: " + embedUrl));
                }
                this.getFontFileMap().remove(embedUrl);
                this.changed = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailedFont(String embedUrl, long lastModified) {
        boolean[] blArray = this.changeLock;
        synchronized (this.changeLock) {
            if (this.getFailedFontMap().containsKey(embedUrl)) {
                long failedLastModified = (Long)this.getFailedFontMap().get(embedUrl);
                if (lastModified != failedLastModified) {
                    this.getFailedFontMap().remove(embedUrl);
                    this.changed = true;
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFailedFont(String embedUrl, long lastModified) {
        boolean[] blArray = this.changeLock;
        synchronized (this.changeLock) {
            if (!this.getFailedFontMap().containsKey(embedUrl)) {
                this.getFailedFontMap().put(embedUrl, new Long(lastModified));
                this.changed = true;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    private Map getFailedFontMap() {
        if (this.failedFontMap == null) {
            this.failedFontMap = new HashMap();
        }
        return this.failedFontMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        boolean[] blArray = this.changeLock;
        synchronized (this.changeLock) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Font cache cleared.");
            }
            this.fontfileMap = null;
            this.failedFontMap = null;
            this.changed = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastModified(URL url) {
        long l;
        URLConnection conn = url.openConnection();
        try {
            l = conn.getLastModified();
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)conn.getInputStream());
                throw throwable;
            }
            catch (IOException e) {
                log.debug((Object)("IOError: " + e.getMessage()));
                return 0L;
            }
        }
        IOUtils.closeQuietly((InputStream)conn.getInputStream());
        return l;
    }

    private static class CachedFontFile
    implements Serializable {
        private static final long serialVersionUID = 4524237324330578883L;
        private long lastModified = -1L;
        private Map filefontsMap = null;

        public CachedFontFile(long lastModified) {
            this.setLastModified(lastModified);
        }

        private Map getFileFontsMap() {
            if (this.filefontsMap == null) {
                this.filefontsMap = new HashMap();
            }
            return this.filefontsMap;
        }

        void put(EmbedFontInfo efi) {
            this.getFileFontsMap().put(efi.getPostScriptName(), efi);
        }

        public boolean containsFont(EmbedFontInfo efi) {
            return efi.getPostScriptName() != null && this.getFileFontsMap().containsKey(efi.getPostScriptName());
        }

        public EmbedFontInfo[] getEmbedFontInfos() {
            return this.getFileFontsMap().values().toArray(new EmbedFontInfo[this.getFileFontsMap().size()]);
        }

        public long lastModified() {
            return this.lastModified;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public String toString() {
            return super.toString() + ", lastModified=" + this.lastModified;
        }
    }
}

