/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.wml.Fonts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Mapper {
    protected static Logger log = Logger.getLogger(Mapper.class);
    protected static final Map<String, PhysicalFont> fontMappings = Collections.synchronizedMap(new HashMap());
    public static final String FONT_FALLBACK = "Times New Roman";

    public Map<String, PhysicalFont> getFontMappings() {
        return fontMappings;
    }

    public abstract void populateFontMappings(Map var1, Fonts var2) throws Exception;

    public static String getSubstituteFontXsltExtension(Mapper s, String documentStyleId, String bolditalic, boolean fontFamilyStack) {
        return s.getSubstituteFontXsltExtension(documentStyleId, bolditalic, fontFamilyStack);
    }

    public String getSubstituteFontXsltExtension(String documentStyleId, String bolditalic, boolean fontFamilyStack) {
        log.debug((Object)("Trying to insert HTML font-family value for " + documentStyleId));
        if (documentStyleId == null) {
            log.error((Object)"passed null documentStyleId");
            return "nullInputToExtension";
        }
        PhysicalFont physicalFont = fontMappings.get(documentStyleId);
        if (physicalFont == null) {
            log.error((Object)("No mapping for: " + documentStyleId));
            return FONT_FALLBACK;
        }
        String fontFamily = physicalFont.getName();
        if (fontFamily.startsWith("Britannic")) {
            return fontFamily;
        }
        if (fontFamily.endsWith(" Demibold")) {
            fontFamily = fontFamily.substring(0, fontFamily.length() - 9);
        }
        if (fontFamily.endsWith(" Oblique")) {
            fontFamily = fontFamily.substring(0, fontFamily.length() - 8);
        }
        if (fontFamily.endsWith(" Italic")) {
            fontFamily = fontFamily.substring(0, fontFamily.length() - 7);
        }
        if (fontFamily.endsWith(" Bold")) {
            fontFamily = fontFamily.substring(0, fontFamily.length() - 5);
        }
        log.debug((Object)("Mapping " + documentStyleId + " to " + physicalFont.getName()));
        return fontFamily;
    }
}

