/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.pdf.viaXSLFO;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.Containerization;
import org.docx4j.convert.out.Converter;
import org.docx4j.convert.out.PageBreak;
import org.docx4j.convert.out.html.HtmlExporterNG2;
import org.docx4j.convert.out.pdf.PdfConversion;
import org.docx4j.convert.out.pdf.viaXSLFO.InField;
import org.docx4j.convert.out.pdf.viaXSLFO.PDFConversionImageHandler;
import org.docx4j.convert.out.pdf.viaXSLFO.PartTracker;
import org.docx4j.convert.out.pdf.viaXSLFO.PdfSettings;
import org.docx4j.convert.out.pdf.viaXSLFO.SymbolWriter;
import org.docx4j.convert.out.pdf.viaXSLFO.TableWriter;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.fonts.fop.fonts.FontTriplet;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.SymbolModel;
import org.docx4j.model.TransformState;
import org.docx4j.model.listnumbering.Emulator;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.PropertyFactory;
import org.docx4j.model.properties.paragraph.Indent;
import org.docx4j.model.properties.paragraph.PBorderBottom;
import org.docx4j.model.properties.paragraph.PBorderTop;
import org.docx4j.model.properties.paragraph.PShading;
import org.docx4j.model.properties.run.Font;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.model.structure.jaxb.ObjectFactory;
import org.docx4j.model.structure.jaxb.Sections;
import org.docx4j.model.table.TableModel;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.CTPageNumber;
import org.docx4j.wml.CTSimpleField;
import org.docx4j.wml.Document;
import org.docx4j.wml.NumberFormat;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.TcPr;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

public class Conversion
extends PdfConversion {
    public static Logger log = Logger.getLogger(Conversion.class);
    public static final String PART_TRACKER = "partTracker";
    public static final String FIELD_TRACKER = "fieldTracker";
    static Templates xslt;
    private static File saveFO;
    Configuration fopConfig;

    public static boolean isLoggingEnabled() {
        return log.isDebugEnabled();
    }

    public Conversion(WordprocessingMLPackage wordMLPackage) {
        super(wordMLPackage);
    }

    public void setSaveFO(File save) {
        saveFO = save;
    }

    private String declareFonts() {
        StringBuffer result = new StringBuffer();
        Map fontsInUse = this.wordMLPackage.getMainDocumentPart().fontsInUse();
        for (Map.Entry pairs : fontsInUse.entrySet()) {
            if (pairs.getKey() == null) {
                log.info((Object)"Skipped null key");
                continue;
            }
            String fontName = (String)pairs.getKey();
            PhysicalFont pf = this.wordMLPackage.getFontMapper().getFontMappings().get(fontName);
            if (pf == null) {
                log.error((Object)("Document font " + fontName + " is not mapped to a physical font!"));
                continue;
            }
            String subFontAtt = "";
            if (pf.getEmbedFontInfo().getSubFontName() != null) {
                subFontAtt = " sub-font=\"" + pf.getEmbedFontInfo().getSubFontName() + "\"";
            }
            result.append("<font embed-url=\"" + pf.getEmbeddedFile() + "\"" + subFontAtt + ">");
            FontTriplet fontTriplet = (FontTriplet)pf.getEmbedFontInfo().getFontTriplets().get(0);
            this.addFontTriplet(result, fontTriplet);
            result.append("</font>");
            PhysicalFont pfVariation = PhysicalFonts.getBoldForm(pf);
            if (pfVariation != null) {
                result.append("<font embed-url=\"" + pfVariation.getEmbeddedFile() + "\"" + subFontAtt + ">");
                this.addFontTriplet(result, pf.getName(), "normal", "bold");
                result.append("</font>");
            }
            if ((pfVariation = PhysicalFonts.getBoldItalicForm(pf)) != null) {
                result.append("<font embed-url=\"" + pfVariation.getEmbeddedFile() + "\"" + subFontAtt + ">");
                this.addFontTriplet(result, pf.getName(), "italic", "bold");
                result.append("</font>");
            }
            if ((pfVariation = PhysicalFonts.getItalicForm(pf)) == null) continue;
            result.append("<font embed-url=\"" + pfVariation.getEmbeddedFile() + "\"" + subFontAtt + ">");
            this.addFontTriplet(result, pf.getName(), "italic", "normal");
            result.append("</font>");
        }
        return result.toString();
    }

    private void addFontTriplet(StringBuffer result, FontTriplet fontTriplet) {
        result.append("<font-triplet name=\"" + fontTriplet.getName() + "\"" + " style=\"" + fontTriplet.getStyle() + "\"" + " weight=\"" + this.weightToCSS2FontWeight(fontTriplet.getWeight()) + "\"" + "/>");
    }

    private void addFontTriplet(StringBuffer result, String familyName, String style, String weight) {
        result.append("<font-triplet name=\"" + familyName + "\"" + " style=\"" + style + "\"" + " weight=\"" + weight + "\"" + "/>");
    }

    private String weightToCSS2FontWeight(int i) {
        if (i >= 700) {
            return "bold";
        }
        return "normal";
    }

    public void setFopConfig(Configuration fopConfig) {
        this.fopConfig = fopConfig;
    }

    public void output(OutputStream os, PdfSettings settings) throws Docx4JException {
        FopFactory fopFactory = FopFactory.newInstance();
        try {
            if (this.fopConfig == null) {
                DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
                String myConfig = "<fop version=\"1.0\"><strict-configuration>true</strict-configuration><renderers><renderer mime=\"application/pdf\"><fonts>" + this.declareFonts() + "</fonts></renderer></renderers></fop>";
                log.debug((Object)("\nUsing config:\n " + myConfig + "\n"));
                this.fopConfig = cfgBuilder.build((InputStream)new ByteArrayInputStream(myConfig.getBytes("UTF-8")));
            }
            fopFactory.setUserConfig(this.fopConfig);
            Fop fop = fopFactory.newFop("application/pdf", os);
            MainDocumentPart mdp = this.wordMLPackage.getMainDocumentPart();
            Document tmpDoc = (Document)XmlUtils.deepCopy(this.wordMLPackage.getMainDocumentPart().getJaxbElement());
            Containerization.groupAdjacentBorders(tmpDoc.getBody());
            PageBreak.movePageBreaks(tmpDoc.getBody());
            Sections sections = this.createSectionContainers(tmpDoc);
            org.w3c.dom.Document domDoc = XmlUtils.marshaltoW3CDomDocument(sections, Context.jcSectionModel);
            log.debug((Object)XmlUtils.marshaltoString((Object)sections, false, Context.jcSectionModel));
            if (settings == null) {
                settings = new PdfSettings();
            }
            settings.setWmlPackage(this.wordMLPackage);
            boolean privateImageHandler = false;
            if (settings.getImageHandler() == null) {
                settings.setImageHandler(settings.getImageDirPath() != null ? new PDFConversionImageHandler(settings.getImageDirPath(), true) : new PDFConversionImageHandler());
                privateImageHandler = true;
            }
            SAXResult result = new SAXResult(fop.getDefaultHandler());
            HashMap<String, TransformState> modelStates = new HashMap<String, TransformState>();
            settings.getSettings().put("modelStates", modelStates);
            Converter.getInstance().registerModelConverter("w:tbl", new TableWriter());
            Converter.getInstance().registerModelConverter("w:sym", new SymbolWriter());
            modelStates.put("w:tbl", new TableModel.TableModelTransformState());
            modelStates.put("w:sym", new SymbolModel.SymbolModelTransformState());
            modelStates.put("footnoteNumber", new HtmlExporterNG2.FootnoteState());
            modelStates.put("endnoteNumber", new HtmlExporterNG2.EndnoteState());
            modelStates.put(PART_TRACKER, new PartTracker());
            modelStates.put(FIELD_TRACKER, new InField());
            Converter.getInstance().start(this.wordMLPackage);
            if (saveFO != null || log.isDebugEnabled()) {
                ByteArrayOutputStream intermediate = new ByteArrayOutputStream();
                StreamResult intermediateResult = new StreamResult(intermediate);
                XmlUtils.transform(domDoc, xslt, settings.getSettings(), (Result)intermediateResult);
                String fo = intermediate.toString("UTF-8");
                log.debug((Object)fo);
                if (saveFO != null) {
                    FileUtils.writeStringToFile((File)saveFO, (String)fo, (String)"UTF-8");
                    log.info((Object)("Saved " + saveFO.getPath()));
                }
                StreamSource src = new StreamSource(new StringReader(fo));
                Transformer transformer = XmlUtils.getTransformerFactory().newTransformer();
                transformer.transform(src, result);
            } else {
                XmlUtils.transform(domDoc, xslt, settings.getSettings(), (Result)result);
            }
            if (privateImageHandler) {
                settings.getSettings().remove("imageHandler");
            }
        }
        catch (Exception e) {
            throw new Docx4JException("FOP issues", e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Sections createSectionContainers(Document doc) {
        ObjectFactory factory = new ObjectFactory();
        Sections sections = factory.createSections();
        Sections.Section section = factory.createSectionsSection();
        section.setName("s1");
        sections.getSection().add(section);
        int i = 2;
        for (Object o : doc.getBody().getEGBlockLevelElts()) {
            PPr ppr;
            if (o instanceof P && ((P)o).getPPr() != null && (ppr = ((P)o).getPPr()).getSectPr() != null && (ppr.getSectPr().getType() == null || !ppr.getSectPr().getType().getVal().equals("continuous"))) {
                section = factory.createSectionsSection();
                section.setName("s" + i);
                sections.getSection().add(section);
                ++i;
            }
            section.getAny().add(this.marshall(o));
        }
        return sections;
    }

    private Element marshall(Object o) {
        try {
            org.w3c.dom.Document w3cDoc = XmlUtils.marshaltoW3CDomDocument(o);
            return w3cDoc.getDocumentElement();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void logDebug(String message) {
        log.debug((Object)message);
    }

    public static void logInfo(String message) {
        log.info((Object)message);
    }

    public static void logWarn(String message) {
        log.warn((Object)message);
    }

    public static DocumentFragment notImplemented(NodeIterator nodes, String message) {
        Node n = nodes.nextNode();
        log.warn((Object)("NOT IMPLEMENTED: support for " + n.getNodeName() + "\n" + message));
        if (log.isDebugEnabled()) {
            if (message == null) {
                message = "";
            }
            log.debug((Object)XmlUtils.w3CDomNodeToString(n));
            return Conversion.message("NOT IMPLEMENTED: support for " + n.getNodeName() + " - " + message);
        }
        return null;
    }

    public static DocumentFragment message(String message) {
        if (!log.isDebugEnabled()) {
            return null;
        }
        String fo = "<fo:block xmlns:fo=\"http://www.w3.org/1999/XSL/Format\"  font-size=\"12pt\" color=\"red\" font-family=\"sans-serif\" line-height=\"15pt\" space-after.optimum=\"3pt\" text-align=\"justify\"> " + message + "</fo:block>";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        StringReader reader = new StringReader(fo);
        InputSource inputSource = new InputSource(reader);
        org.w3c.dom.Document doc = null;
        try {
            doc = dbf.newDocumentBuilder().parse(inputSource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        reader.close();
        DocumentFragment docfrag = doc.createDocumentFragment();
        docfrag.appendChild(doc.getDocumentElement());
        return docfrag;
    }

    public static DocumentFragment createBlockForSdt(WordprocessingMLPackage wmlPackage, NodeIterator pPrNodeIt, String pStyleVal, NodeIterator childResults, String tag) {
        Node foBlock;
        DocumentFragment docfrag = Conversion.createBlock(wmlPackage, pPrNodeIt, pStyleVal, childResults, true);
        if (tag.equals("XSLT_Shd") && docfrag != null && (foBlock = docfrag.getFirstChild()) != null) {
            ((Element)foBlock).setAttribute("margin-top", "0in");
            ((Element)foBlock).setAttribute("margin-bottom", "0in");
        }
        return docfrag;
    }

    public static DocumentFragment createInlineForSdt(WordprocessingMLPackage wmlPackage, NodeIterator rPrNodeIt, NodeIterator childResults, String tag) {
        DocumentFragment docfrag = Conversion.createBlockForRPr(wmlPackage, null, rPrNodeIt, childResults);
        return docfrag;
    }

    public static DocumentFragment createBlockForPPr(WordprocessingMLPackage wmlPackage, NodeIterator pPrNodeIt, String pStyleVal, NodeIterator childResults) {
        return Conversion.createBlock(wmlPackage, pPrNodeIt, pStyleVal, childResults, false);
    }

    public static DocumentFragment createBlock(WordprocessingMLPackage wmlPackage, NodeIterator pPrNodeIt, String pStyleVal, NodeIterator childResults, boolean sdt) {
        PropertyResolver propertyResolver = wmlPackage.getMainDocumentPart().getPropertyResolver();
        Style defaultParagraphStyle = wmlPackage.getMainDocumentPart().getStyleDefinitionsPart().getDefaultParagraphStyle();
        String defaultParagraphStyleId = defaultParagraphStyle == null ? "Normal" : defaultParagraphStyle.getStyleId();
        if (pStyleVal == null || pStyleVal.equals("")) {
            pStyleVal = defaultParagraphStyleId;
        }
        log.debug((Object)("style '" + pStyleVal));
        try {
            Node n;
            Element foBlockElement;
            PPr pPrDirect = null;
            PPr pPr = null;
            RPr rPr = null;
            if (pPrNodeIt == null) {
                log.debug((Object)"Here after all!!");
                pPr = propertyResolver.getEffectivePPr(defaultParagraphStyleId);
                rPr = propertyResolver.getEffectiveRPr(defaultParagraphStyleId);
            } else {
                Node n2 = pPrNodeIt.nextNode();
                if (n2 == null) {
                    log.debug((Object)"pPrNodeIt.nextNode() was null.");
                    pPr = propertyResolver.getEffectivePPr(defaultParagraphStyleId);
                    rPr = propertyResolver.getEffectiveRPr(defaultParagraphStyleId);
                } else {
                    log.debug((Object)XmlUtils.w3CDomNodeToString(n2));
                    Unmarshaller u = Context.jc.createUnmarshaller();
                    u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
                    Object jaxb = u.unmarshal(n2);
                    pPrDirect = (PPr)jaxb;
                    pPr = propertyResolver.getEffectivePPr(pPrDirect);
                    if (pPr == null) {
                        log.debug((Object)("pPr null; obtained from: " + XmlUtils.w3CDomNodeToString(n2)));
                    }
                    log.debug((Object)"getting rPr for paragraph style");
                    rPr = propertyResolver.getEffectiveRPr(null, pPrDirect);
                }
            }
            if (log.isDebugEnabled() && pPr != null) {
                log.debug((Object)XmlUtils.marshaltoString((Object)pPr, true, true));
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            org.w3c.dom.Document document = factory.newDocumentBuilder().newDocument();
            boolean inlist = false;
            if (pPr != null && pPr.getNumPr() != null) {
                Emulator.ResultTriple triple;
                inlist = true;
                Element foListBlock = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:list-block");
                document.appendChild(foListBlock);
                foListBlock.setAttribute("provisional-distance-between-starts", "0.5in");
                if (pPr.getShd() != null) {
                    PShading pShading = new PShading(pPr.getShd());
                    pShading.setXslFO(foListBlock);
                }
                Element foListItem = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:list-item");
                foListBlock.appendChild(foListItem);
                Element foListItemLabel = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:list-item-label");
                foListItem.appendChild(foListItemLabel);
                Element foListItemLabelBody = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:block");
                foListItemLabel.appendChild(foListItemLabelBody);
                if (pPrDirect != null && pPrDirect.getNumPr() != null) {
                    triple = Emulator.getNumber(wmlPackage, pStyleVal, pPrDirect.getNumPr().getNumId().getVal().toString(), pPrDirect.getNumPr().getIlvl().getVal().toString());
                } else {
                    PPrBase.NumPr.Ilvl ilvl = pPr.getNumPr().getIlvl();
                    String ilvlString = ilvl == null ? "0" : ilvl.getVal().toString();
                    triple = Emulator.getNumber(wmlPackage, pStyleVal, pPr.getNumPr().getNumId().getVal().toString(), ilvlString);
                }
                if (triple == null) {
                    log.warn((Object)"computed number ResultTriple was null");
                    if (log.isDebugEnabled()) {
                        foListItemLabelBody.setTextContent("nrt");
                    }
                } else {
                    String font;
                    if (triple.getIndent() != null) {
                        Indent indent = new Indent(triple.getIndent());
                        indent.setXslFO(foListBlock);
                    }
                    if (triple.getNumFont() != null && (font = Font.getPhysicalFont(wmlPackage, triple.getNumFont())) != null) {
                        foListItemLabelBody.setAttribute("font-family", font);
                    }
                    if (triple.getBullet() != null) {
                        foListItemLabelBody.setTextContent(triple.getBullet());
                    } else if (triple.getNumString() == null) {
                        log.warn((Object)"computed NumString was null!");
                        if (log.isDebugEnabled()) {
                            foListItemLabelBody.setTextContent("nns");
                        }
                    } else {
                        Text number = document.createTextNode(triple.getNumString());
                        foListItemLabelBody.appendChild(number);
                    }
                }
                Element foListItemBody = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:list-item-body");
                foListItem.appendChild(foListItemBody);
                foListItemBody.setAttribute("start-indent", "body-start()");
                foBlockElement = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:block");
                foListItemBody.appendChild(foBlockElement);
            } else {
                foBlockElement = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:block");
                document.appendChild(foBlockElement);
            }
            if (pPr != null) {
                boolean ignoreBorders = !sdt;
                Conversion.createFoAttributes(wmlPackage, pPr, foBlockElement, inlist, ignoreBorders);
            }
            if (rPr != null) {
                Conversion.createFoAttributes(wmlPackage, rPr, foBlockElement);
            }
            if ((n = childResults.nextNode()).getChildNodes().getLength() == 0) {
                foBlockElement.setAttribute("white-space-treatment", "preserve");
                foBlockElement.setTextContent(" ");
            } else {
                XmlUtils.treeCopy(n, (Node)foBlockElement);
            }
            DocumentFragment docfrag = document.createDocumentFragment();
            docfrag.appendChild(document.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
            log.error((Object)e);
            return null;
        }
    }

    public static void createFoAttributes(WordprocessingMLPackage wmlPackage, PPr pPr, Element foBlockElement, boolean inList, boolean ignoreBorders) {
        List<Property> properties = PropertyFactory.createProperties((OpcPackage)wmlPackage, pPr);
        for (Property p : properties) {
            if (p == null || ignoreBorders && (p instanceof PBorderTop || p instanceof PBorderBottom)) continue;
            if (inList && !(p instanceof Indent)) {
                p.setXslFO(foBlockElement);
                continue;
            }
            if (inList) continue;
            p.setXslFO(foBlockElement);
        }
    }

    protected static void createFoAttributes(TcPr tcPr, Element foBlockElement) {
        if (tcPr == null) {
            return;
        }
        List<Property> properties = PropertyFactory.createProperties(tcPr);
        for (Property p : properties) {
            p.setXslFO(foBlockElement);
        }
    }

    public static DocumentFragment createBlockForRPr(WordprocessingMLPackage wmlPackage, NodeIterator pPrNodeIt, NodeIterator rPrNodeIt, NodeIterator childResults) {
        PropertyResolver propertyResolver = wmlPackage.getMainDocumentPart().getPropertyResolver();
        try {
            Node n;
            Unmarshaller u = Context.jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            PPr pPrDirect = null;
            if (pPrNodeIt != null && (n = pPrNodeIt.nextNode()) != null) {
                Object jaxb = u.unmarshal(n);
                try {
                    pPrDirect = (PPr)jaxb;
                }
                catch (ClassCastException e) {
                    log.error((Object)("Couldn't cast " + jaxb.getClass().getName() + " to PPr!"));
                }
            }
            Object jaxbR = u.unmarshal(rPrNodeIt.nextNode());
            RPr rPrDirect = null;
            try {
                rPrDirect = (RPr)jaxbR;
            }
            catch (ClassCastException e) {
                log.error((Object)"Couldn't cast ..");
            }
            RPr rPr = propertyResolver.getEffectiveRPr(rPrDirect, pPrDirect);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            org.w3c.dom.Document document = factory.newDocumentBuilder().newDocument();
            Element foInlineElement = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:inline");
            document.appendChild(foInlineElement);
            if (log.isDebugEnabled() && rPr != null) {
                log.debug((Object)XmlUtils.marshaltoString((Object)rPr, true, true));
            }
            Conversion.createFoAttributes(wmlPackage, rPr, foInlineElement);
            Node n2 = childResults.nextNode();
            XmlUtils.treeCopy(n2, (Node)foInlineElement);
            DocumentFragment docfrag = document.createDocumentFragment();
            docfrag.appendChild(document.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
            log.error((Object)e);
            return null;
        }
    }

    public static void createFoAttributes(WordprocessingMLPackage wmlPackage, RPr rPr, Element foInlineElement) {
        List<Property> properties = PropertyFactory.createProperties((OpcPackage)wmlPackage, rPr);
        for (Property p : properties) {
            p.setXslFO(foInlineElement);
        }
    }

    public static DocumentFragment createBlockForFldSimple(WordprocessingMLPackage wmlPackage, NodeIterator fldSimpleNodeIt, NodeIterator childResults) {
        CTSimpleField field = null;
        try {
            field = (CTSimpleField)XmlUtils.unmarshal(fldSimpleNodeIt.nextNode(), Context.jc, CTSimpleField.class);
        }
        catch (JAXBException e1) {
            e1.printStackTrace();
        }
        String instr = field.getInstr();
        return Conversion.handleField(instr, childResults);
    }

    private static DocumentFragment handleField(String instr, NodeIterator childResults) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            org.w3c.dom.Document document = factory.newDocumentBuilder().newDocument();
            if (!instr.toLowerCase().contains("page")) {
                if (log.isDebugEnabled()) {
                    return Conversion.message("no support for fields (except PAGE numbering)");
                }
                Element foInlineElement = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:inline");
                document.appendChild(foInlineElement);
                Node n = childResults.nextNode();
                XmlUtils.treeCopy(n, (Node)foInlineElement);
                DocumentFragment docfrag = document.createDocumentFragment();
                docfrag.appendChild(document.getDocumentElement());
                return docfrag;
            }
            Element foPageNumber = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:page-number");
            document.appendChild(foPageNumber);
            DocumentFragment docfrag = document.createDocumentFragment();
            docfrag.appendChild(document.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
            log.error((Object)e);
            return null;
        }
    }

    public static DocumentFragment createBlockForInstrText(WordprocessingMLPackage wmlPackage, NodeIterator fldSimpleNodeIt, NodeIterator childResults) {
        org.docx4j.wml.Text field = null;
        try {
            field = (org.docx4j.wml.Text)XmlUtils.unmarshal(fldSimpleNodeIt.nextNode(), Context.jc, org.docx4j.wml.Text.class);
        }
        catch (JAXBException e1) {
            e1.printStackTrace();
        }
        return Conversion.handleField(field.getValue(), childResults);
    }

    public static String getPageNumberFormat(WordprocessingMLPackage wordmlPackage, int sectionNumber) {
        SectionWrapper sw = wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1);
        if (sw.getSectPr() == null) {
            return "1";
        }
        CTPageNumber pageNumber = sw.getSectPr().getPgNumType();
        if (pageNumber == null) {
            return "1";
        }
        NumberFormat format = pageNumber.getFmt();
        if (format == null) {
            return "1";
        }
        log.debug((Object)("w:pgNumType/@w:fmt=" + format.toString()));
        if (format == NumberFormat.DECIMAL) {
            return "1";
        }
        if (format == NumberFormat.UPPER_ROMAN) {
            return "I";
        }
        if (format == NumberFormat.LOWER_ROMAN) {
            return "i";
        }
        if (format == NumberFormat.UPPER_LETTER) {
            return "A";
        }
        if (format == NumberFormat.LOWER_LETTER) {
            return "a";
        }
        return "1";
    }

    public static String getPageNumberInitial(WordprocessingMLPackage wordmlPackage, int sectionNumber) {
        SectionWrapper sw = wordmlPackage.getDocumentModel().getSections().get(sectionNumber - 1);
        if (sw.getSectPr() == null) {
            return "1";
        }
        CTPageNumber pageNumber = sw.getSectPr().getPgNumType();
        if (pageNumber == null) {
            log.debug((Object)"No PgNumType");
            return "1";
        }
        BigInteger start = pageNumber.getStart();
        if (start == null) {
            return "1";
        }
        return start.toString();
    }

    static {
        try {
            StreamSource xsltSource = new StreamSource(ResourceUtils.getResource("org/docx4j/convert/out/pdf/viaXSLFO/docx2fo.xslt"));
            xslt = XmlUtils.getTransformerTemplate(xsltSource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
    }
}

