/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.NamespacePrefixMapperUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TextUtils {
    private static Logger log = Logger.getLogger(TextUtils.class);

    public static void extractText(Object o, Writer w) throws Exception {
        TextUtils.extractText(o, w, Context.jc);
    }

    public static void extractText(Object o, Writer w, JAXBContext jc) throws Exception {
        Marshaller marshaller = jc.createMarshaller();
        NamespacePrefixMapperUtils.setProperty(marshaller, NamespacePrefixMapperUtils.getPrefixMapper());
        marshaller.marshal(o, (ContentHandler)new TextExtractor(w));
    }

    public static void extractText(Object o, Writer w, JAXBContext jc, String uri, String local, Class declaredType) throws Exception {
        Marshaller marshaller = jc.createMarshaller();
        NamespacePrefixMapperUtils.setProperty(marshaller, NamespacePrefixMapperUtils.getPrefixMapper());
        marshaller.marshal((Object)new JAXBElement(new QName(uri, local), declaredType, o), (ContentHandler)new TextExtractor(w));
    }

    public static void main(String[] args) throws Exception {
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/Table.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        MainDocumentPart documentPart = wordMLPackage.getMainDocumentPart();
        Document wmlDocumentEl = (Document)documentPart.getJaxbElement();
        OutputStreamWriter out = new OutputStreamWriter(System.out);
        TextUtils.extractText(wmlDocumentEl, out);
        ((Writer)out).close();
    }

    static class TextExtractor
    extends DefaultHandler {
        private Writer out;

        public TextExtractor(Writer out) {
            this.out = out;
        }

        public void characters(char[] text, int start, int length) throws SAXException {
            try {
                this.out.write(text, start, length);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }
}

