/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.load.text;

import com.topologi.diffx.event.TextEvent;
import com.topologi.diffx.event.impl.SpaceEvent;
import com.topologi.diffx.event.impl.WordEvent;
import com.topologi.diffx.event.lang.CommonWordsEnglish;
import com.topologi.diffx.event.lang.Repertory;
import com.topologi.diffx.load.text.TextTokeniser;
import java.util.NoSuchElementException;

public final class CharactersTokeniser
implements TextTokeniser {
    private static final byte WHITE = 0;
    private static final byte TEXT = 1;
    private final CharSequence seq;
    private int max = -1;
    private int marker = 0;

    public CharactersTokeniser(CharSequence cs) throws NullPointerException {
        if (cs == null) {
            throw new NullPointerException("The string buffer cannot be null.");
        }
        this.seq = cs;
    }

    public int countTokens() {
        if (this.seq.length() == 0) {
            return 0;
        }
        if (this.max >= 0) {
            return this.max;
        }
        byte type = -1;
        int counter = 0;
        for (int i = 0; i < this.seq.length(); ++i) {
            if (type == CharactersTokeniser.getType(this.seq.charAt(i))) continue;
            type = CharactersTokeniser.getType(this.seq.charAt(i));
            ++counter;
        }
        this.max = counter;
        return counter;
    }

    public TextEvent nextToken() throws NoSuchElementException {
        if (this.marker == this.seq.length()) {
            throw new NoSuchElementException("All tokens have been returned.");
        }
        byte type = CharactersTokeniser.getType(this.seq.charAt(this.marker));
        for (int i = this.marker; i < this.seq.length(); ++i) {
            if (type == CharactersTokeniser.getType(this.seq.charAt(i))) continue;
            TextEvent e = this.newToken(type, this.marker, i);
            this.marker = i;
            return e;
        }
        TextEvent e = this.newToken(type, this.marker, this.seq.length());
        this.marker = this.seq.length();
        return e;
    }

    private static byte getType(char c) {
        return Character.isWhitespace(c) ? (byte)0 : 1;
    }

    private TextEvent newToken(byte type, int start, int end) {
        switch (type) {
            case 1: {
                String word = ((Object)this.seq.subSequence(start, end)).toString();
                if (CommonWordsEnglish.contains(word)) {
                    return CommonWordsEnglish.get(word);
                }
                return new WordEvent(word);
            }
            case 0: {
                return SpaceEvent.getInstance(this.seq.subSequence(start, end));
            }
        }
        throw new NoSuchElementException("Cannot create token of unknown type.");
    }

    public void useRepertory(Repertory repertory) {
    }
}

