/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.load;

import com.topologi.diffx.Docx4jDriver;
import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.CloseElementEvent;
import com.topologi.diffx.event.OpenElementEvent;
import com.topologi.diffx.event.impl.EventFactory;
import com.topologi.diffx.event.impl.ProcessingInstructionEvent;
import com.topologi.diffx.load.AttributeComparator;
import com.topologi.diffx.load.LoadingException;
import com.topologi.diffx.load.XMLRecorder;
import com.topologi.diffx.load.text.TextTokeniser;
import com.topologi.diffx.load.text.TokeniserFactory;
import com.topologi.diffx.sequence.EventSequence;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public final class DOMRecorder
implements XMLRecorder {
    private static final boolean DEBUG = false;
    private DiffXConfig config = new DiffXConfig();
    private transient EventFactory efactory = null;
    private transient TokeniserFactory tfactory = null;
    private transient EventSequence sequence = null;
    private transient int currentWeight = -1;
    private transient ArrayList weights = new ArrayList();
    private transient boolean isFragment = true;

    public DiffXConfig getConfig() {
        return this.config;
    }

    public void setConfig(DiffXConfig config) {
        this.config = config;
    }

    public EventSequence process(File file) throws LoadingException, IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        return this.process(new InputSource(in));
    }

    public EventSequence process(String xml) throws LoadingException {
        return this.process(new InputSource(new StringReader(xml)));
    }

    public EventSequence process(InputSource is) throws LoadingException {
        this.isFragment = false;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(this.config.isNamespaceAware());
        dbFactory.setExpandEntityReferences(true);
        dbFactory.setValidating(false);
        try {
            DocumentBuilder builder = dbFactory.newDocumentBuilder();
            Document document = builder.parse(is);
            return this.process(document);
        }
        catch (Exception ex) {
            throw new LoadingException(ex);
        }
    }

    public EventSequence process(Node node) throws LoadingException {
        this.efactory = new EventFactory(this.config.isNamespaceAware());
        this.tfactory = new TokeniserFactory(this.config);
        this.sequence = new EventSequence();
        this.loadNode(node);
        this.isFragment = true;
        return this.sequence;
    }

    private void loadNode(Node node) throws LoadingException {
        if (node instanceof Element) {
            this.load((Element)node);
        }
        if (node instanceof Text) {
            this.load((Text)node);
        } else if (node instanceof Attr) {
            this.load((Attr)node);
        } else if (node instanceof Document) {
            this.load((Document)node);
        } else if (node instanceof ProcessingInstruction) {
            this.load((ProcessingInstruction)node);
        }
    }

    private void load(Document document) throws LoadingException {
        this.load(document.getDocumentElement());
    }

    private void load(Element element) throws LoadingException {
        if (this.currentWeight > 0) {
            this.weights.add(new Integer(this.currentWeight));
        }
        this.currentWeight = 1;
        OpenElementEvent open = null;
        if (this.config.isNamespaceAware()) {
            String prefix;
            String uri = element.getNamespaceURI() == null ? "" : element.getNamespaceURI();
            String name = element.getLocalName();
            if (this.isFragment && (prefix = element.getPrefix()) != null && this.isFragment) {
                this.sequence.mapPrefix(uri, prefix);
            }
            open = this.efactory.makeOpenElement(uri, name);
        } else {
            open = this.efactory.makeOpenElement(null, element.getNodeName());
        }
        this.sequence.addEvent(open);
        NamedNodeMap atts = element.getAttributes();
        if (atts.getLength() == 1) {
            this.load((Attr)atts.item(0));
        } else if (atts.getLength() > 1) {
            int i;
            Object[] names = new String[atts.getLength()];
            for (i = 0; i < atts.getLength(); ++i) {
                Attr attr = (Attr)atts.item(i);
                names[i] = attr.getName();
            }
            Arrays.sort(names);
            for (i = 0; i < names.length; ++i) {
                this.load((Attr)atts.getNamedItem((String)names[i]));
            }
        }
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            this.loadNode(list.item(i));
        }
        CloseElementEvent close = this.efactory.makeCloseElement(open);
        this.sequence.addEvent(close);
        close.setWeight(this.currentWeight);
        open.setWeight(this.currentWeight);
        this.currentWeight += this.popWeight();
    }

    private void load(Text text) throws LoadingException {
        TextTokeniser ct = this.tfactory.makeTokeniser(text.getData());
        for (int i = 0; i < ct.countTokens(); ++i) {
            this.sequence.addEvent(ct.nextToken());
            ++this.currentWeight;
        }
    }

    private void load(ProcessingInstruction pi) throws LoadingException {
        this.sequence.addEvent(new ProcessingInstructionEvent(pi.getTarget(), pi.getData()));
        ++this.currentWeight;
    }

    private int popWeight() {
        if (this.weights.size() > 0) {
            return (Integer)this.weights.remove(this.weights.size() - 1);
        }
        return 0;
    }

    private void handleAttributes(Element element) {
        NamedNodeMap atts = element.getAttributes();
        if (atts.getLength() == 1) {
            this.load((Attr)atts.item(0));
        } else if (atts.getLength() > 1) {
            int i;
            AttributeEvent[] events = new AttributeEvent[atts.getLength()];
            for (i = 0; i < atts.getLength(); ++i) {
                Attr attr = (Attr)atts.item(i);
                events[i] = this.efactory.makeAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getNodeName(), attr.getValue());
            }
            Arrays.sort(events, new AttributeComparator());
            for (i = 0; i < events.length; ++i) {
                this.load(events[i]);
            }
        }
    }

    private void load(Attr attr) {
        this.load(this.efactory.makeAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getNodeName(), attr.getValue()));
    }

    private void load(AttributeEvent e) {
        if ("http://www.w3.org/2000/xmlns/".equals(e.getURI())) {
            if (e.getName().equals("xmlns") && e.getValue().equals("")) {
                Docx4jDriver.log("Ignoring xmlns:xmlns='' ");
                return;
            }
            this.sequence.mapPrefix(e.getValue(), e.getName());
        } else {
            e.setWeight(2);
            this.currentWeight += 2;
            this.sequence.addEvent(e);
        }
    }
}

