/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.format;

import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.OpenElementEvent;
import com.topologi.diffx.event.impl.CharEvent;
import com.topologi.diffx.event.impl.CharactersEventBase;
import com.topologi.diffx.event.impl.SpaceEvent;
import com.topologi.diffx.format.XMLDiffXFormatter;
import com.topologi.diffx.sequence.PrefixMapping;
import com.topologi.diffx.xml.NSAwareXMLWriter;
import com.topologi.diffx.xml.XMLWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;

public final class SmartXMLFormatter
implements XMLDiffXFormatter {
    private static final boolean DEBUG = false;
    private final XMLWriter xml;
    private DiffXConfig config = new DiffXConfig();
    private transient boolean writeXMLDeclaration = true;

    public SmartXMLFormatter() throws IOException {
        this(new PrintWriter(System.out));
    }

    public SmartXMLFormatter(Writer w) throws IOException {
        this.xml = new NSAwareXMLWriter(w, false);
        this.xml.xmlDecl();
        this.xml.setPrefixMapping("http://www.topologi.org/2004/Diff-X", "dfx");
        this.xml.setPrefixMapping("http://www.topologi.org/2004/Diff-X/Delete", "del");
        this.xml.setPrefixMapping("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "w");
        this.xml.setPrefixMapping("http://schemas.openxmlformats.org/drawingml/2006/main", "a");
        this.xml.setPrefixMapping("http://schemas.openxmlformats.org/drawingml/2006/picture", "pic");
        this.xml.setPrefixMapping("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "r");
        this.xml.setPrefixMapping("urn:schemas-microsoft-com:vml", "v");
        this.xml.setPrefixMapping("urn:schemas-microsoft-com:office:word", "w10");
        this.xml.setPrefixMapping("http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing", "wp");
    }

    public void format(DiffXEvent e) throws IOException {
        e.toXML(this.xml);
        if (e instanceof CharactersEventBase && this.config.isIgnoreWhiteSpace() && !this.config.isPreserveWhiteSpace()) {
            this.xml.writeXML(" ");
        }
        this.xml.flush();
    }

    public void insert(DiffXEvent e) throws IOException {
        if (e instanceof OpenElementEvent) {
            e.toXML(this.xml);
            this.xml.attribute("dfx:insert", "true");
        } else if (e == SpaceEvent.NEW_LINE) {
            e.toXML(this.xml);
        } else if (e instanceof CharactersEventBase) {
            this.xml.openElement("ins", false);
            e.toXML(this.xml);
            this.xml.closeElement();
            if (this.config.isIgnoreWhiteSpace() && !this.config.isPreserveWhiteSpace()) {
                this.xml.writeXML(" ");
            }
        } else if (e instanceof AttributeEvent) {
            e.toXML(this.xml);
        } else if (e instanceof CharEvent) {
            this.xml.openElement("ins", false);
            e.toXML(this.xml);
            this.xml.closeElement();
        } else {
            e.toXML(this.xml);
        }
        this.xml.flush();
    }

    public void delete(DiffXEvent e) throws IOException {
        if (e instanceof OpenElementEvent) {
            e.toXML(this.xml);
            this.xml.attribute("dfx:delete", "true");
        } else if (e == SpaceEvent.NEW_LINE) {
            e.toXML(this.xml);
        } else if (e instanceof CharactersEventBase) {
            this.xml.openElement("del", false);
            e.toXML(this.xml);
            this.xml.closeElement();
            if (this.config.isIgnoreWhiteSpace() && !this.config.isPreserveWhiteSpace()) {
                this.xml.writeXML(" ");
            }
        } else if (e instanceof AttributeEvent) {
            this.xml.attribute("del:" + ((AttributeEvent)e).getName(), ((AttributeEvent)e).getValue());
        } else if (e instanceof CharEvent) {
            this.xml.openElement("del", false);
            e.toXML(this.xml);
            this.xml.closeElement();
        } else {
            e.toXML(this.xml);
        }
        this.xml.flush();
    }

    public void setConfig(DiffXConfig config) {
        this.config = config;
    }

    public void setWriteXMLDeclaration(boolean show) {
        this.writeXMLDeclaration = show;
    }

    public void declarePrefixMapping(PrefixMapping mapping) {
        Enumeration uris = mapping.getURIs();
        while (uris.hasMoreElements()) {
            String uri = (String)uris.nextElement();
            this.xml.setPrefixMapping(uri, mapping.getPrefix(uri));
        }
    }
}

