/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.algorithm;

import com.topologi.diffx.event.CloseElementEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.OpenElementEvent;

final class ElementState {
    private transient OpenElementEvent[] openElements;
    private transient char[] openChanges;
    private transient int size;

    public ElementState(int initialCapacity) throws IllegalArgumentException {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.openElements = new OpenElementEvent[initialCapacity];
        this.openChanges = new char[initialCapacity];
    }

    public ElementState() {
        this(12);
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.openElements.length;
        if (minCapacity > oldCapacity) {
            OpenElementEvent[] oldElements = this.openElements;
            char[] oldChanges = this.openChanges;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.openElements = new OpenElementEvent[newCapacity];
            this.openChanges = new char[newCapacity];
            System.arraycopy(oldElements, 0, this.openElements, 0, this.size);
            System.arraycopy(oldChanges, 0, this.openChanges, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(OpenElementEvent element) {
        return this.indexOf(element) >= 0;
    }

    public int indexOf(OpenElementEvent element) {
        if (element == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.openElements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!element.equals(this.openElements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(OpenElementEvent element) {
        if (element == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.openElements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!element.equals(this.openElements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public OpenElementEvent current() {
        if (!this.isEmpty()) {
            return this.openElements[this.size - 1];
        }
        return null;
    }

    public char currentChange() {
        if (!this.isEmpty()) {
            return this.openChanges[this.size - 1];
        }
        return ' ';
    }

    public boolean matchCurrent(DiffXEvent e) {
        if (this.isEmpty()) {
            return false;
        }
        if (!(e instanceof CloseElementEvent)) {
            return false;
        }
        return ((CloseElementEvent)e).match(this.current());
    }

    public void insert(DiffXEvent e) {
        if (e instanceof OpenElementEvent) {
            this.push((OpenElementEvent)e, '+');
        } else if (e instanceof CloseElementEvent) {
            this.pop();
        }
    }

    public void format(DiffXEvent e) {
        if (e instanceof OpenElementEvent) {
            this.push((OpenElementEvent)e, '=');
        } else if (e instanceof CloseElementEvent) {
            this.pop();
        }
    }

    public void delete(DiffXEvent e) {
        if (e instanceof OpenElementEvent) {
            this.push((OpenElementEvent)e, '-');
        } else if (e instanceof CloseElementEvent) {
            this.pop();
        }
    }

    public boolean okFormat(DiffXEvent e) {
        if (!(e instanceof CloseElementEvent)) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        return ((CloseElementEvent)e).match(this.current()) && this.openChanges[this.size - 1] == '=';
    }

    public boolean okInsert(DiffXEvent e) {
        if (!(e instanceof CloseElementEvent)) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        return ((CloseElementEvent)e).match(this.current()) && this.openChanges[this.size - 1] == '+';
    }

    public boolean okDelete(DiffXEvent e) {
        if (!(e instanceof CloseElementEvent)) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        return ((CloseElementEvent)e).match(this.current()) && this.openChanges[this.size - 1] == '-';
    }

    private void push(OpenElementEvent e, char c) {
        this.ensureCapacity(this.size + 1);
        this.openElements[this.size] = e;
        this.openChanges[this.size] = c;
        ++this.size;
    }

    public OpenElementEvent pop() {
        if (this.size > 0) {
            --this.size;
            return this.openElements[this.size];
        }
        return null;
    }

    public OpenElementEvent get(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        return this.openElements[index];
    }

    private boolean add(OpenElementEvent o) {
        this.ensureCapacity(this.size + 1);
        this.openElements[this.size++] = o;
        return true;
    }

    public OpenElementEvent remove(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        OpenElementEvent oldValue = this.openElements[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.openElements, index + 1, this.openElements, index, numMoved);
        }
        this.openElements[--this.size] = null;
        return oldValue;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.openElements[i] = null;
        }
        this.size = 0;
    }

    private void checkRange(int index) throws IndexOutOfBoundsException {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }
}

