/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx;

import com.topologi.diffx.DiffXException;
import com.topologi.diffx.algorithm.DiffXFitopsy;
import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.format.SmartXMLFormatter;
import com.topologi.diffx.load.DOMRecorder;
import com.topologi.diffx.load.SAXRecorder;
import com.topologi.diffx.sequence.EventSequence;
import com.topologi.diffx.sequence.SequenceSlicer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class Main {
    private Main() {
    }

    public static boolean equivalent(File xml1, File xml2) throws DiffXException, IOException {
        SAXRecorder recorder = new SAXRecorder();
        EventSequence seq0 = recorder.process(xml1);
        EventSequence seq1 = recorder.process(xml2);
        return seq0.equals(seq1);
    }

    public static boolean equivalent(InputStream xml1, InputStream xml2) throws DiffXException, IOException {
        SAXRecorder recorder = new SAXRecorder();
        EventSequence seq0 = recorder.process(new InputSource(xml1));
        EventSequence seq1 = recorder.process(new InputSource(xml2));
        return seq0.equals(seq1);
    }

    public static boolean equivalent(Reader xml1, Reader xml2) throws DiffXException, IOException {
        SAXRecorder recorder = new SAXRecorder();
        EventSequence seq0 = recorder.process(new InputSource(xml1));
        EventSequence seq1 = recorder.process(new InputSource(xml2));
        return seq0.equals(seq1);
    }

    public static void diff(Node xml1, Node xml2, Writer out, DiffXConfig config) throws DiffXException, IOException {
        DOMRecorder loader = new DOMRecorder();
        if (config != null) {
            loader.setConfig(config);
        }
        EventSequence seq1 = loader.process(xml1);
        EventSequence seq2 = loader.process(xml2);
        Main.diff(seq1, seq2, out, config);
    }

    public static void diff(Reader xml1, Reader xml2, Writer out, DiffXConfig config) throws DiffXException, IOException {
        SAXRecorder recorder = new SAXRecorder();
        if (config != null) {
            recorder.setConfig(config);
        }
        EventSequence seq1 = recorder.process(new InputSource(xml1));
        EventSequence seq2 = recorder.process(new InputSource(xml2));
        Main.diff(seq1, seq2, out, config);
    }

    public static void diff(Reader xml1, Reader xml2, Writer out) throws DiffXException, IOException {
        SAXRecorder recorder = new SAXRecorder();
        EventSequence seq1 = recorder.process(new InputSource(xml1));
        EventSequence seq2 = recorder.process(new InputSource(xml2));
        Main.diff(seq1, seq2, out, new DiffXConfig());
    }

    public static void diff(InputStream xml1, InputStream xml2, OutputStream out) throws DiffXException, IOException {
        SAXRecorder recorder = new SAXRecorder();
        EventSequence seq1 = recorder.process(new InputSource(xml1));
        EventSequence seq2 = recorder.process(new InputSource(xml2));
        Main.diff(seq1, seq2, (Writer)new OutputStreamWriter(out), new DiffXConfig());
    }

    private static void diff(EventSequence seq1, EventSequence seq2, Writer out, DiffXConfig config) throws DiffXException, IOException {
        SmartXMLFormatter formatter = new SmartXMLFormatter(out);
        if (config != null) {
            formatter.setConfig(config);
        }
        Main.diff(seq1, seq2, formatter, config);
    }

    public static void diff(EventSequence seq1, EventSequence seq2, SmartXMLFormatter formatter, DiffXConfig config) throws DiffXException, IOException {
        formatter.declarePrefixMapping(seq1.getPrefixMapping());
        formatter.declarePrefixMapping(seq2.getPrefixMapping());
        if (config != null) {
            formatter.setConfig(config);
        }
        SequenceSlicer slicer = new SequenceSlicer(seq1, seq2);
        slicer.slice();
        slicer.formatStart(formatter);
        DiffXFitopsy df = new DiffXFitopsy(seq1, seq2);
        df.process(formatter);
        slicer.formatEnd(formatter);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            Main.usage();
        }
        try {
            File xml1 = new File(args[0]);
            File xml2 = new File(args[1]);
            Main.diff(new FileInputStream(xml1), new FileInputStream(xml2), System.out);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void usage() {
        System.err.println("Compare the SAX events returned by two XML files.");
        System.err.println("usage:");
        System.err.println("  Main [xml_file] [xml_file]");
        System.err.println("where:");
        System.err.println("  xml_file = Path to an XML file");
        System.exit(1);
    }
}

